/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourceBlock;
import com.liferay.portal.kernel.model.ResourceBlockPermissionsContainer;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.ResourceTypePermission;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.ResourceActionLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceActionLocalServiceImpl
extends ResourceActionLocalServiceBaseImpl {
    private static final Map<String, ResourceAction> _resourceActions = new ConcurrentHashMap<String, ResourceAction>();

    public ResourceAction addResourceAction(String name, String actionId, long bitwiseValue) {
        ResourceAction resourceAction = this.resourceActionPersistence.fetchByN_A(name, actionId);
        if (resourceAction == null) {
            long resourceActionId = this.counterLocalService.increment(ResourceAction.class.getName());
            resourceAction = this.resourceActionPersistence.create(resourceActionId);
            resourceAction.setName(name);
            resourceAction.setActionId(actionId);
            resourceAction.setBitwiseValue(bitwiseValue);
            this.resourceActionPersistence.update((BaseModel)resourceAction);
        }
        return resourceAction;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkResourceActions() {
        List resourceActions = this.resourceActionPersistence.findAll();
        for (ResourceAction resourceAction : resourceActions) {
            String key = this.encodeKey(resourceAction.getName(), resourceAction.getActionId());
            _resourceActions.put(key, resourceAction);
        }
    }

    public void checkResourceActions(String name, List<String> actionIds) {
        this.checkResourceActions(name, actionIds, false);
    }

    public void checkResourceActions(String name, List<String> actionIds, boolean addDefaultActions) {
        if (actionIds.size() > 64 || actionIds.size() == 64 && !actionIds.contains("VIEW")) {
            throw new SystemException("There are too many actions for resource " + name);
        }
        long availableBits = -2L;
        for (ResourceAction resourceAction : this.getResourceActions(name)) {
            availableBits &= resourceAction.getBitwiseValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        ArrayList<ResourceAction> newResourceActions = null;
        for (String actionId : actionIds) {
            String key = this.encodeKey(name, actionId);
            ResourceAction resourceAction = _resourceActions.get(key);
            if (resourceAction != null) continue;
            resourceAction = this.resourceActionPersistence.fetchByN_A(name, actionId);
            if (resourceAction == null) {
                long bitwiseValue = 1L;
                if (!actionId.equals("VIEW")) {
                    bitwiseValue = Long.lowestOneBit(availableBits);
                    availableBits ^= bitwiseValue;
                }
                try {
                    resourceAction = this.resourceActionLocalService.addResourceAction(name, actionId, bitwiseValue);
                }
                catch (Throwable t) {
                    resourceAction = this.resourceActionLocalService.addResourceAction(name, actionId, bitwiseValue);
                }
                if (newResourceActions == null) {
                    newResourceActions = new ArrayList<ResourceAction>();
                }
                newResourceActions.add(resourceAction);
            }
            _resourceActions.put(key, resourceAction);
        }
        if (!addDefaultActions || newResourceActions == null) {
            return;
        }
        List list = ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
        List guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions((String)name);
        long guestBitwiseValue = 0L;
        long ownerBitwiseValue = 0L;
        long siteMemberBitwiseValue = 0L;
        for (ResourceAction resourceAction : newResourceActions) {
            String actionId = resourceAction.getActionId();
            if (guestDefaultActions.contains(actionId)) {
                guestBitwiseValue |= resourceAction.getBitwiseValue();
            }
            ownerBitwiseValue |= resourceAction.getBitwiseValue();
            if (!list.contains(actionId)) continue;
            siteMemberBitwiseValue |= resourceAction.getBitwiseValue();
        }
        if (guestBitwiseValue > 0L) {
            this.resourcePermissionLocalService.addResourcePermissions(name, "Guest", 4, guestBitwiseValue);
        }
        if (ownerBitwiseValue > 0L) {
            this.resourcePermissionLocalService.addResourcePermissions(name, "Owner", 4, ownerBitwiseValue);
        }
        if (siteMemberBitwiseValue > 0L) {
            this.resourcePermissionLocalService.addResourcePermissions(name, "Site Member", 4, siteMemberBitwiseValue);
        }
    }

    @Override
    public ResourceAction deleteResourceAction(long resourceActionId) throws PortalException {
        return this.deleteResourceAction(this.resourceActionPersistence.findByPrimaryKey(resourceActionId));
    }

    @Override
    public ResourceAction deleteResourceAction(ResourceAction resourceAction) {
        final String name = resourceAction.getName();
        final long bitwiseValue = resourceAction.getBitwiseValue();
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property nameProperty = PropertyFactoryUtil.forName((String)"name");
                dynamicQuery.add(nameProperty.eq((Object)name));
            }
        };
        for (Company company : this.companyLocalService.getCompanies()) {
            if (this.resourceBlockLocalService.isSupported(resourceAction.getName())) {
                ActionableDynamicQuery resourceBlockActionableDynamicQuery = this.resourceBlockLocalService.getActionableDynamicQuery();
                resourceBlockActionableDynamicQuery.setAddCriteriaMethod(addCriteriaMethod);
                resourceBlockActionableDynamicQuery.setCompanyId(company.getCompanyId());
                resourceBlockActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ResourceBlock>(){

                    public void performAction(ResourceBlock resourceBlock) {
                        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = ResourceActionLocalServiceImpl.this.resourceBlockPermissionLocalService.getResourceBlockPermissionsContainer(resourceBlock.getResourceBlockId());
                        Set roleIds = resourceBlockPermissionsContainer.getRoleIds();
                        Iterator iterator = roleIds.iterator();
                        while (iterator.hasNext()) {
                            long roleId = (Long)iterator.next();
                            resourceBlockPermissionsContainer.removePermission(roleId, bitwiseValue);
                            ResourceActionLocalServiceImpl.this.resourceBlockPermissionLocalService.updateResourceBlockPermission(resourceBlock.getResourceBlockId(), roleId, bitwiseValue, 2);
                        }
                        resourceBlock.setPermissionsHash(resourceBlockPermissionsContainer.getPermissionsHash());
                        ResourceActionLocalServiceImpl.this.resourceBlockPersistence.update((BaseModel)resourceBlock);
                    }
                });
                try {
                    resourceBlockActionableDynamicQuery.performActions();
                }
                catch (PortalException pe) {
                    throw new SystemException((Throwable)pe);
                }
                ActionableDynamicQuery resourceTypeActionableDynamicQuery = this.resourceTypePermissionLocalService.getActionableDynamicQuery();
                resourceTypeActionableDynamicQuery.setAddCriteriaMethod(addCriteriaMethod);
                resourceTypeActionableDynamicQuery.setCompanyId(company.getCompanyId());
                resourceTypeActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ResourceTypePermission>(){

                    public void performAction(ResourceTypePermission resourceTypePermission) {
                        long actionIds = resourceTypePermission.getActionIds();
                        if ((actionIds & bitwiseValue) != 0L) {
                            resourceTypePermission.setActionIds(actionIds & (bitwiseValue ^ 0xFFFFFFFFFFFFFFFFL));
                            ResourceActionLocalServiceImpl.this.resourceTypePermissionPersistence.update((BaseModel)resourceTypePermission);
                        }
                    }
                });
                try {
                    resourceTypeActionableDynamicQuery.performActions();
                    continue;
                }
                catch (PortalException pe) {
                    throw new SystemException((Throwable)pe);
                }
            }
            ActionableDynamicQuery actionableDynamicQuery = this.resourcePermissionLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(addCriteriaMethod);
            actionableDynamicQuery.setCompanyId(company.getCompanyId());
            actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ResourcePermission>(){

                public void performAction(ResourcePermission resourcePermission) {
                    long actionIds = resourcePermission.getActionIds();
                    if ((actionIds & bitwiseValue) != 0L) {
                        resourcePermission.setActionIds(actionIds &= bitwiseValue ^ 0xFFFFFFFFFFFFFFFFL);
                        resourcePermission.setViewActionId(actionIds % 2L == 1L);
                        ResourceActionLocalServiceImpl.this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
                    }
                }
            });
            try {
                actionableDynamicQuery.performActions();
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
        _resourceActions.remove(this.encodeKey(resourceAction.getName(), resourceAction.getActionId()));
        this.resourceActionPersistence.remove((BaseModel)resourceAction);
        PermissionCacheUtil.clearCache();
        return resourceAction;
    }

    @Skip
    public ResourceAction fetchResourceAction(String name, String actionId) {
        String key = this.encodeKey(name, actionId);
        return _resourceActions.get(key);
    }

    @Skip
    public ResourceAction getResourceAction(String name, String actionId) throws PortalException {
        String key = this.encodeKey(name, actionId);
        ResourceAction resourceAction = _resourceActions.get(key);
        if (resourceAction == null) {
            throw new NoSuchResourceActionException(key);
        }
        return resourceAction;
    }

    public List<ResourceAction> getResourceActions(String name) {
        return this.resourceActionPersistence.findByName(name);
    }

    public int getResourceActionsCount(String name) {
        return this.resourceActionPersistence.countByName(name);
    }

    protected String encodeKey(String name, String actionId) {
        return name.concat("#").concat(actionId);
    }
}

