/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchAccountException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.AccountPersistence;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.impl.AccountImpl;
import com.liferay.portal.model.impl.AccountModelImpl;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class AccountPersistenceImpl
extends BasePersistenceImpl<Account>
implements AccountPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AccountImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountModelImpl.FINDER_CACHE_ENABLED, AccountImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountModelImpl.FINDER_CACHE_ENABLED, AccountImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    protected EntityCache entityCache;
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ACCOUNT = "SELECT account FROM Account account";
    private static final String _SQL_SELECT_ACCOUNT_WHERE_PKS_IN = "SELECT account FROM Account account WHERE accountId IN (";
    private static final String _SQL_COUNT_ACCOUNT = "SELECT COUNT(account) FROM Account account";
    private static final String _ORDER_BY_ENTITY_ALIAS = "account.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Account exists with the primary key ";
    private static final Log _log = LogFactoryUtil.getLog(AccountPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type", "size"});

    public AccountPersistenceImpl() {
        block2: {
            this.entityCache = EntityCacheUtil.getEntityCache();
            this.finderCache = FinderCacheUtil.getFinderCache();
            this.setModelClass(Account.class);
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                HashMap<String, String> dbColumnNames = new HashMap<String, String>();
                dbColumnNames.put("type", "type_");
                dbColumnNames.put("size", "size_");
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cacheResult(Account account) {
        this.entityCache.putResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()), (Serializable)account);
        account.resetOriginalValues();
    }

    public void cacheResult(List<Account> accounts) {
        for (Account account : accounts) {
            if (this.entityCache.getResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey())) == null) {
                this.cacheResult(account);
                continue;
            }
            account.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AccountImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Account account) {
        this.entityCache.removeResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<Account> accounts) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Account account : accounts) {
            this.entityCache.removeResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()));
        }
    }

    public Account create(long accountId) {
        AccountImpl account = new AccountImpl();
        account.setNew(true);
        account.setPrimaryKey(accountId);
        account.setCompanyId(this.companyProvider.getCompanyId());
        return account;
    }

    public Account remove(long accountId) throws NoSuchAccountException {
        return this.remove(Long.valueOf(accountId));
    }

    public Account remove(Serializable primaryKey) throws NoSuchAccountException {
        Session session = null;
        try {
            session = this.openSession();
            Account account = (Account)session.get(AccountImpl.class, primaryKey);
            if (account == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Account account2 = (Account)this.remove((BaseModel)account);
            return account2;
        }
        catch (NoSuchAccountException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Account removeImpl(Account account) {
        account = this.toUnwrappedModel(account);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)account)) {
                account = (Account)session.get(AccountImpl.class, account.getPrimaryKeyObj());
            }
            if (account != null) {
                session.delete((Object)account);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (account != null) {
            this.clearCache(account);
        }
        return account;
    }

    public Account updateImpl(Account account) {
        account = this.toUnwrappedModel(account);
        boolean isNew = account.isNew();
        AccountModelImpl accountModelImpl = (AccountModelImpl)account;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && account.getCreateDate() == null) {
            if (serviceContext == null) {
                account.setCreateDate(now);
            } else {
                account.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!accountModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                account.setModifiedDate(now);
            } else {
                account.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (account.isNew()) {
                session.save((Object)account);
                account.setNew(false);
            } else {
                account = (Account)session.merge((Object)account);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew) {
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        }
        this.entityCache.putResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()), (Serializable)account, false);
        account.resetOriginalValues();
        return account;
    }

    protected Account toUnwrappedModel(Account account) {
        if (account instanceof AccountImpl) {
            return account;
        }
        AccountImpl accountImpl = new AccountImpl();
        accountImpl.setNew(account.isNew());
        accountImpl.setPrimaryKey(account.getPrimaryKey());
        accountImpl.setMvccVersion(account.getMvccVersion());
        accountImpl.setAccountId(account.getAccountId());
        accountImpl.setCompanyId(account.getCompanyId());
        accountImpl.setUserId(account.getUserId());
        accountImpl.setUserName(account.getUserName());
        accountImpl.setCreateDate(account.getCreateDate());
        accountImpl.setModifiedDate(account.getModifiedDate());
        accountImpl.setParentAccountId(account.getParentAccountId());
        accountImpl.setName(account.getName());
        accountImpl.setLegalName(account.getLegalName());
        accountImpl.setLegalId(account.getLegalId());
        accountImpl.setLegalType(account.getLegalType());
        accountImpl.setSicCode(account.getSicCode());
        accountImpl.setTickerSymbol(account.getTickerSymbol());
        accountImpl.setIndustry(account.getIndustry());
        accountImpl.setType(account.getType());
        accountImpl.setSize(account.getSize());
        return accountImpl;
    }

    public Account findByPrimaryKey(Serializable primaryKey) throws NoSuchAccountException {
        Account account = this.fetchByPrimaryKey(primaryKey);
        if (account == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return account;
    }

    public Account findByPrimaryKey(long accountId) throws NoSuchAccountException {
        return this.findByPrimaryKey(Long.valueOf(accountId));
    }

    public Account fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Account account = (Account)serializable;
        if (account == null) {
            Session session = null;
            try {
                session = this.openSession();
                account = (Account)session.get(AccountImpl.class, primaryKey);
                if (account != null) {
                    this.cacheResult(account);
                } else {
                    this.entityCache.putResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return account;
    }

    public Account fetchByPrimaryKey(long accountId) {
        return this.fetchByPrimaryKey(Long.valueOf(accountId));
    }

    public Map<Serializable, Account> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Account> map = new HashMap<Serializable, Account>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Account account = this.fetchByPrimaryKey(primaryKey);
            if (account != null) {
                map.put(primaryKey, account);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Account)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_ACCOUNT_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Account account : q.list()) {
                map.put(account.getPrimaryKeyObj(), account);
                this.cacheResult(account);
                uncachedPrimaryKeys.remove(account.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Account> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Account> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Account> findAll(int start, int end, OrderByComparator<Account> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Account> findAll(int start, int end, OrderByComparator<Account> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_ACCOUNT);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ACCOUNT;
                if (pagination) {
                    sql = sql.concat(" ORDER BY account.accountId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Account account : this.findAll()) {
            this.remove((BaseModel)account);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_ACCOUNT);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AccountModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(AccountImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

