/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.security.permission.RolePermissions;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.GroupFinder;
import com.liferay.portal.kernel.service.persistence.GroupUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.service.persistence.impl.GroupFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GroupFinderImpl
extends GroupFinderBaseImpl
implements GroupFinder {
    public static final String COUNT_BY_LAYOUTS = GroupFinder.class.getName() + ".countByLayouts";
    public static final String COUNT_BY_GROUP_ID = GroupFinder.class.getName() + ".countByGroupId";
    public static final String COUNT_BY_C_PG_N_D = GroupFinder.class.getName() + ".countByC_PG_N_D";
    public static final String FIND_BY_ACTIVE_GROUPS = GroupFinder.class.getName() + ".findByActiveGroups";
    public static final String FIND_BY_COMPANY_ID = GroupFinder.class.getName() + ".findByCompanyId";
    public static final String FIND_BY_LAYOUTS = GroupFinder.class.getName() + ".findByLayouts";
    public static final String FIND_BY_LIVE_GROUPS = GroupFinder.class.getName() + ".findByLiveGroups";
    public static final String FIND_BY_NO_LAYOUTS = GroupFinder.class.getName() + ".findByNoLayouts";
    public static final String FIND_BY_NULL_FRIENDLY_URL = GroupFinder.class.getName() + ".findByNullFriendlyURL";
    public static final String FIND_BY_SYSTEM = GroupFinder.class.getName() + ".findBySystem";
    public static final String FIND_BY_C_P = GroupFinder.class.getName() + ".findByC_P";
    public static final String FIND_BY_C_GK = GroupFinder.class.getName() + ".findByC_GK";
    public static final String FIND_BY_L_TS_S_RSGC = GroupFinder.class.getName() + ".findByL_TS_S_RSGC";
    public static final String FIND_BY_C_PG_N_D = GroupFinder.class.getName() + ".findByC_PG_N_D";
    public static final String JOIN_BY_ACTIVE = GroupFinder.class.getName() + ".joinByActive";
    public static final String JOIN_BY_CREATOR_USER_ID = GroupFinder.class.getName() + ".joinByCreatorUserId";
    public static final String JOIN_BY_GROUP_ORG = GroupFinder.class.getName() + ".joinByGroupOrg";
    public static final String JOIN_BY_GROUPS_ORGS = GroupFinder.class.getName() + ".joinByGroupsOrgs";
    public static final String JOIN_BY_GROUPS_ROLES = GroupFinder.class.getName() + ".joinByGroupsRoles";
    public static final String JOIN_BY_GROUPS_USER_GROUPS = GroupFinder.class.getName() + ".joinByGroupsUserGroups";
    public static final String JOIN_BY_LAYOUT_SET = GroupFinder.class.getName() + ".joinByLayoutSet";
    public static final String JOIN_BY_MANUAL_MEMBERSHIP = GroupFinder.class.getName() + ".joinByManualMembership";
    public static final String JOIN_BY_MEMBERSHIP_RESTRICTION = GroupFinder.class.getName() + ".joinByMembershipRestriction";
    public static final String JOIN_BY_PAGE_COUNT = GroupFinder.class.getName() + ".joinByPageCount";
    public static final String JOIN_BY_ROLE_RESOURCE_PERMISSIONS = GroupFinder.class.getName() + ".joinByRoleResourcePermissions";
    public static final String JOIN_BY_ROLE_RESOURCE_TYPE_PERMISSIONS = GroupFinder.class.getName() + ".joinByRoleResourceTypePermissions";
    public static final String JOIN_BY_SITE = GroupFinder.class.getName() + ".joinBySite";
    public static final String JOIN_BY_TYPE = GroupFinder.class.getName() + ".joinByType";
    public static final String JOIN_BY_USER_GROUP_ROLE = GroupFinder.class.getName() + ".joinByUserGroupRole";
    public static final String JOIN_BY_USERS_GROUPS = GroupFinder.class.getName() + ".joinByUsersGroups";
    private final LinkedHashMap<String, Object> _emptyLinkedHashMap = new LinkedHashMap(0);
    private final Map<String, String> _findByCompanyIdSQLCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> _findByC_C_PG_N_DSQLCache = new ConcurrentHashMap<String, String>();
    private volatile long[] _groupOrganizationClassNameIds;
    private volatile Map<String, String> _joinMap;
    private final Map<String, String> _replaceJoinAndWhereSQLCache = new ConcurrentHashMap<String, String>();
    private volatile Long _userGroupClassNameId;
    private volatile Map<String, String> _whereMap;

    public int countByLayouts(long companyId, long parentGroupId, boolean site) {
        return this.countByLayouts(companyId, parentGroupId, site, null);
    }

    public int countByLayouts(long companyId, long parentGroupId, boolean site, Boolean active) {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_LAYOUTS);
            sql = active != null ? StringUtil.replace((String)sql, (String)"[$ACTIVE$]", (String)"AND (Group_.active_ = ?)") : StringUtil.replace((String)sql, (String)"[$ACTIVE$]", (String)"");
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(parentGroupId);
            qPos.add(site);
            if (active != null) {
                qPos.add(active);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_U(long groupId, long userId, boolean inherit) {
        LinkedHashMap<String, Object> params1 = new LinkedHashMap<String, Object>();
        params1.put("usersGroups", userId);
        LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
        params2.put("groupOrg", userId);
        LinkedHashMap<String, Object> params3 = new LinkedHashMap<String, Object>();
        params3.put("groupsOrgs", userId);
        LinkedHashMap<String, Object> params4 = new LinkedHashMap<String, Object>();
        params4.put("groupsUserGroups", userId);
        Session session = null;
        try {
            session = this.openSession();
            int count = this.countByGroupId(session, groupId, params1);
            if (inherit) {
                count += this.countByGroupId(session, groupId, params2);
                count += this.countByGroupId(session, groupId, params3);
                count += this.countByGroupId(session, groupId, params4);
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_C_PG_N_D(long companyId, long[] classNameIds, long parentGroupId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator) {
        String parentGroupIdComparator = "=";
        if (parentGroupId == -1L) {
            parentGroupIdComparator = "!=";
        }
        names = CustomSQLUtil.keywords((String[])names);
        descriptions = CustomSQLUtil.keywords((String[])descriptions);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Long userId = (Long)params.get("usersGroups");
        boolean doUnion = Validator.isNotNull((Long)userId);
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params3 = new LinkedHashMap<String, Object>(params1);
            params4 = new LinkedHashMap<String, Object>(params1);
            this._populateUnionParams(userId, classNameIds, params1, params2, params3, params4);
        } else if (classNameIds != null) {
            params1.put("classNameIds", classNameIds);
        }
        Session session = null;
        try {
            session = this.openSession();
            HashSet<Long> groupIds = new HashSet<Long>();
            groupIds.addAll(this.countByC_PG_N_D(session, companyId, parentGroupId, parentGroupIdComparator, names, descriptions, params1, andOperator));
            if (doUnion) {
                if (params2.containsKey("classNameIds")) {
                    groupIds.addAll(this.countByC_PG_N_D(session, companyId, parentGroupId, parentGroupIdComparator, names, descriptions, params2, andOperator));
                }
                if (params3.containsKey("classNameIds")) {
                    groupIds.addAll(this.countByC_PG_N_D(session, companyId, parentGroupId, parentGroupIdComparator, names, descriptions, params3, andOperator));
                }
                if (params4.containsKey("classNameIds")) {
                    groupIds.addAll(this.countByC_PG_N_D(session, companyId, parentGroupId, parentGroupIdComparator, names, descriptions, params4, andOperator));
                }
            }
            int n = groupIds.size();
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findByActiveGroupIds(long userId) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ACTIVE_GROUPS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByCompanyId(long companyId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> obc) {
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Long userId = (Long)params.get("usersGroups");
        boolean inherit = GetterUtil.getBoolean((Object)params.get("inherit"), (boolean)true);
        boolean doUnion = false;
        if (Validator.isNotNull((Long)userId) && inherit) {
            doUnion = true;
        }
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params3 = new LinkedHashMap<String, Object>(params1);
            params4 = new LinkedHashMap<String, Object>(params1);
            this._populateUnionParams(userId, null, params1, params2, params3, params4);
        } else {
            params1.put("classNameIds", this._getGroupOrganizationClassNameIds());
        }
        String sqlKey = this._buildSQLCacheKey(obc, params1, params2, params3, params4);
        String sql = this._findByCompanyIdSQLCache.get(sqlKey);
        if (sql == null) {
            String findByCompanyIdSQL = CustomSQLUtil.get((String)FIND_BY_COMPANY_ID);
            if (params.get("active") == Boolean.TRUE) {
                findByCompanyIdSQL = StringUtil.replace((String)findByCompanyIdSQL, (String)"(Group_.liveGroupId = 0) AND", (String)"");
            }
            findByCompanyIdSQL = this.replaceOrderBy(findByCompanyIdSQL, obc);
            StringBundler sb = new StringBundler(11);
            sb.append("(");
            sb.append(this.replaceJoinAndWhere(findByCompanyIdSQL, params1));
            if (doUnion) {
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByCompanyIdSQL, params2));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByCompanyIdSQL, params3));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByCompanyIdSQL, params4));
            }
            sb.append(")");
            if (obc != null) {
                sb.append(" ORDER BY ");
                sb.append(obc.toString());
            }
            sql = sb.toString();
            this._findByCompanyIdSQLCache.put(sqlKey, sql);
        }
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params1);
            qPos.add(companyId);
            if (doUnion) {
                this.setJoin(qPos, params2);
                qPos.add(companyId);
                this.setJoin(qPos, params3);
                qPos.add(companyId);
                this.setJoin(qPos, params4);
                qPos.add(companyId);
            }
            List groupIds = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<Group> groups = new ArrayList<Group>(groupIds.size());
            for (Long groupId : groupIds) {
                Group group = GroupUtil.findByPrimaryKey((long)groupId);
                groups.add(group);
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByLayouts(long companyId, long parentGroupId, boolean site, Boolean active, int start, int end, OrderByComparator<Group> obc) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_LAYOUTS);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, obc);
            sql = active != null ? StringUtil.replace((String)sql, (String)"[$ACTIVE$]", (String)"AND (Group_.active_ = ?)") : StringUtil.replace((String)sql, (String)"[$ACTIVE$]", (String)"");
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(parentGroupId);
            qPos.add(site);
            if (active != null) {
                qPos.add(active);
            }
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Deprecated
    public List<Group> findByLayouts(long companyId, long parentGroupId, boolean site, int start, int end) {
        return this.findByLayouts(companyId, parentGroupId, site, null, start, end, null);
    }

    public List<Group> findByLayouts(long companyId, long parentGroupId, boolean site, int start, int end, OrderByComparator<Group> obc) {
        return this.findByLayouts(companyId, parentGroupId, site, null, start, end, obc);
    }

    public List<Group> findByLiveGroups() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_LIVE_GROUPS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByNoLayouts(long classNameId, boolean privateLayout, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_LAYOUTS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(classNameId);
            qPos.add(privateLayout);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByNullFriendlyURL() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NULL_FRIENDLY_URL);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findBySystem(long companyId) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_SYSTEM);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findByC_P(long companyId, long parentGroupId, long previousGroupId, int size) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_P);
            if (previousGroupId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"(groupId > ?) AND", (String)"");
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (previousGroupId > 0L) {
                qPos.add(previousGroupId);
            }
            qPos.add(companyId);
            qPos.add(parentGroupId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)0, (int)size);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Group findByC_GK(long companyId, String groupKey) throws NoSuchGroupException {
        groupKey = StringUtil.lowerCase((String)groupKey);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_GK);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(groupKey);
            List groups = q.list();
            if (!groups.isEmpty()) {
                Group group = (Group)groups.get(0);
                return group;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("No Group exists with the key {companyId=");
        sb.append(companyId);
        sb.append(", groupKey=");
        sb.append(groupKey);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public List<Group> findByL_TS_S_RSGC(long liveGroupId, String typeSettings, boolean site, int remoteStagingGroupCount) {
        String sql = CustomSQLUtil.get((String)FIND_BY_L_TS_S_RSGC);
        Session session = null;
        try {
            List groups;
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(liveGroupId);
            qPos.add(StringUtil.quote((String)typeSettings, (String)"%"));
            qPos.add(site);
            qPos.add(remoteStagingGroupCount);
            List list = groups = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByC_C_PG_N_D(long companyId, long[] classNameIds, long parentGroupId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> obc) {
        String parentGroupIdComparator = "=";
        if (parentGroupId == -1L) {
            parentGroupIdComparator = "!=";
        }
        names = CustomSQLUtil.keywords((String[])names);
        descriptions = CustomSQLUtil.keywords((String[])descriptions);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Long userId = (Long)params.get("usersGroups");
        boolean inherit = GetterUtil.getBoolean((Object)params.get("inherit"), (boolean)true);
        boolean doUnion = false;
        if (Validator.isNotNull((Long)userId) && inherit) {
            doUnion = true;
        }
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params3 = new LinkedHashMap<String, Object>(params1);
            params4 = new LinkedHashMap<String, Object>(params1);
            this._populateUnionParams(userId, classNameIds, params1, params2, params3, params4);
        } else if (classNameIds != null) {
            params1.put("classNameIds", classNameIds);
        }
        if (obc == null) {
            obc = new GroupNameComparator(true);
        }
        String sql = null;
        String sqlKey = null;
        if (this._isCacheableSQL(classNameIds)) {
            sqlKey = this._buildSQLCacheKey((OrderByComparator<Group>)obc, params1, params2, params3, params4);
            sql = this._findByC_C_PG_N_DSQLCache.get(sqlKey);
        }
        if (sql == null) {
            String findByC_PG_N_D_SQL = CustomSQLUtil.get((String)FIND_BY_C_PG_N_D);
            findByC_PG_N_D_SQL = this.replaceOrderBy(findByC_PG_N_D_SQL, (OrderByComparator<Group>)obc);
            StringBundler sb = new StringBundler(10);
            sb.append("(");
            sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params1));
            if (doUnion) {
                if (params2.containsKey("classNameIds")) {
                    sb.append(") UNION (");
                    sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params2));
                }
                if (params3.containsKey("classNameIds")) {
                    sb.append(") UNION (");
                    sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params3));
                }
                if (params4.containsKey("classNameIds")) {
                    sb.append(") UNION (");
                    sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params4));
                }
            }
            sb.append(") ORDER BY ");
            sb.append(obc.toString());
            sql = sb.toString();
            if (sqlKey != null) {
                this._findByC_C_PG_N_DSQLCache.put(sqlKey, sql);
            }
        }
        sql = parentGroupIdComparator.equals("=") ? StringUtil.replace(sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)"=") : StringUtil.replace(sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)"!=");
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Group_.name)", (String)"LIKE", (boolean)false, (String[])names);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Group_.description)", (String)"LIKE", (boolean)true, (String[])descriptions);
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params1);
            qPos.add(companyId);
            qPos.add(parentGroupId);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            if (doUnion) {
                this.setJoin(qPos, params2);
                qPos.add(companyId);
                qPos.add(parentGroupId);
                qPos.add(names, 2);
                qPos.add(descriptions, 2);
                this.setJoin(qPos, params3);
                qPos.add(companyId);
                qPos.add(parentGroupId);
                qPos.add(names, 2);
                qPos.add(descriptions, 2);
                this.setJoin(qPos, params4);
                qPos.add(companyId);
                qPos.add(parentGroupId);
                qPos.add(names, 2);
                qPos.add(descriptions, 2);
            }
            List groupIds = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<Group> groups = new ArrayList<Group>(groupIds.size());
            for (Long groupId : groupIds) {
                Group group = GroupUtil.findByPrimaryKey((long)groupId);
                groups.add(group);
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int countByGroupId(Session session, long groupId, Map<String, Object> params) throws Exception {
        Long count;
        String sql = CustomSQLUtil.get((String)COUNT_BY_GROUP_ID);
        sql = this.replaceJoinAndWhere(sql, params);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.addScalar("COUNT_VALUE", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(groupId);
        Iterator itr = q.iterate();
        if (itr.hasNext() && (count = (Long)itr.next()) != null) {
            return count.intValue();
        }
        return 0;
    }

    protected List<Long> countByC_PG_N_D(Session session, long companyId, long parentGroupId, String parentGroupIdComparator, String[] names, String[] descriptions, Map<String, Object> params, boolean andOperator) throws Exception {
        String sql = CustomSQLUtil.get((String)COUNT_BY_C_PG_N_D);
        sql = parentGroupIdComparator.equals("=") ? StringUtil.replace((String)sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)"=") : StringUtil.replace((String)sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)"!=");
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Group_.name)", (String)"LIKE", (boolean)false, (String[])names);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Group_.description)", (String)"LIKE", (boolean)true, (String[])descriptions);
        sql = this.replaceJoinAndWhere(sql, params);
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.addScalar("groupId", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(companyId);
        qPos.add(parentGroupId);
        qPos.add(names, 2);
        qPos.add(descriptions, 2);
        return q.list(true);
    }

    protected String getJoin(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Map<String, String> joinMap;
            String joinValue;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Validator.isNull((Object)value)) continue;
            if (key.equals("rolePermissions")) {
                RolePermissions rolePermissions = (RolePermissions)value;
                key = ResourceBlockLocalServiceUtil.isSupported((String)rolePermissions.getName()) ? "rolePermissions_6_block" : "rolePermissions_6";
            }
            if (!Validator.isNotNull((String)(joinValue = (joinMap = this._getJoinMap()).get(key)))) continue;
            sb.append(joinValue);
        }
        return sb.toString();
    }

    protected String getWhere(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Map<String, String> whereMap;
            String whereValue;
            String key = entry.getKey();
            if (key.equals("classNameIds")) {
                if (entry.getValue() instanceof Long) {
                    sb.append("(Group_.classNameId = ?) AND ");
                    continue;
                }
                sb.append("(");
                long[] classNameIds = (long[])entry.getValue();
                for (int i = 0; i < classNameIds.length; ++i) {
                    sb.append("(Group_.classNameId = ?) OR ");
                }
                sb.setStringAt("(Group_.classNameId = ?)) AND ", sb.index() - 1);
                continue;
            }
            if (key.equals("excludedGroupIds")) {
                List excludedGroupIds = (List)entry.getValue();
                if (excludedGroupIds.isEmpty()) continue;
                sb.append("(");
                for (int i = 0; i < excludedGroupIds.size(); ++i) {
                    sb.append("(Group_.groupId != ?) AND ");
                }
                sb.setStringAt("(Group_.groupId != ?)) AND ", sb.index() - 1);
                continue;
            }
            if (key.equals("groupsTree")) {
                List groupsTree = (List)entry.getValue();
                if (groupsTree.isEmpty()) continue;
                sb.append("(");
                for (int i = 0; i < groupsTree.size(); ++i) {
                    sb.append("(Group_.treePath LIKE ?) OR ");
                }
                sb.setStringAt("(Group_.treePath LIKE ?)) AND ", sb.index() - 1);
                continue;
            }
            if (key.equals("types")) {
                List types = (List)entry.getValue();
                if (types.isEmpty()) continue;
                sb.append("(");
                for (int i = 0; i < types.size(); ++i) {
                    sb.append("(Group_.type_ = ?) OR ");
                }
                sb.setStringAt("(Group_.type_ = ?)) AND ", sb.index() - 1);
                continue;
            }
            if (key.equals("rolePermissions")) {
                RolePermissions rolePermissions = (RolePermissions)entry.getValue();
                key = ResourceBlockLocalServiceUtil.isSupported((String)rolePermissions.getName()) ? "rolePermissions_6_block" : "rolePermissions_6";
            }
            if (!Validator.isNotNull((String)(whereValue = (whereMap = this._getWhereMap()).get(key)))) continue;
            sb.append(whereValue);
        }
        return sb.toString();
    }

    protected String replaceJoinAndWhere(String sql, Map<String, Object> params) {
        if (params.isEmpty()) {
            return StringUtil.removeSubstrings((String)sql, (String[])new String[]{"[$JOIN$]", "[$WHERE$]"});
        }
        String cacheKey = this._buildSQLCacheKey(sql, params);
        String resultSQL = this._replaceJoinAndWhereSQLCache.get(cacheKey);
        if (resultSQL == null) {
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            resultSQL = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            this._replaceJoinAndWhereSQLCache.put(cacheKey, resultSQL);
        }
        return resultSQL;
    }

    protected String replaceOrderBy(String sql, OrderByComparator<Group> obc) {
        if (obc instanceof GroupNameComparator) {
            sql = StringUtil.replace((String)sql, (String)"Group_.name AS groupName", (String)"REPLACE(Group_.name, ' LFR_ORGANIZATION', '') AS groupName");
        }
        return sql;
    }

    protected void setJoin(QueryPos qPos, Map<String, Object> params) throws Exception {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String valueString;
            List values;
            Object value;
            String key = entry.getKey();
            if (key.equals("active") || key.equals("layoutSet") || key.equals("manualMembership") || key.equals("site")) {
                value = (Boolean)entry.getValue();
                qPos.add((Boolean)value);
                continue;
            }
            if (key.equals("classNameIds")) {
                if (entry.getValue() instanceof Long) {
                    qPos.add(((Long)entry.getValue()).longValue());
                    continue;
                }
                for (Object classNameId : (Object)((long[])entry.getValue())) {
                    qPos.add((long)classNameId);
                }
                continue;
            }
            if (key.equals("excludedGroupIds")) {
                List excludedGroupIds = (List)entry.getValue();
                if (excludedGroupIds.isEmpty()) continue;
                Iterator iterator = excludedGroupIds.iterator();
                while (iterator.hasNext()) {
                    long excludedGroupId = (Long)iterator.next();
                    qPos.add(excludedGroupId);
                }
                continue;
            }
            if (key.equals("groupsTree")) {
                List groupsTree = (List)entry.getValue();
                if (groupsTree.isEmpty()) continue;
                for (Group group : groupsTree) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("%");
                    sb.append("/");
                    sb.append(group.getGroupId());
                    sb.append("/");
                    sb.append("%");
                    qPos.add(sb.toString());
                }
                continue;
            }
            if (key.equals("pageCount")) continue;
            if (key.equals("rolePermissions")) {
                RolePermissions rolePermissions = (RolePermissions)entry.getValue();
                ResourceAction resourceAction = ResourceActionLocalServiceUtil.getResourceAction((String)rolePermissions.getName(), (String)rolePermissions.getActionId());
                if (ResourceBlockLocalServiceUtil.isSupported((String)rolePermissions.getName())) {
                    qPos.add(rolePermissions.getName());
                    qPos.add(rolePermissions.getRoleId());
                    qPos.add(resourceAction.getBitwiseValue());
                    continue;
                }
                qPos.add(rolePermissions.getName());
                qPos.add(rolePermissions.getScope());
                qPos.add(rolePermissions.getRoleId());
                qPos.add(resourceAction.getBitwiseValue());
                continue;
            }
            if (key.equals("types")) {
                values = (List)entry.getValue();
                for (Integer value2 : values) {
                    qPos.add(value2);
                }
                continue;
            }
            if (key.equals("userGroupRole")) {
                values = (List)entry.getValue();
                Long userId = (Long)values.get(0);
                Long roleId = (Long)values.get(1);
                qPos.add(userId);
                qPos.add(roleId);
                continue;
            }
            value = entry.getValue();
            if (value instanceof Integer) {
                Integer valueInteger = (Integer)value;
                if (!Validator.isNotNull((Object)valueInteger)) continue;
                qPos.add(valueInteger);
                continue;
            }
            if (value instanceof Long) {
                Long valueLong = (Long)value;
                if (!Validator.isNotNull((Long)valueLong)) continue;
                qPos.add(valueLong);
                continue;
            }
            if (!(value instanceof String) || !Validator.isNotNull((String)(valueString = (String)value))) continue;
            qPos.add(valueString);
        }
    }

    @SafeVarargs
    private final String _buildSQLCacheKey(OrderByComparator<Group> obc, Map<String, Object> ... params) {
        if (obc == null) {
            return this._buildSQLCacheKey("", params);
        }
        return this._buildSQLCacheKey(obc.getOrderBy(), params);
    }

    @SafeVarargs
    private final String _buildSQLCacheKey(String sql, Map<String, Object> ... params) {
        int size = 1;
        for (Map<String, Object> param : params) {
            if (param == null) continue;
            size += param.size() * 5;
        }
        StringBundler sb = new StringBundler(size);
        sb.append(sql);
        for (Map<String, Object> param : params) {
            if (param == null) continue;
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                Object values;
                sb.append(",");
                String key = entry.getKey();
                if (key.equals("rolePermissions")) {
                    RolePermissions rolePermissions = (RolePermissions)entry.getValue();
                    key = ResourceBlockLocalServiceUtil.isSupported((String)rolePermissions.getName()) ? "rolePermissions_6_block" : "rolePermissions_6";
                }
                sb.append(key);
                sb.append("-");
                Object value = entry.getValue();
                if (value instanceof long[]) {
                    values = (long[])value;
                    sb.append(((long[])values).length);
                } else if (value instanceof Collection) {
                    values = (Collection)value;
                    sb.append(values.size());
                }
                sb.append(",");
            }
        }
        return sb.toString();
    }

    private String _getCondition(String join) {
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            join = pos != -1 ? join.substring(pos + 5).concat(" AND ") : "";
        }
        return join;
    }

    private long[] _getGroupOrganizationClassNameIds() {
        if (this._groupOrganizationClassNameIds == null) {
            this._groupOrganizationClassNameIds = new long[]{ClassNameLocalServiceUtil.getClassNameId(Group.class), ClassNameLocalServiceUtil.getClassNameId(Organization.class)};
        }
        return this._groupOrganizationClassNameIds;
    }

    private Map<String, String> _getJoinMap() {
        if (this._joinMap != null) {
            return this._joinMap;
        }
        HashMap<String, String> joinMap = new HashMap<String, String>();
        joinMap.put("active", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ACTIVE)));
        joinMap.put("groupOrg", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUP_ORG)));
        joinMap.put("groupsOrgs", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS)));
        joinMap.put("groupsRoles", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES)));
        joinMap.put("groupsUserGroups", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS)));
        joinMap.put("layoutSet", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_LAYOUT_SET)));
        joinMap.put("membershipRestriction", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_MEMBERSHIP_RESTRICTION)));
        joinMap.put("pageCount", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT)));
        joinMap.put("rolePermissions_6", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS)));
        joinMap.put("rolePermissions_6_block", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_TYPE_PERMISSIONS)));
        joinMap.put("site", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_SITE)));
        joinMap.put("type", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_TYPE)));
        joinMap.put("userGroupRole", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE)));
        joinMap.put("usersGroups", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS)));
        this._joinMap = joinMap;
        return this._joinMap;
    }

    private Map<String, String> _getWhereMap() {
        if (this._whereMap != null) {
            return this._whereMap;
        }
        HashMap<String, String> whereMap = new HashMap<String, String>();
        whereMap.put("active", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ACTIVE)));
        whereMap.put("creatorUserId", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_CREATOR_USER_ID)));
        whereMap.put("groupOrg", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUP_ORG)));
        whereMap.put("groupsOrgs", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS)));
        whereMap.put("groupsRoles", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES)));
        whereMap.put("groupsUserGroups", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS)));
        whereMap.put("layoutSet", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_LAYOUT_SET)));
        whereMap.put("manualMembership", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_MANUAL_MEMBERSHIP)));
        whereMap.put("membershipRestriction", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_MEMBERSHIP_RESTRICTION)));
        whereMap.put("pageCount", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT)));
        whereMap.put("rolePermissions_6", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS)));
        whereMap.put("rolePermissions_6_block", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_TYPE_PERMISSIONS)));
        whereMap.put("site", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_SITE)));
        whereMap.put("type", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_TYPE)));
        whereMap.put("userGroupRole", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE)));
        whereMap.put("usersGroups", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS)));
        this._whereMap = whereMap;
        return this._whereMap;
    }

    private boolean _isCacheableSQL(long[] classNameIds) {
        if (classNameIds == null) {
            return true;
        }
        if (classNameIds.length > 2) {
            return false;
        }
        long[] groupOrganizationClassNameIds = this._getGroupOrganizationClassNameIds();
        long groupClassNameId = groupOrganizationClassNameIds[0];
        long organizationClassNameId = groupOrganizationClassNameIds[1];
        for (long classNameId : classNameIds) {
            if (classNameId == groupClassNameId || classNameId == organizationClassNameId) continue;
            return false;
        }
        return true;
    }

    private void _populateUnionParams(long userId, long[] classNameIds, Map<String, Object> params1, Map<String, Object> params2, Map<String, Object> params3, Map<String, Object> params4) {
        params2.remove("usersGroups");
        params2.put("groupOrg", userId);
        params3.remove("usersGroups");
        params3.put("groupsOrgs", userId);
        params4.remove("usersGroups");
        params4.put("groupsUserGroups", userId);
        long[] groupOrganizationClassNameIds = this._getGroupOrganizationClassNameIds();
        long groupClassNameId = groupOrganizationClassNameIds[0];
        long organizationClassNameId = groupOrganizationClassNameIds[1];
        if (classNameIds == null) {
            params1.put("classNameIds", groupOrganizationClassNameIds);
            params2.put("classNameIds", organizationClassNameId);
            params3.put("classNameIds", groupOrganizationClassNameIds);
            params4.put("classNameIds", groupOrganizationClassNameIds);
        } else {
            params1.put("classNameIds", classNameIds);
            if (ArrayUtil.contains((long[])classNameIds, (long)organizationClassNameId)) {
                params2.put("classNameIds", organizationClassNameId);
                if (ArrayUtil.contains((long[])classNameIds, (long)groupClassNameId)) {
                    params3.put("classNameIds", groupClassNameId);
                    params4.put("classNameIds", groupOrganizationClassNameIds);
                } else {
                    params4.put("classNameIds", organizationClassNameId);
                }
            } else if (ArrayUtil.contains((long[])classNameIds, (long)groupClassNameId)) {
                params3.put("classNameIds", groupClassNameId);
                params4.put("classNameIds", groupClassNameId);
            }
        }
    }

    private String _removeWhere(String join) {
        int pos;
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }
}

