/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LanguageServlet
extends HttpServlet {
    private static final String _CONTENT_DISPOSITION = "attachment; filename=language.txt";
    private static final Log _log = LogFactoryUtil.getLog(LanguageServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String value;
        String key;
        Locale locale;
        block10: {
            String[] pathArray;
            String path = request.getPathInfo();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Path " + path));
            }
            try {
                AuthTokenUtil.checkCSRFToken((HttpServletRequest)request, (String)LanguageServlet.class.getName());
            }
            catch (PortalException pe) {
                _log.error((Object)"Invalid authentication token received", (Throwable)pe);
                return;
            }
            if (Validator.isNotNull((String)path) && path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((pathArray = StringUtil.split((String)path, (char)'/')).length == 0) {
                _log.error((Object)"Language id is not specified");
                return;
            }
            if (pathArray.length == 1) {
                _log.error((Object)"Language key is not specified");
                return;
            }
            locale = LocaleUtil.fromLanguageId((String)pathArray[0]);
            key = pathArray[1];
            Object[] arguments = null;
            if (pathArray.length > 2) {
                arguments = new Object[pathArray.length - 2];
                System.arraycopy(pathArray, 2, arguments, 0, arguments.length);
            }
            value = key;
            try {
                value = ArrayUtil.isEmpty(arguments) ? LanguageUtil.get((Locale)locale, (String)key) : LanguageUtil.format((Locale)locale, (String)key, (Object[])arguments);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block10;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        if (!LanguageUtil.isValidLanguageKey((Locale)locale, (String)key)) {
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
        }
        response.setContentType("text/plain; charset=UTF-8");
        response.setHeader("Content-Disposition", _CONTENT_DISPOSITION);
        ServletResponseUtil.write((HttpServletResponse)response, (byte[])value.getBytes("UTF-8"));
    }
}

