/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.threaddump;

import com.liferay.portal.kernel.servlet.TryFinallyFilter;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.threaddump.ThreadDumper;
import com.liferay.portal.util.PropsValues;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThreadDumpFilter
extends BasePortalFilter
implements TryFinallyFilter {
    private static final int _MAX_THREAD_DUMPERS = 5;
    private static final ScheduledExecutorService _scheduledExecutorService = Executors.newScheduledThreadPool(5);
    private static final ThreadDumper _threadDumper = new ThreadDumper();

    public void doFilterFinally(HttpServletRequest request, HttpServletResponse response, Object object) {
        ScheduledFuture scheduledFuture = (ScheduledFuture)object;
        scheduledFuture.cancel(true);
    }

    public Object doFilterTry(HttpServletRequest request, HttpServletResponse response) {
        ScheduledFuture<?> scheduledFuture = _scheduledExecutorService.schedule(_threadDumper, (long)PropsValues.THREAD_DUMP_SPEED_THRESHOLD, TimeUnit.SECONDS);
        return scheduledFuture;
    }
}

