/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.xml.DocUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.DirectoryScanner;

public class JavadocBuilder {
    private static final String _BASEDIR = "./";
    private static final FileImpl _fileUtil = FileImpl.getInstance();
    private static final SAXReader _saxReader = new SAXReaderImpl();

    public static void main(String[] args) {
        try {
            new JavadocBuilder(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JavadocBuilder(String[] args) throws Exception {
        CmdLineParser cmdLineParser = new CmdLineParser();
        cmdLineParser.parse(args);
        CmdLineParser.Option commandOption = cmdLineParser.addStringOption("command");
        String command = (String)cmdLineParser.getOptionValue(commandOption);
        CmdLineParser.Option limitOption = cmdLineParser.addStringOption("limit");
        String limit = (String)cmdLineParser.getOptionValue(limitOption);
        CmdLineParser.Option ignoreAutogeneratedOption = cmdLineParser.addBooleanOption("ignoreAutogenerated");
        Boolean ignoreAutogenerated = (Boolean)cmdLineParser.getOptionValue(ignoreAutogeneratedOption);
        this._process(command, limit, ignoreAutogenerated);
    }

    private void _addClassCommentElement(Element rootElement, JavaClass javaClass) {
        Element commentElement = rootElement.addElement("comment");
        String comment = this._getCDATA((AbstractJavaEntity)javaClass);
        if (comment.startsWith("Copyright (c) 2000-present Liferay, Inc.")) {
            comment = "";
        }
        if (comment.startsWith("<a href=\"" + javaClass.getName() + ".java.html\">")) {
            int pos = comment.indexOf("</a>");
            comment = StringUtil.trim((String)comment.substring(pos + 4));
        }
        commentElement.addCDATA(comment);
    }

    private void _addDocletElements(Element parentElement, AbstractJavaEntity abstractJavaEntity, String name) {
        DocletTag[] docletTags;
        for (DocletTag docletTag : docletTags = abstractJavaEntity.getTagsByName(name)) {
            String value = docletTag.getValue();
            if (name.equals("author") || name.equals("see") || name.equals("since") || name.equals("version")) {
                DocUtil.add((Element)parentElement, (String)name, (String)value);
                continue;
            }
            Element element = parentElement.addElement(name);
            element.addCDATA(value);
        }
    }

    private void _addDocletTags(Element parentElement, String name, String indent, StringBuilder sb) {
        List elements = parentElement.elements(name);
        for (Element element : elements) {
            sb.append(indent);
            sb.append(" * @");
            sb.append(name);
            sb.append(" ");
            Element commentElement = element.element("comment");
            if (commentElement != null) {
                sb.append(element.elementText("name"));
                sb.append(" ");
                sb.append(this._getCDATA(element.elementText("comment")));
            } else {
                sb.append(this._getCDATA(element.getText()));
            }
            sb.append("\n");
        }
    }

    private void _addFieldElement(Element rootElement, JavaField javaField) {
        Element fieldElement = rootElement.addElement("field");
        DocUtil.add((Element)fieldElement, (String)"name", (String)javaField.getName());
        Element commentElement = fieldElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaField));
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "deprecated");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "see");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "since");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "version");
    }

    private void _addMethodElement(Element rootElement, JavaMethod javaMethod) {
        Element methodElement = rootElement.addElement("method");
        DocUtil.add((Element)methodElement, (String)"name", (String)javaMethod.getName());
        Element commentElement = methodElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaMethod));
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "deprecated");
        this._addParamElements(methodElement, javaMethod);
        this._addReturnElement(methodElement, javaMethod);
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "see");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "since");
        this._addThrowsElements(methodElement, javaMethod);
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "version");
    }

    private void _addParamElement(Element methodElement, JavaParameter javaParameter, DocletTag[] paramDocletTags) {
        String name = javaParameter.getName();
        Type parameterType = javaParameter.getType();
        String type = parameterType.getValue();
        String value = null;
        for (DocletTag paramDocletTag : paramDocletTags) {
            String curValue = paramDocletTag.getValue();
            if (!curValue.startsWith(name)) continue;
            value = curValue;
            break;
        }
        Element paramElement = methodElement.addElement("param");
        DocUtil.add((Element)paramElement, (String)"name", (String)name);
        DocUtil.add((Element)paramElement, (String)"type", (String)type);
        if (value != null) {
            value = value.substring(name.length());
        }
        Element commentElement = paramElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addParamElements(Element methodElement, JavaMethod javaMethod) {
        JavaParameter[] javaParameters = javaMethod.getParameters();
        DocletTag[] paramDocletTags = javaMethod.getTagsByName("param");
        for (JavaParameter javaParameter : javaParameters) {
            this._addParamElement(methodElement, javaParameter, paramDocletTags);
        }
    }

    private void _addReturnElement(Element methodElement, JavaMethod javaMethod) {
        Type returnType = javaMethod.getReturnType();
        if (returnType == null) {
            return;
        }
        String returnTypeValue = returnType.getValue();
        if (!returnTypeValue.equals("void")) {
            this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "return");
        }
    }

    private void _addThrowsElement(Element methodElement, Type exception, DocletTag[] throwsDocletTags) {
        JavaClass exceptionClass = exception.getJavaClass();
        String name = exceptionClass.getName();
        String value = null;
        for (DocletTag throwsDocletTag : throwsDocletTags) {
            String curValue = throwsDocletTag.getValue();
            if (!curValue.startsWith(name)) continue;
            value = curValue;
            break;
        }
        Element throwsElement = methodElement.addElement("throws");
        DocUtil.add((Element)throwsElement, (String)"name", (String)name);
        DocUtil.add((Element)throwsElement, (String)"type", (String)exception.getValue());
        if (value != null) {
            value = value.substring(name.length());
        }
        Element commentElement = throwsElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addThrowsElements(Element methodElement, JavaMethod javaMethod) {
        Type[] exceptions = javaMethod.getExceptions();
        DocletTag[] throwsDocletTags = javaMethod.getTagsByName("throws");
        for (Type exception : exceptions) {
            this._addThrowsElement(methodElement, exception, throwsDocletTags);
        }
    }

    private String _getCDATA(AbstractJavaEntity abstractJavaEntity) {
        return this._getCDATA(abstractJavaEntity.getComment());
    }

    private String _getCDATA(String cdata) {
        if (cdata == null) {
            return "";
        }
        cdata = StringUtil.replace((String)cdata, (String[])new String[]{"\n", "<p>", "</p>"}, (String[])new String[]{" ", " <p> ", " </p> "});
        while (cdata.contains("  ")) {
            cdata = StringUtil.replace((String)cdata, (String)"  ", (String)" ");
        }
        return cdata.trim();
    }

    private String _getFieldKey(Element fieldElement) {
        return fieldElement.elementText("name");
    }

    private String _getFieldKey(JavaField javaField) {
        return javaField.getName();
    }

    private JavaClass _getJavaClass(String fileName) throws Exception {
        return this._getJavaClass(fileName, null);
    }

    private JavaClass _getJavaClass(String fileName, Reader reader) throws Exception {
        int pos = fileName.indexOf("src/");
        if (pos == -1) {
            pos = fileName.indexOf("test/");
        }
        if (pos == -1) {
            throw new RuntimeException(fileName);
        }
        pos = fileName.indexOf("/", pos);
        String srcFile = fileName.substring(pos + 1);
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (char)'/', (char)'.');
        JavaDocBuilder builder = new JavaDocBuilder();
        if (reader == null) {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            builder.addSource(file);
        } else {
            builder.addSource(reader);
        }
        return builder.getClassByName(className);
    }

    private String _getJavaClassComment(Element rootElement) {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n");
        sb.append(" * ");
        sb.append(this._getCDATA(rootElement.elementText("comment")));
        sb.append("\n");
        sb.append(" *\n");
        String indent = "";
        this._addDocletTags(rootElement, "author", indent, sb);
        this._addDocletTags(rootElement, "deprecated", indent, sb);
        this._addDocletTags(rootElement, "see", indent, sb);
        this._addDocletTags(rootElement, "serial", indent, sb);
        this._addDocletTags(rootElement, "since", indent, sb);
        this._addDocletTags(rootElement, "version", indent, sb);
        sb.append(" */\n");
        return sb.toString();
    }

    private String _getJavadocXml(JavaClass javaClass) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        Element rootElement = _saxReader.createElement("javadoc");
        Document document = _saxReader.createDocument(rootElement);
        DocUtil.add((Element)rootElement, (String)"name", (String)javaClass.getName());
        DocUtil.add((Element)rootElement, (String)"type", (String)javaClass.getFullyQualifiedName());
        this._addClassCommentElement(rootElement, javaClass);
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "author");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "deprecated");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "see");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "serial");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "since");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "version");
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            this._addMethodElement(rootElement, javaMethod);
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            this._addFieldElement(rootElement, javaField);
        }
        return document.formattedString();
    }

    private String _getJavaFieldComment(String[] lines, Map<String, Element> fieldElementsMap, JavaField javaField) {
        String fieldKey = this._getFieldKey(javaField);
        Element fieldElement = fieldElementsMap.get(fieldKey);
        if (fieldElement == null) {
            return null;
        }
        String line = lines[javaField.getLineNumber() - 1];
        String indent = "";
        for (char c : line.toCharArray()) {
            if (!Character.isWhitespace(c)) break;
            indent = indent + c;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("/**\n");
        sb.append(indent);
        sb.append(" * ");
        sb.append(fieldElement.elementText("comment"));
        sb.append("\n");
        sb.append(indent);
        sb.append(" *\n");
        this._addDocletTags(fieldElement, "deprecated", indent, sb);
        this._addDocletTags(fieldElement, "see", indent, sb);
        this._addDocletTags(fieldElement, "since", indent, sb);
        this._addDocletTags(fieldElement, "version", indent, sb);
        sb.append(indent);
        sb.append(" */\n");
        return sb.toString();
    }

    private String _getJavaMethodComment(String[] lines, Map<String, Element> methodElementsMap, JavaMethod javaMethod) {
        String methodKey = this._getMethodKey(javaMethod);
        Element methodElement = methodElementsMap.get(methodKey);
        if (methodElement == null) {
            return null;
        }
        String line = lines[javaMethod.getLineNumber() - 1];
        String indent = "";
        for (char c : line.toCharArray()) {
            if (!Character.isWhitespace(c)) break;
            indent = indent + c;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("/**\n");
        sb.append(indent);
        sb.append(" * ");
        sb.append(methodElement.elementText("comment"));
        sb.append("\n");
        sb.append(indent);
        sb.append(" *\n");
        this._addDocletTags(methodElement, "deprecated", indent, sb);
        this._addDocletTags(methodElement, "param", indent, sb);
        this._addDocletTags(methodElement, "return", indent, sb);
        this._addDocletTags(methodElement, "see", indent, sb);
        this._addDocletTags(methodElement, "since", indent, sb);
        this._addDocletTags(methodElement, "throws", indent, sb);
        this._addDocletTags(methodElement, "version", indent, sb);
        sb.append(indent);
        sb.append(" */\n");
        return sb.toString();
    }

    private String _getMethodKey(Element methodElement) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodElement.elementText("name"));
        sb.append("(");
        List paramElements = methodElement.elements("param");
        for (Element paramElement : paramElements) {
            sb.append(paramElement.elementText("name"));
            sb.append("|");
            sb.append(paramElement.elementText("type"));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getMethodKey(JavaMethod javaMethod) {
        JavaParameter[] javaParameters;
        StringBuilder sb = new StringBuilder();
        sb.append(javaMethod.getName());
        sb.append("(");
        for (JavaParameter javaParameter : javaParameters = javaMethod.getParameters()) {
            sb.append(javaParameter.getName());
            sb.append("|");
            Type type = javaParameter.getType();
            sb.append(type.getValue());
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean _isGenerated(String content) {
        return content.contains("<javadoc autogenerated=\"true\">");
    }

    private void _process(String command, String limit, Boolean ignoreAutogenerated) throws Exception {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(_BASEDIR);
        ds.setExcludes(new String[]{"**\\classes\\**", "**\\portal-client\\**", "**\\portal-web\\**"});
        ArrayList<String> includes = new ArrayList<String>();
        if (Validator.isNotNull((String)limit) && !limit.startsWith("$")) {
            String[] limitArray;
            for (String curLimit : limitArray = StringUtil.split((String)limit, (char)'/')) {
                includes.add("**\\" + StringUtil.replace((String)curLimit, (char)'.', (char)'\\') + "\\**\\*.java");
                includes.add("**\\" + curLimit + ".java");
            }
        } else {
            includes.add("**\\*.java");
        }
        ds.setIncludes(includes.toArray(new String[includes.size()]));
        ds.scan();
        String[] fileNames = ds.getIncludedFiles();
        for (String fileName : fileNames) {
            String oldContent;
            File file;
            fileName = StringUtil.replace((String)fileName, (char)'\\', (char)'/');
            if (ignoreAutogenerated != null && ignoreAutogenerated.booleanValue() && (file = new File(_BASEDIR + fileName)).exists() && this._isGenerated(oldContent = _fileUtil.read(_BASEDIR + fileName + "doc"))) continue;
            if (command.equals("cleanup")) {
                this._processGet(fileName);
                this._processSave(fileName);
                this._processDelete(fileName);
                continue;
            }
            if (command.equals("commit")) {
                this._processSave(fileName);
                this._processDelete(fileName);
                continue;
            }
            if (command.equals("delete")) {
                this._processDelete(fileName);
                continue;
            }
            if (command.equals("get")) {
                this._processGet(fileName);
                continue;
            }
            if (!command.equals("save")) continue;
            this._processSave(fileName);
        }
    }

    private void _processDelete(String fileName) throws Exception {
        this._removeJavadocFromJava(fileName, true);
    }

    private void _processGet(String fileName) throws Exception {
        File javadocFile = new File(_BASEDIR + fileName + "doc");
        if (!javadocFile.exists()) {
            this._updateJavadocFromJava(fileName);
        }
        String javaWithoutJavadoc = this._removeJavadocFromJava(fileName, false);
        this._updateJavaFromJavadoc(fileName, javaWithoutJavadoc);
    }

    private void _processSave(String fileName) throws Exception {
        this._updateJavadocFromJava(fileName);
    }

    private String _removeJavadocFromJava(String fileName, boolean log) throws Exception {
        JavaMethod[] javaMethods;
        File file = new File(_BASEDIR + fileName);
        String oldContent = _fileUtil.read(file);
        String[] lines = StringUtil.splitLines((String)oldContent);
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(oldContent));
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        lineNumbers.add(javaClass.getLineNumber());
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            lineNumbers.add(javaMethod.getLineNumber());
        }
        JavaField[] javaFields = javaClass.getFields();
        for (JavaField javaField : javaFields) {
            lineNumbers.add(javaField.getLineNumber());
        }
        Iterator iterator = lineNumbers.iterator();
        block2: while (iterator.hasNext()) {
            int lineNumber = (Integer)iterator.next();
            int pos = lineNumber - 2;
            String line = lines[pos].trim();
            if (!line.endsWith("*/")) continue;
            while (true) {
                lines[pos] = null;
                if (line.startsWith("/**")) continue block2;
                line = lines[--pos].trim();
            }
        }
        StringBuilder sb = new StringBuilder(oldContent.length());
        for (String line : lines) {
            if (line == null) continue;
            sb.append(line);
            sb.append("\n");
        }
        String newContent = StringUtil.trim((String)sb.toString());
        if (oldContent == null || !oldContent.equals(newContent)) {
            _fileUtil.write(file, newContent);
            if (log) {
                System.out.println("Writing " + file);
            }
        }
        return newContent;
    }

    private void _updateJavadocFromJava(String fileName) throws Exception {
        File file = new File(_BASEDIR + fileName + "doc");
        String oldContent = null;
        if (file.exists() && this._isGenerated(oldContent = _fileUtil.read(file))) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(fileName);
        String newContent = this._getJavadocXml(javaClass);
        if (oldContent == null || !oldContent.equals(newContent)) {
            _fileUtil.write(file, newContent.getBytes());
            System.out.println("Writing " + file);
        }
    }

    private void _updateJavaFromJavadoc(String fileName, String oldContent) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        File javadocFile = new File(_BASEDIR + fileName + "doc");
        if (!javadocFile.exists()) {
            return;
        }
        File file = new File(_BASEDIR + fileName);
        if (oldContent == null) {
            oldContent = _fileUtil.read(file);
        }
        String[] lines = StringUtil.splitLines((String)oldContent);
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(oldContent));
        Document document = _saxReader.read(javadocFile);
        Element rootElement = document.getRootElement();
        TreeMap<Integer, String> commentsMap = new TreeMap<Integer, String>();
        commentsMap.put(javaClass.getLineNumber(), this._getJavaClassComment(rootElement));
        HashMap<String, Element> methodElementsMap = new HashMap<String, Element>();
        List methodElements = rootElement.elements("method");
        for (JavaMethod[] methodElement : methodElements) {
            String methodKey = this._getMethodKey((Element)methodElement);
            methodElementsMap.put(methodKey, (Element)methodElement);
        }
        for (JavaMethod javaMethod : javaMethods = javaClass.getMethods()) {
            if (commentsMap.containsKey(javaMethod.getLineNumber())) continue;
            commentsMap.put(javaMethod.getLineNumber(), this._getJavaMethodComment(lines, methodElementsMap, javaMethod));
        }
        HashMap<String, Element> fieldElementsMap = new HashMap<String, Element>();
        List fieldElements = rootElement.elements("field");
        for (JavaField[] fieldElement : fieldElements) {
            String fieldKey = this._getFieldKey((Element)fieldElement);
            fieldElementsMap.put(fieldKey, (Element)fieldElement);
        }
        for (JavaField javaField : javaFields = javaClass.getFields()) {
            if (commentsMap.containsKey(javaField.getLineNumber())) continue;
            commentsMap.put(javaField.getLineNumber(), this._getJavaFieldComment(lines, fieldElementsMap, javaField));
        }
        StringBuilder sb = new StringBuilder(oldContent.length());
        for (int lineNumber = 1; lineNumber <= lines.length; ++lineNumber) {
            String line = lines[lineNumber - 1];
            String comments = (String)commentsMap.get(lineNumber);
            if (comments != null) {
                sb.append(comments);
            }
            sb.append(line);
            sb.append("\n");
        }
        String newContent = StringUtil.trim((String)sb.toString());
        if (oldContent == null || !oldContent.equals(newContent)) {
            _fileUtil.write(file, newContent);
            System.out.println("Writing " + file);
        }
    }
}

