/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileComparator;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.util.ant.ExpandTask;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.txt.UniversalEncodingDetector;
import org.apache.tools.ant.DirectoryScanner;
import org.mozilla.intl.chardet.nsDetector;

@DoPrivileged
public class FileImpl
implements File {
    private static final String[] _SAFE_FILE_NAME_1 = new String[]{"&", ")", "(", ";"};
    private static final String[] _SAFE_FILE_NAME_2 = new String[]{PropsValues.DL_STORE_FILE_IMPL_SAFE_FILE_NAME_2_AMPERSAND, PropsValues.DL_STORE_FILE_IMPL_SAFE_FILE_NAME_2_CLOSE_PARENTHESIS, PropsValues.DL_STORE_FILE_IMPL_SAFE_FILE_NAME_2_OPEN_PARENTHESIS, PropsValues.DL_STORE_FILE_IMPL_SAFE_FILE_NAME_2_SEMICOLON};
    private static final Log _log = LogFactoryUtil.getLog(FileImpl.class);
    private static final FileImpl _instance = new FileImpl();

    public static FileImpl getInstance() {
        return _instance;
    }

    public String appendParentheticalSuffix(String fileName, String suffix) {
        String fileNameWithoutExtension = this.stripExtension(fileName);
        String fileNameWithParentheticalSuffix = StringUtil.appendParentheticalSuffix((String)fileNameWithoutExtension, (String)suffix);
        String extension = this.getExtension(fileName);
        if (Validator.isNull((String)extension)) {
            return fileNameWithParentheticalSuffix;
        }
        StringBundler sb = new StringBundler(3);
        sb.append(fileNameWithParentheticalSuffix);
        sb.append(".");
        sb.append(extension);
        return sb.toString();
    }

    public String appendSuffix(String fileName, String suffix) {
        StringBundler sb = new StringBundler(4);
        String fileNameWithoutExtension = this.stripExtension(fileName);
        sb.append(fileNameWithoutExtension);
        sb.append(suffix);
        String extension = this.getExtension(fileName);
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public void copyDirectory(java.io.File source, java.io.File destination) throws IOException {
        if (!source.exists() || !source.isDirectory()) {
            return;
        }
        this.mkdirs(destination);
        java.io.File[] fileArray = source.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.copyDirectory(fileArray[i], new java.io.File(destination.getPath() + java.io.File.separator + fileArray[i].getName()));
                continue;
            }
            this.copyFile(fileArray[i], new java.io.File(destination.getPath() + java.io.File.separator + fileArray[i].getName()));
        }
    }

    public void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
        this.copyDirectory(new java.io.File(sourceDirName), new java.io.File(destinationDirName));
    }

    public void copyFile(java.io.File source, java.io.File destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    public void copyFile(java.io.File source, java.io.File destination, boolean lazy) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (lazy) {
            String oldContent = null;
            try {
                oldContent = this.read(source);
            }
            catch (Exception e) {
                return;
            }
            String newContent = null;
            try {
                newContent = this.read(destination);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oldContent == null || !oldContent.equals(newContent)) {
                this.copyFile(source, destination, false);
            }
        } else {
            this.mkdirsParentFile(destination);
            StreamUtil.transfer((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(destination));
        }
    }

    public void copyFile(String source, String destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    public void copyFile(String source, String destination, boolean lazy) throws IOException {
        this.copyFile(new java.io.File(source), new java.io.File(destination), lazy);
    }

    public java.io.File createTempFile() {
        return this.createTempFile("");
    }

    public java.io.File createTempFile(byte[] bytes) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, bytes, false);
        return file;
    }

    public java.io.File createTempFile(InputStream is) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, is);
        return file;
    }

    public java.io.File createTempFile(String extension) {
        return new java.io.File(this.createTempFileName(extension));
    }

    public java.io.File createTempFile(String prefix, String extension) {
        return new java.io.File(this.createTempFileName(prefix, extension));
    }

    public String createTempFileName() {
        return this.createTempFileName(null, null);
    }

    public String createTempFileName(String extension) {
        return this.createTempFileName(null, extension);
    }

    public String createTempFileName(String prefix, String extension) {
        StringBundler sb = new StringBundler(7);
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/");
        if (Validator.isNotNull((String)prefix)) {
            sb.append(prefix);
        }
        sb.append(Time.getTimestamp());
        sb.append(PwdGenerator.getPassword((int)8, (String[])new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZ"}));
        if (Validator.isFileExtension((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public java.io.File createTempFolder() throws IOException {
        java.io.File file = new java.io.File(this.createTempFileName());
        this.mkdirs(file);
        return file;
    }

    public String decodeSafeFileName(String fileName) {
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_2, (String[])_SAFE_FILE_NAME_1);
    }

    public boolean delete(java.io.File file) {
        if (file != null) {
            boolean exists = true;
            try {
                exists = file.exists();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (exists) {
                return file.delete();
            }
        }
        return false;
    }

    public boolean delete(String file) {
        return this.delete(new java.io.File(file));
    }

    public void deltree(java.io.File directory) {
        if (directory.exists() && directory.isDirectory()) {
            java.io.File[] fileArray = directory.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deltree(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
            directory.delete();
        }
    }

    public void deltree(String directory) {
        this.deltree(new java.io.File(directory));
    }

    public String encodeSafeFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_1, (String[])_SAFE_FILE_NAME_2);
    }

    public boolean exists(java.io.File file) {
        return file.exists();
    }

    public boolean exists(String fileName) {
        return this.exists(new java.io.File(fileName));
    }

    public String extractText(InputStream is, String fileName) {
        return this.extractText(is, fileName, -1);
    }

    public String extractText(InputStream is, String fileName, int maxStringLength) {
        if (maxStringLength == 0) {
            return "";
        }
        String text = null;
        try {
            String mimeType;
            Tika tika = new Tika(TikaConfigHolder._tikaConfig);
            tika.setMaxStringLength(maxStringLength);
            boolean forkProcess = false;
            if (PropsValues.TEXT_EXTRACTION_FORK_PROCESS_ENABLED && ArrayUtil.contains((Object[])PropsValues.TEXT_EXTRACTION_FORK_PROCESS_MIME_TYPES, (Object)(mimeType = tika.detect(is)))) {
                forkProcess = true;
            }
            if (forkProcess) {
                Registry registry = RegistryUtil.getRegistry();
                ProcessChannel processChannel = (ProcessChannel)registry.callService(ProcessExecutor.class, processExecutor -> {
                    try {
                        return processExecutor.execute(PortalClassPathUtil.getPortalProcessConfig(), (ProcessCallable)new ExtractTextProcessCallable(this.getBytes(is)));
                    }
                    catch (Exception e) {
                        return (ProcessChannel)ReflectionUtil.throwException((Throwable)e);
                    }
                });
                NoticeableFuture future = processChannel.getProcessNoticeableFuture();
                text = (String)future.get();
            } else {
                TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)is);
                UniversalEncodingDetector universalEncodingDetector = new UniversalEncodingDetector();
                Metadata metadata = new Metadata();
                Charset charset = universalEncodingDetector.detect((InputStream)tikaInputStream, metadata);
                String contentEncoding = "";
                if (charset != null) {
                    contentEncoding = charset.name();
                }
                if (!contentEncoding.equals("")) {
                    metadata.set("Content-Encoding", contentEncoding);
                    metadata.set("Content-Type", "text/plain; charset=" + contentEncoding);
                }
                text = tika.parseToString((InputStream)tikaInputStream, metadata);
            }
        }
        catch (Throwable t) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)t);
            if (throwable instanceof EncryptedDocumentException || throwable instanceof UnsupportedZipFeatureException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to extract text from an encrypted file " + fileName), t);
                }
            }
            if (t instanceof TikaException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to extract text from " + fileName), t);
                }
            }
            _log.error((Object)t, t);
        }
        if (_log.isInfoEnabled()) {
            if (text == null) {
                _log.info((Object)("Text extraction failed for " + fileName));
            } else {
                _log.info((Object)("Text was extracted for " + fileName));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Extractor returned text:\n\n" + text));
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public String[] find(String directory, String includes, String excludes) {
        if (directory.length() > 0 && (directory = this.replaceSeparator(directory)).charAt(directory.length() - 1) == '/') {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (!this.exists(directory)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Directory " + directory + " does not exist"));
            }
            return new String[0];
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(directory);
        directoryScanner.setExcludes(StringUtil.split((String)excludes));
        directoryScanner.setIncludes(StringUtil.split((String)includes));
        directoryScanner.scan();
        String[] includedFiles = directoryScanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            includedFiles[i] = directory.concat("/").concat(this.replaceSeparator(includedFiles[i]));
        }
        return includedFiles;
    }

    public String getAbsolutePath(java.io.File file) {
        return StringUtil.replace((String)file.getAbsolutePath(), (char)'\\', (char)'/');
    }

    public byte[] getBytes(Class<?> clazz, String fileName) throws IOException {
        return this.getBytes(clazz.getResourceAsStream(fileName));
    }

    public byte[] getBytes(java.io.File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            byte[] bytes = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public byte[] getBytes(InputStream is) throws IOException {
        return this.getBytes(is, -1);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize) throws IOException {
        return this.getBytes(inputStream, bufferSize, true);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize, boolean cleanUpStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (int)bufferSize, (boolean)cleanUpStream);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            return StringUtil.toLowerCase((String)fileName.substring(pos + 1));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMD5Checksum(java.io.File file) throws IOException {
        String string;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            string = DigesterUtil.digestHex((String)"MD5", (InputStream)fileInputStream);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{fileInputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{fileInputStream});
        return string;
    }

    public String getPath(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        if (x == -1 && y == -1) {
            return "/";
        }
        String shortFileName = fullFileName.substring(0, Math.max(x, y));
        return shortFileName;
    }

    public String getShortFileName(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        String shortFileName = fullFileName.substring(Math.max(x, y) + 1);
        return shortFileName;
    }

    public boolean isAscii(java.io.File file) throws IOException {
        boolean ascii = true;
        nsDetector detector = new nsDetector(0);
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)inputStream).read(buffer, 0, buffer.length)) != -1 && (!ascii || (ascii = detector.isAscii(buffer, len)))) {
            }
            detector.DataEnd();
        }
        return ascii;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameContent(java.io.File file, byte[] bytes, int length) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileChannel fileChannel = fileInputStream.getChannel();
            if (fileChannel.size() != (long)length) {
                boolean bl = false;
                return bl;
            }
            byte[] buffer = new byte[1024];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            int bufferIndex = 0;
            int bufferLength = -1;
            while (true) {
                if ((bufferLength = fileChannel.read(byteBuffer)) > 0 && bufferIndex < length) {
                } else {
                    boolean bl;
                    if (bufferIndex != length || bufferLength != -1) {
                        bl = false;
                        return bl;
                    }
                    bl = true;
                    return bl;
                }
                for (int i = 0; i < bufferLength; ++i) {
                    if (buffer[i] == bytes[bufferIndex++]) continue;
                    boolean bl = false;
                    return bl;
                }
                byteBuffer.clear();
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSameContent(java.io.File file, String s) {
        ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)"UTF-8", (CharBuffer)CharBuffer.wrap(s));
        return this.isSameContent(file, byteBuffer.array(), byteBuffer.limit());
    }

    public String[] listDirs(java.io.File file) {
        ArrayList<String> dirs = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            dirs.add(fileArray[i].getName());
        }
        return dirs.toArray(new String[dirs.size()]);
    }

    public String[] listDirs(String fileName) {
        return this.listDirs(new java.io.File(fileName));
    }

    public String[] listFiles(java.io.File file) {
        ArrayList<String> files = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            files.add(fileArray[i].getName());
        }
        return files.toArray(new String[files.size()]);
    }

    public String[] listFiles(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return new String[0];
        }
        return this.listFiles(new java.io.File(fileName));
    }

    public void mkdirs(java.io.File file) throws IOException {
        FileUtils.forceMkdir((java.io.File)file);
    }

    public void mkdirs(String pathName) {
        java.io.File file = new java.io.File(pathName);
        if (file.exists() && file.isDirectory()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Directory " + pathName + " already exists"));
            }
            return;
        }
        try {
            this.mkdirs(file);
        }
        catch (IOException ioe) {
            ReflectionUtil.throwException((Throwable)ioe);
        }
    }

    public boolean move(java.io.File source, java.io.File destination) {
        if (!source.exists()) {
            return false;
        }
        destination.delete();
        try {
            if (source.isDirectory()) {
                FileUtils.moveDirectory((java.io.File)source, (java.io.File)destination);
            } else {
                FileUtils.moveFile((java.io.File)source, (java.io.File)destination);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public boolean move(String sourceFileName, String destinationFileName) {
        return this.move(new java.io.File(sourceFileName), new java.io.File(destinationFileName));
    }

    public String read(java.io.File file) throws IOException {
        return this.read(file, false);
    }

    public String read(java.io.File file, boolean raw) throws IOException {
        byte[] bytes = this.getBytes(file);
        if (bytes == null) {
            return null;
        }
        String s = new String(bytes, "UTF-8");
        if (raw) {
            return s;
        }
        return StringUtil.replace((String)s, (String)"\r\n", (String)"\n");
    }

    public String read(String fileName) throws IOException {
        return this.read(new java.io.File(fileName));
    }

    public String replaceSeparator(String fileName) {
        return StringUtil.replace((String)fileName, (char)'\\', (char)'/');
    }

    public java.io.File[] sortFiles(java.io.File[] files) {
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new FileComparator());
        ArrayList<java.io.File> directoryList = new ArrayList<java.io.File>();
        ArrayList<java.io.File> fileList = new ArrayList<java.io.File>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                directoryList.add(files[i]);
                continue;
            }
            fileList.add(files[i]);
        }
        directoryList.addAll(fileList);
        return directoryList.toArray(new java.io.File[directoryList.size()]);
    }

    public String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String ext = this.getExtension(fileName);
        if (ext.length() > 0) {
            return fileName.substring(0, fileName.length() - ext.length() - 1);
        }
        return fileName;
    }

    public String stripParentheticalSuffix(String fileName) {
        StringBundler sb = new StringBundler(3);
        String fileNameWithoutExtension = this.stripExtension(fileName);
        sb.append(StringUtil.stripParentheticalSuffix((String)fileNameWithoutExtension));
        sb.append(".");
        String extension = this.getExtension(fileName);
        sb.append(extension);
        return sb.toString();
    }

    public List<String> toList(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public List<String> toList(String fileName) {
        try {
            return this.toList(new FileReader(fileName));
        }
        catch (IOException ioe) {
            return new ArrayList<String>();
        }
    }

    public Properties toProperties(FileInputStream fis) {
        Properties properties = new Properties();
        try {
            properties.load(fis);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public Properties toProperties(String fileName) {
        try {
            return this.toProperties(new FileInputStream(fileName));
        }
        catch (IOException ioe) {
            return new Properties();
        }
    }

    public void touch(java.io.File file) throws IOException {
        FileUtils.touch((java.io.File)file);
    }

    public void touch(String fileName) throws IOException {
        this.touch(new java.io.File(fileName));
    }

    public void unzip(java.io.File source, java.io.File destination) {
        ExpandTask.expand((java.io.File)source, (java.io.File)destination);
    }

    public void write(java.io.File file, byte[] bytes) throws IOException {
        this.write(file, bytes, 0, bytes.length, false);
    }

    public void write(java.io.File file, byte[] bytes, boolean append) throws IOException {
        this.write(file, bytes, 0, bytes.length, append);
    }

    public void write(java.io.File file, byte[] bytes, int offset, int length) throws IOException {
        this.write(file, bytes, offset, bytes.length, false);
    }

    public void write(java.io.File file, byte[] bytes, int offset, int length, boolean append) throws IOException {
        this.mkdirsParentFile(file);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, append);){
            fileOutputStream.write(bytes, offset, length);
        }
    }

    public void write(java.io.File file, InputStream is) throws IOException {
        this.mkdirsParentFile(file);
        StreamUtil.transfer((InputStream)is, (OutputStream)new FileOutputStream(file));
    }

    public void write(java.io.File file, String s) throws IOException {
        this.write(file, s, false);
    }

    public void write(java.io.File file, String s, boolean lazy) throws IOException {
        this.write(file, s, lazy, false);
    }

    public void write(java.io.File file, String s, boolean lazy, boolean append) throws IOException {
        String content;
        if (s == null) {
            return;
        }
        this.mkdirsParentFile(file);
        if (lazy && file.exists() && (content = this.read(file)).equals(s)) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");){
            writer.write(s);
        }
    }

    public void write(String fileName, byte[] bytes) throws IOException {
        this.write(new java.io.File(fileName), bytes);
    }

    public void write(String fileName, InputStream is) throws IOException {
        this.write(new java.io.File(fileName), is);
    }

    public void write(String fileName, String s) throws IOException {
        this.write(new java.io.File(fileName), s);
    }

    public void write(String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(fileName), s, lazy);
    }

    public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(fileName), s, lazy, append);
    }

    public void write(String pathName, String fileName, String s) throws IOException {
        this.write(new java.io.File(pathName, fileName), s);
    }

    public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy);
    }

    public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy, append);
    }

    protected void mkdirsParentFile(java.io.File file) throws IOException {
        java.io.File parentFile = file.getParentFile();
        if (parentFile == null) {
            return;
        }
        try {
            this.mkdirs(parentFile);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class TikaConfigHolder {
        private static final TikaConfig _tikaConfig;

        private TikaConfigHolder() {
        }

        static {
            try {
                _tikaConfig = new TikaConfig();
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static class ExtractTextProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final byte[] _data;

        public ExtractTextProcessCallable(byte[] data) {
            this._data = data;
        }

        public String call() throws ProcessException {
            Tika tika = new Tika(TikaConfigHolder._tikaConfig);
            try {
                return tika.parseToString((InputStream)new UnsyncByteArrayInputStream(this._data));
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }
}

