/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;

public class VerifyBlogs
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyBlogs.class);

    @Override
    protected void doVerify() throws Exception {
        this.updateEntryAssets();
        this.verifyStatus();
    }

    protected void updateEntryAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List entries = BlogsEntryLocalServiceUtil.getNoAssetEntries();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + entries.size() + " entries with no asset"));
            }
            for (BlogsEntry entry : entries) {
                try {
                    BlogsEntryLocalServiceUtil.updateAsset((long)entry.getUserId(), (BlogsEntry)entry, null, null, null, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to update asset for entry ", String.valueOf(entry.getEntryId()), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for entries");
            }
        }
    }

    protected void verifyStatus() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update BlogsEntry set status = 0 where status is null");
        }
    }
}

