/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;

public class VerifyLayout
extends VerifyProcess {
    protected void deleteLinkedOrphanedLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(3);
            sb.append("delete from Layout where layoutPrototypeUuid != '' ");
            sb.append("and layoutPrototypeUuid not in (select uuid_ from ");
            sb.append("LayoutPrototype) and layoutPrototypeLinkEnabled = TRUE");
            this.runSQL(sb.toString());
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteLinkedOrphanedLayouts();
        this.updateUnlinkedOrphanedLayouts();
        this.verifyFriendlyURL();
        this.verifyLayoutPrototypeLinkEnabled();
        this.verifyUuid();
    }

    protected void updateUnlinkedOrphanedLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(4);
            sb.append("update Layout set layoutPrototypeUuid = null where ");
            sb.append("layoutPrototypeUuid != '' and layoutPrototypeUuid not ");
            sb.append("in (select uuid_ from LayoutPrototype) and ");
            sb.append("layoutPrototypeLinkEnabled = FALSE");
            this.runSQL(sb.toString());
        }
    }

    protected void verifyFriendlyURL() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List layouts = LayoutLocalServiceUtil.getNullFriendlyURLLayouts();
            for (Layout layout : layouts) {
                List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid());
                for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
                    String friendlyURL = "/" + layout.getLayoutId();
                    LayoutLocalServiceUtil.updateFriendlyURL((long)layout.getUserId(), (long)layout.getPlid(), (String)friendlyURL, (String)layoutFriendlyURL.getLanguageId());
                }
            }
            ActionableDynamicQuery actionableDynamicQuery = LayoutFriendlyURLLocalServiceUtil.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

                public void addCriteria(DynamicQuery dynamicQuery) {
                    DynamicQuery layoutDynamicQuery = LayoutLocalServiceUtil.dynamicQuery();
                    Projection projection = ProjectionFactoryUtil.property((String)"plid");
                    layoutDynamicQuery.setProjection(projection);
                    Property plidProperty = PropertyFactoryUtil.forName((String)"plid");
                    dynamicQuery.add(plidProperty.notIn(layoutDynamicQuery));
                }
            });
            actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<LayoutFriendlyURL>(){

                public void performAction(LayoutFriendlyURL layoutFriendlyURL) {
                    LayoutFriendlyURLLocalServiceUtil.deleteLayoutFriendlyURL((LayoutFriendlyURL)layoutFriendlyURL);
                }
            });
            actionableDynamicQuery.performActions();
        }
    }

    protected void verifyLayoutPrototypeLinkEnabled() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update Layout set layoutPrototypeLinkEnabled = [$FALSE$] where type_ = 'link_to_layout' and layoutPrototypeLinkEnabled = [$TRUE$]");
        }
    }

    protected void verifyUuid() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.verifyUuid("AssetEntry");
            this.runSQL("update Layout set uuid_ = sourcePrototypeLayoutUuid where sourcePrototypeLayoutUuid != '' and uuid_ != sourcePrototypeLayoutUuid");
        }
    }

    protected void verifyUuid(String tableName) throws Exception {
        StringBundler sb = new StringBundler(12);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set layoutUuid = (select distinct ");
        sb.append("sourcePrototypeLayoutUuid from Layout where Layout.uuid_ ");
        sb.append("= ");
        sb.append(tableName);
        sb.append(".layoutUuid) where exists (select 1 from Layout where ");
        sb.append("Layout.uuid_ = ");
        sb.append(tableName);
        sb.append(".layoutUuid and Layout.uuid_ != ");
        sb.append("Layout.sourcePrototypeLayoutUuid and ");
        sb.append("Layout.sourcePrototypeLayoutUuid != '')");
        this.runSQL(sb.toString());
    }
}

