/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.service.MBMessageLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBThreadLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.util.Date;
import java.util.List;

public class VerifyMessageBoards
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyMessageBoards.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyStatisticsForCategories();
        this.verifyStatisticsForThreads();
        this.verifyAssetsForMessages();
        this.verifyAssetsForThreads();
    }

    protected void verifyAssetsForMessages() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List messages = MBMessageLocalServiceUtil.getNoAssetMessages();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + messages.size() + " messages with no asset"));
            }
            for (MBMessage message : messages) {
                try {
                    MBMessageLocalServiceUtil.updateAsset((long)message.getUserId(), (MBMessage)message, null, null, null);
                    if (message.getStatus() != 2) continue;
                    boolean visible = false;
                    if (message.isApproved() && (message.getClassNameId() == 0L || message.getParentMessageId() != 0L)) {
                        visible = true;
                    }
                    AssetEntryLocalServiceUtil.updateEntry((String)message.getWorkflowClassName(), (long)message.getMessageId(), null, null, (boolean)true, (boolean)visible);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to update asset for message ", String.valueOf(message.getMessageId()), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for messages");
            }
        }
    }

    protected void verifyAssetsForThreads() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List threads = MBThreadLocalServiceUtil.getNoAssetThreads();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + threads.size() + " threads with no asset"));
            }
            for (MBThread thread : threads) {
                try {
                    AssetEntryLocalServiceUtil.updateEntry((long)thread.getRootMessageUserId(), (long)thread.getGroupId(), (Date)thread.getStatusDate(), (Date)thread.getLastPostDate(), (String)MBThread.class.getName(), (long)thread.getThreadId(), null, (long)0L, (long[])new long[0], (String[])new String[0], (boolean)true, (boolean)false, null, null, null, null, null, (String)String.valueOf(thread.getRootMessageId()), null, null, null, null, (int)0, (int)0, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to update asset for thread ", String.valueOf(thread.getThreadId()), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for threads");
            }
        }
    }

    protected void verifyStatisticsForCategories() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing categories for statistics accuracy");
            }
            StringBundler sb = new StringBundler(6);
            sb.append("update MBCategory set threadCount = (select count(*) ");
            sb.append("from MBThread where (MBCategory.groupId = ");
            sb.append("MBThread.groupId) and (MBCategory.categoryId = ");
            sb.append("MBThread.categoryId) and (MBThread.status = ");
            sb.append(0);
            sb.append("))");
            this.runSQL(sb.toString());
            sb.setIndex(0);
            sb.append("update MBCategory set messageCount = (select count(*) ");
            sb.append("from MBMessage where (MBCategory.groupId = ");
            sb.append("MBMessage.groupId) and (MBCategory.categoryId = ");
            sb.append("MBMessage.categoryId) and (MBMessage.status = ");
            sb.append(0);
            sb.append("))");
            this.runSQL(sb.toString());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Statistics verified for categories");
            }
        }
    }

    protected void verifyStatisticsForThreads() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing threads for statistics accuracy");
            }
            StringBundler sb = new StringBundler(5);
            sb.append("update MBThread set messageCount = (select count(*) ");
            sb.append("from MBMessage where (MBThread.threadId = ");
            sb.append("MBMessage.threadId) and (MBMessage.status = ");
            sb.append(0);
            sb.append("))");
            this.runSQL(sb.toString());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Statistics verified for threads");
            }
        }
    }
}

