/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.concurrent.ThrowableAwareRunnable;
import com.liferay.portal.kernel.concurrent.ThrowableAwareRunnablesExecutorUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class VerifyOrganization
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyOrganization.class);

    @Override
    protected void doVerify() throws Exception {
        ArrayList<ThrowableAwareRunnable> throwableAwareRunnables = new ArrayList<ThrowableAwareRunnable>();
        throwableAwareRunnables.add(new ThrowableAwareRunnable(){

            protected void doRun() throws Exception {
                VerifyOrganization.this.rebuildTree();
            }
        });
        throwableAwareRunnables.add(new ThrowableAwareRunnable(){

            protected void doRun() throws Exception {
                VerifyOrganization.this.updateOrganizationAssets();
            }
        });
        throwableAwareRunnables.add(new ThrowableAwareRunnable(){

            protected void doRun() throws Exception {
                VerifyOrganization.this.updateOrganizationAssetEntries();
            }
        });
        ThrowableAwareRunnablesExecutorUtil.execute(throwableAwareRunnables);
    }

    protected void rebuildTree() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
                OrganizationLocalServiceUtil.rebuildTree((long)companyId);
            }
        }
    }

    protected void updateOrganizationAssetEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(7);
            sb.append("select distinct AssetEntry.classPK as classPK, ");
            sb.append("Organization_.uuid_ as uuid from AssetEntry, ");
            sb.append("Organization_ where AssetEntry.classNameId = ");
            long classNameId = ClassNameLocalServiceUtil.getClassNameId((String)Organization.class.getName());
            sb.append(classNameId);
            sb.append(" and AssetEntry.classPK = ");
            sb.append("Organization_.organizationId and AssetEntry.classUuid ");
            sb.append("is null");
            try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps1.executeQuery();
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update AssetEntry set classUuid = ? where classPK = ? and classNameId = ?"));){
                while (rs.next()) {
                    long classPK = rs.getLong("classPK");
                    String uuid = rs.getString("uuid");
                    ps2.setString(1, uuid);
                    ps2.setLong(2, classPK);
                    ps2.setLong(3, classNameId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    protected void updateOrganizationAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List organizations = OrganizationLocalServiceUtil.getNoAssetOrganizations();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Processing ", String.valueOf(organizations.size()), " organizations with no asset"}));
            }
            for (Organization organization : organizations) {
                try {
                    OrganizationLocalServiceUtil.updateAsset((long)organization.getUserId(), (Organization)organization, null, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to update asset for organization ", String.valueOf(organization.getOrganizationId()), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for organizations");
            }
        }
    }
}

