/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletContext;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletFilterUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.FilterChainImpl;
import com.liferay.portlet.InvokerPortletResponse;
import com.liferay.portlet.PortletSessionImpl;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseImpl;
import com.liferay.portlet.StateAwareResponseImpl;
import com.liferay.portlet.StrutsPortlet;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.UnavailableException;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.StopWatch;

public class InvokerPortletImpl
implements InvokerFilterContainer,
InvokerPortlet {
    private static final Log _log = LogFactoryUtil.getLog(InvokerPortletImpl.class);
    private boolean _checkAuthToken;
    private Integer _expCache;
    private boolean _facesPortlet;
    private InvokerFilterContainer _invokerFilterContainer;
    private LiferayPortletConfig _liferayPortletConfig;
    private LiferayPortletContext _liferayPortletContext;
    private Portlet _portlet;
    private ClassLoader _portletClassLoader;
    private String _portletId;
    private com.liferay.portal.kernel.model.Portlet _portletModel;
    private boolean _strutsBridgePortlet;
    private boolean _strutsPortlet;

    public static void clearResponse(HttpSession session, long plid, String portletId, String languageId) {
        String sesResponseId = InvokerPortletImpl.encodeResponseKey(plid, portletId, languageId);
        InvokerPortletImpl.getResponses(session).remove(sesResponseId);
    }

    public static void clearResponses(HttpSession session) {
        InvokerPortletImpl.getResponses(session).clear();
    }

    public static void clearResponses(PortletSession session) {
        InvokerPortletImpl.getResponses(session).clear();
    }

    public static String encodeResponseKey(long plid, String portletId, String languageId) {
        StringBundler sb = new StringBundler(5);
        sb.append(StringUtil.toHexString((long)plid));
        sb.append("_");
        sb.append(portletId);
        sb.append("_");
        sb.append(languageId);
        return sb.toString();
    }

    public static Map<String, InvokerPortletResponse> getResponses(HttpSession session) {
        ConcurrentHashMap responses = (ConcurrentHashMap)session.getAttribute("CACHE_PORTLET_RESPONSES");
        if (responses == null) {
            responses = new ConcurrentHashMap();
            session.setAttribute("CACHE_PORTLET_RESPONSES", responses);
        }
        return responses;
    }

    public static Map<String, InvokerPortletResponse> getResponses(PortletSession portletSession) {
        return InvokerPortletImpl.getResponses(((PortletSessionImpl)portletSession).getHttpSession());
    }

    public InvokerPortletImpl(com.liferay.portal.kernel.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, InvokerFilterContainer invokerFilterContainer, boolean checkAuthToken, boolean facesPortlet, boolean strutsPortlet, boolean strutsBridgePortlet) {
        this._initialize(portletModel, portlet, portletConfig, portletContext, invokerFilterContainer, checkAuthToken, facesPortlet, strutsPortlet, strutsBridgePortlet);
    }

    public InvokerPortletImpl(com.liferay.portal.kernel.model.Portlet portletModel, Portlet portlet, PortletContext portletContext, InvokerFilterContainer invokerFilterContainer) {
        Map initParams = portletModel.getInitParams();
        boolean checkAuthToken = GetterUtil.getBoolean((String)((String)initParams.get("check-auth-token")), (boolean)true);
        boolean facesPortlet = false;
        if (ClassUtil.isSubclass(portlet.getClass(), (String)"javax.portlet.faces.GenericFacesPortlet")) {
            facesPortlet = true;
        }
        boolean strutsPortlet = ClassUtil.isSubclass(portlet.getClass(), StrutsPortlet.class);
        boolean strutsBridgePortlet = ClassUtil.isSubclass(portlet.getClass(), (String)"org.apache.portals.bridges.struts.StrutsPortlet");
        this._initialize(portletModel, portlet, null, portletContext, invokerFilterContainer, checkAuthToken, facesPortlet, strutsPortlet, strutsBridgePortlet);
    }

    public void destroy() {
        if (PortletIdCodec.hasInstanceId((String)this._portletModel.getPortletId())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Destroying an instanced portlet is not allowed");
            }
            return;
        }
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            if (this._portletClassLoader != null) {
                ClassLoaderUtil.setContextClassLoader((ClassLoader)this._portletClassLoader);
            }
            Closeable closeable = (Closeable)this._invokerFilterContainer;
            closeable.close();
            this._portlet.destroy();
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
        finally {
            if (this._portletClassLoader != null) {
                ClassLoaderUtil.setContextClassLoader((ClassLoader)contextClassLoader);
            }
        }
    }

    public List<ActionFilter> getActionFilters() {
        return this._invokerFilterContainer.getActionFilters();
    }

    public List<EventFilter> getEventFilters() {
        return this._invokerFilterContainer.getEventFilters();
    }

    public Integer getExpCache() {
        return this._expCache;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public ClassLoader getPortletClassLoader() {
        ClassLoader classLoader = (ClassLoader)this._liferayPortletContext.getAttribute("PLUGIN_CLASS_LOADER");
        if (classLoader == null) {
            classLoader = ClassLoaderUtil.getPortalClassLoader();
        }
        return classLoader;
    }

    public PortletConfig getPortletConfig() {
        return this._liferayPortletConfig;
    }

    public PortletContext getPortletContext() {
        return this._liferayPortletContext;
    }

    public Portlet getPortletInstance() {
        return this._portlet;
    }

    public List<RenderFilter> getRenderFilters() {
        return this._invokerFilterContainer.getRenderFilters();
    }

    public List<ResourceFilter> getResourceFilters() {
        return this._invokerFilterContainer.getResourceFilters();
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        this._liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        this._portletClassLoader = this.getPortletClassLoader();
        try {
            if (this._portletClassLoader != null) {
                ClassLoaderUtil.setContextClassLoader((ClassLoader)this._portletClassLoader);
            }
            this._portlet.init(portletConfig);
        }
        finally {
            if (this._portletClassLoader != null) {
                ClassLoaderUtil.setContextClassLoader((ClassLoader)contextClassLoader);
            }
        }
    }

    public boolean isCheckAuthToken() {
        return this._checkAuthToken;
    }

    public boolean isFacesPortlet() {
        return this._facesPortlet;
    }

    public boolean isStrutsBridgePortlet() {
        return this._strutsBridgePortlet;
    }

    public boolean isStrutsPortlet() {
        return this._strutsPortlet;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeAction(actionRequest, actionResponse);
        }
        catch (Exception e) {
            this.processException(e, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"processAction for ", this._portletId, " takes ", String.valueOf(stopWatch.getTime()), " ms"}));
        }
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeEvent(eventRequest, eventResponse);
        }
        catch (Exception e) {
            this.processException(e, (PortletRequest)eventRequest, (PortletResponse)eventResponse);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"processEvent for ", this._portletId, " takes ", String.valueOf(stopWatch.getTime()), " ms"}));
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletException portletException = (PortletException)((Object)renderRequest.getAttribute(this._portletId + PortletException.class.getName()));
        if (portletException != null) {
            throw portletException;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String remoteUser = renderRequest.getRemoteUser();
        if (remoteUser == null || this._expCache == null || this._expCache == 0) {
            this.invokeRender(renderRequest, renderResponse);
        } else {
            String sessionResponseId;
            RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)renderResponseImpl.getHttpServletResponse();
            PortletSession portletSession = renderRequest.getPortletSession();
            long now = System.currentTimeMillis();
            Layout layout = (Layout)renderRequest.getAttribute("LAYOUT");
            Map<String, InvokerPortletResponse> sessionResponses = InvokerPortletImpl.getResponses(portletSession);
            InvokerPortletResponse response = sessionResponses.get(sessionResponseId = InvokerPortletImpl.encodeResponseKey(layout.getPlid(), this._portletId, LanguageUtil.getLanguageId((PortletRequest)renderRequest)));
            if (response == null) {
                String title = this.invokeRender(renderRequest, renderResponse);
                response = new InvokerPortletResponse(title, bufferCacheServletResponse.getString(), now + 1000L * (long)this._expCache.intValue());
                sessionResponses.put(sessionResponseId, response);
            } else if (response.getTime() < now && this._expCache > 0) {
                String title = this.invokeRender(renderRequest, renderResponse);
                response.setTitle(title);
                response.setContent(bufferCacheServletResponse.getString());
                response.setTime(now + 1000L * (long)this._expCache.intValue());
            } else {
                renderResponseImpl.setTitle(response.getTitle());
                PrintWriter printWriter = bufferCacheServletResponse.getWriter();
                printWriter.print(response.getContent());
            }
        }
        Map<String, String[]> properties = ((RenderResponseImpl)renderResponse).getProperties();
        if (properties.containsKey("clear-request-parameters")) {
            ((RenderRequestImpl)renderRequest).clearRenderParameters();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"render for ", this._portletId, " takes ", String.valueOf(stopWatch.getTime()), " ms"}));
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeResource(resourceRequest, resourceResponse);
        }
        catch (Exception e) {
            this.processException(e, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"serveResource for ", this._portletId, " takes ", String.valueOf(stopWatch.getTime()), " ms"}));
        }
    }

    @Deprecated
    public void setPortletFilters() {
    }

    protected void invoke(LiferayPortletRequest portletRequest, LiferayPortletResponse portletResponse, String lifecycle, List<? extends PortletFilter> filters) throws IOException, PortletException {
        String[] expCache;
        FilterChainImpl filterChain = new FilterChainImpl(this._portlet, filters);
        if (this._liferayPortletConfig.isWARFile()) {
            String invokerPortletName = this._liferayPortletConfig.getInitParameter("com.liferay.portal.invokerPortletName");
            if (invokerPortletName == null) {
                invokerPortletName = this._liferayPortletConfig.getPortletName();
            }
            String path = "/" + invokerPortletName + "/invoke";
            ServletContext servletContext = this._liferayPortletContext.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            HttpServletRequest request = portletRequest.getHttpServletRequest();
            HttpServletResponse response = portletResponse.getHttpServletResponse();
            request.setAttribute("javax.portlet.portlet", (Object)this._portlet);
            request.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
            request.setAttribute("com.liferay.portal.kernel.servlet.PortletServletFilterChain", (Object)filterChain);
            try {
                if (lifecycle.equals("RESOURCE_PHASE")) {
                    requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException se) {
                Throwable cause = se.getRootCause();
                if (cause instanceof PortletException) {
                    throw (PortletException)cause;
                }
                throw new PortletException(cause);
            }
        } else {
            PortletFilterUtil.doFilter((PortletRequest)portletRequest, (PortletResponse)portletResponse, (String)lifecycle, (FilterChain)filterChain);
        }
        portletResponse.transferMarkupHeadElements();
        Map properties = portletResponse.getProperties();
        if (MapUtil.isNotEmpty((Map)properties) && this._expCache != null && (expCache = (String[])properties.get("portlet.expiration-cache")) != null && expCache.length > 0 && expCache[0] != null) {
            this._expCache = GetterUtil.getInteger((String)expCache[0]);
        }
    }

    protected void invokeAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)actionRequest);
        LiferayPortletResponse portletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)actionResponse);
        this.invoke(portletRequest, portletResponse, "ACTION_PHASE", this._invokerFilterContainer.getActionFilters());
    }

    protected void invokeEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)eventRequest);
        LiferayPortletResponse portletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)eventResponse);
        this.invoke(portletRequest, portletResponse, "EVENT_PHASE", this._invokerFilterContainer.getEventFilters());
    }

    protected String invokeRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)renderRequest);
        LiferayPortletResponse portletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)renderResponse);
        try {
            this.invoke(portletRequest, portletResponse, "RENDER_PHASE", this._invokerFilterContainer.getRenderFilters());
        }
        catch (Exception e) {
            this.processException(e, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
            throw e;
        }
        RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
        return renderResponseImpl.getTitle();
    }

    protected void invokeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)resourceRequest);
        LiferayPortletResponse portletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)resourceResponse);
        this.invoke(portletRequest, portletResponse, "RESOURCE_PHASE", this._invokerFilterContainer.getResourceFilters());
    }

    protected void processException(Exception e, PortletRequest portletRequest, PortletResponse portletResponse) {
        if (portletResponse instanceof StateAwareResponseImpl) {
            StateAwareResponseImpl stateAwareResponseImpl = (StateAwareResponseImpl)portletResponse;
            stateAwareResponseImpl.reset();
        }
        if (e instanceof RuntimeException) {
            e = new PortletException(e);
        }
        if (e instanceof UnavailableException) {
            this.destroy();
            PortletLocalServiceUtil.deletePortlet((com.liferay.portal.kernel.model.Portlet)this._portletModel);
        }
        if (e instanceof PortletException) {
            if (portletResponse instanceof StateAwareResponseImpl && !(e instanceof UnavailableException)) {
                return;
            }
            if (!(portletRequest instanceof RenderRequest)) {
                portletRequest.setAttribute(this._portletId + PortletException.class.getName(), (Object)e);
            }
        } else {
            ReflectionUtil.throwException((Throwable)e);
        }
    }

    private void _initialize(com.liferay.portal.kernel.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, InvokerFilterContainer invokerFilterContainer, boolean checkAuthToken, boolean facesPortlet, boolean strutsPortlet, boolean strutsBridgePortlet) {
        this._portletModel = portletModel;
        this._portlet = portlet;
        this._liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        this._portletId = this._portletModel.getPortletId();
        this._liferayPortletContext = (LiferayPortletContext)portletContext;
        this._invokerFilterContainer = invokerFilterContainer;
        this._checkAuthToken = checkAuthToken;
        this._facesPortlet = facesPortlet;
        this._strutsPortlet = strutsPortlet;
        this._strutsBridgePortlet = strutsBridgePortlet;
        this._expCache = portletModel.getExpCache();
        if (_log.isDebugEnabled()) {
            com.liferay.portal.kernel.model.Portlet portletContextPortet = this._liferayPortletContext.getPortlet();
            _log.debug((Object)("Create instance cache wrapper for " + portletContextPortet.getPortletId()));
        }
    }
}

