/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.exception.CategoryPropertyKeyException;
import com.liferay.asset.kernel.exception.CategoryPropertyValueException;
import com.liferay.asset.kernel.exception.DuplicateCategoryPropertyException;
import com.liferay.asset.kernel.model.AssetCategoryProperty;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portlet.asset.service.base.AssetCategoryPropertyLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.AssetUtil;
import java.util.List;

public class AssetCategoryPropertyLocalServiceImpl
extends AssetCategoryPropertyLocalServiceBaseImpl {
    public AssetCategoryProperty addCategoryProperty(long userId, long categoryId, String key, String value) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validate(key, value);
        if (this.hasCategoryProperty(categoryId, key)) {
            throw new DuplicateCategoryPropertyException("A category property already exists with the key " + key);
        }
        long categoryPropertyId = this.counterLocalService.increment();
        AssetCategoryProperty categoryProperty = this.assetCategoryPropertyPersistence.create(categoryPropertyId);
        categoryProperty.setCompanyId(user.getCompanyId());
        categoryProperty.setUserId(user.getUserId());
        categoryProperty.setUserName(user.getFullName());
        categoryProperty.setCategoryId(categoryId);
        categoryProperty.setKey(key);
        categoryProperty.setValue(value);
        this.assetCategoryPropertyPersistence.update((BaseModel)categoryProperty);
        return categoryProperty;
    }

    public void deleteCategoryProperties(long entryId) {
        List categoryProperties = this.assetCategoryPropertyPersistence.findByCategoryId(entryId);
        for (AssetCategoryProperty categoryProperty : categoryProperties) {
            this.deleteCategoryProperty(categoryProperty);
        }
    }

    public void deleteCategoryProperty(AssetCategoryProperty categoryProperty) {
        this.assetCategoryPropertyPersistence.remove((BaseModel)categoryProperty);
    }

    public void deleteCategoryProperty(long categoryPropertyId) throws PortalException {
        AssetCategoryProperty categoryProperty = this.assetCategoryPropertyPersistence.findByPrimaryKey(categoryPropertyId);
        this.deleteCategoryProperty(categoryProperty);
    }

    public List<AssetCategoryProperty> getCategoryProperties() {
        return this.assetCategoryPropertyPersistence.findAll();
    }

    public List<AssetCategoryProperty> getCategoryProperties(long entryId) {
        return this.assetCategoryPropertyPersistence.findByCategoryId(entryId);
    }

    public AssetCategoryProperty getCategoryProperty(long categoryPropertyId) throws PortalException {
        return this.assetCategoryPropertyPersistence.findByPrimaryKey(categoryPropertyId);
    }

    public AssetCategoryProperty getCategoryProperty(long categoryId, String key) throws PortalException {
        return this.assetCategoryPropertyPersistence.findByCA_K(categoryId, key);
    }

    public List<AssetCategoryProperty> getCategoryPropertyValues(long groupId, String key) {
        return this.assetCategoryPropertyFinder.findByG_K(groupId, key);
    }

    public AssetCategoryProperty updateCategoryProperty(long userId, long categoryPropertyId, String key, String value) throws PortalException {
        AssetCategoryProperty categoryProperty = this.assetCategoryPropertyPersistence.findByPrimaryKey(categoryPropertyId);
        String categoryPropertyKey = categoryProperty.getKey();
        if (!categoryPropertyKey.equals(key) && this.hasCategoryProperty(categoryProperty.getCategoryId(), key)) {
            throw new DuplicateCategoryPropertyException("A category property already exists with the key " + key);
        }
        this.validate(key, value);
        if (userId != 0L) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            categoryProperty.setUserId(userId);
            categoryProperty.setUserName(user.getFullName());
        }
        categoryProperty.setKey(key);
        categoryProperty.setValue(value);
        this.assetCategoryPropertyPersistence.update((BaseModel)categoryProperty);
        return categoryProperty;
    }

    public AssetCategoryProperty updateCategoryProperty(long categoryPropertyId, String key, String value) throws PortalException {
        return this.updateCategoryProperty(0L, categoryPropertyId, key, value);
    }

    protected boolean hasCategoryProperty(long categoryId, String key) {
        AssetCategoryProperty categoryProperty = this.assetCategoryPropertyPersistence.fetchByCA_K(categoryId, key);
        return categoryProperty != null;
    }

    protected void validate(String key, String value) throws PortalException {
        if (!AssetUtil.isValidWord(key)) {
            throw new CategoryPropertyKeyException("Invalid key " + key);
        }
        if (!AssetUtil.isValidWord(value)) {
            throw new CategoryPropertyValueException("Invalid value " + value);
        }
    }
}

