/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetTagDisplay;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetTagServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetTagPermission;
import com.liferay.portlet.asset.service.permission.AssetTagsPermission;
import com.liferay.portlet.asset.util.comparator.AssetTagNameComparator;
import com.liferay.util.Autocomplete;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class AssetTagServiceImpl
extends AssetTagServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetTagServiceImpl.class);

    public AssetTag addTag(long groupId, String name, ServiceContext serviceContext) throws PortalException {
        AssetTagsPermission.check(this.getPermissionChecker(), groupId, "ADD_TAG");
        return this.assetTagLocalService.addTag(this.getUserId(), groupId, name, serviceContext);
    }

    public void deleteTag(long tagId) throws PortalException {
        AssetTagPermission.check(this.getPermissionChecker(), tagId, "DELETE");
        this.assetTagLocalService.deleteTag(tagId);
    }

    public void deleteTags(long[] tagIds) throws PortalException {
        for (long tagId : tagIds) {
            AssetTagPermission.check(this.getPermissionChecker(), tagId, "DELETE");
            this.assetTagLocalService.deleteTag(tagId);
        }
    }

    public List<AssetTag> getGroupsTags(long[] groupIds) {
        TreeSet<AssetTag> groupsTags = new TreeSet<AssetTag>((Comparator<AssetTag>)((Object)new AssetTagNameComparator()));
        for (long groupId : groupIds) {
            List<AssetTag> groupTags = this.getGroupTags(groupId);
            groupsTags.addAll(groupTags);
        }
        return new ArrayList<AssetTag>(groupsTags);
    }

    public List<AssetTag> getGroupTags(long groupId) {
        return this.sanitize(this.assetTagPersistence.findByGroupId(groupId));
    }

    public List<AssetTag> getGroupTags(long groupId, int start, int end, OrderByComparator<AssetTag> obc) {
        return this.sanitize(this.assetTagPersistence.findByGroupId(groupId, start, end, obc));
    }

    public int getGroupTagsCount(long groupId) {
        return this.assetTagPersistence.countByGroupId(groupId);
    }

    public AssetTagDisplay getGroupTagsDisplay(long groupId, String name, int start, int end) {
        List<AssetTag> tags = null;
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            tags = this.getTags(groupId, name, start, end);
            total = this.getTagsCount(groupId, name);
        } else {
            tags = this.getGroupTags(groupId, start, end, null);
            total = this.getGroupTagsCount(groupId);
        }
        return new AssetTagDisplay(tags, total, start, end);
    }

    public AssetTag getTag(long tagId) throws PortalException {
        return this.sanitize(this.assetTagLocalService.getTag(tagId));
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name) {
        return this.sanitize(this.assetTagFinder.findByG_C_N(groupId, classNameId, name, -1, -1, null));
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name, int start, int end, OrderByComparator<AssetTag> obc) {
        return this.sanitize(this.assetTagFinder.findByG_C_N(groupId, classNameId, name, start, end, obc));
    }

    public List<AssetTag> getTags(long groupId, String name, int start, int end) {
        return this.getTags(new long[]{groupId}, name, start, end);
    }

    public List<AssetTag> getTags(long groupId, String name, int start, int end, OrderByComparator<AssetTag> obc) {
        return this.getTags(new long[]{groupId}, name, start, end, obc);
    }

    public List<AssetTag> getTags(long[] groupIds, String name, int start, int end) {
        return this.getTags(groupIds, name, start, end, (OrderByComparator<AssetTag>)new AssetTagNameComparator());
    }

    public List<AssetTag> getTags(long[] groupIds, String name, int start, int end, OrderByComparator<AssetTag> obc) {
        if (Validator.isNull((String)name)) {
            return this.sanitize(this.assetTagPersistence.findByGroupId(groupIds, start, end, obc));
        }
        return this.sanitize(this.assetTagPersistence.findByG_LikeN(groupIds, name, start, end, obc));
    }

    public List<AssetTag> getTags(String className, long classPK) {
        return this.sanitize(this.assetTagLocalService.getTags(className, classPK));
    }

    public int getTagsCount(long groupId, String name) {
        if (Validator.isNull((String)name)) {
            return this.assetTagPersistence.countByGroupId(groupId);
        }
        return this.assetTagPersistence.countByG_LikeN(groupId, name);
    }

    public int getVisibleAssetsTagsCount(long groupId, long classNameId, String name) {
        return this.assetTagFinder.countByG_C_N(groupId, classNameId, name);
    }

    public int getVisibleAssetsTagsCount(long groupId, String name) {
        return this.assetTagFinder.countByG_N(groupId, name);
    }

    public void mergeTags(long fromTagId, long toTagId) throws PortalException {
        AssetTagPermission.check(this.getPermissionChecker(), toTagId, "UPDATE");
        this.assetTagLocalService.mergeTags(fromTagId, toTagId);
    }

    public void mergeTags(long[] fromTagIds, long toTagId) throws PortalException {
        for (long fromTagId : fromTagIds) {
            this.mergeTags(fromTagId, toTagId);
        }
    }

    public JSONArray search(long groupId, String name, int start, int end) {
        return this.search(new long[]{groupId}, name, start, end);
    }

    public JSONArray search(long[] groupIds, String name, int start, int end) {
        List<AssetTag> tags = this.getTags(groupIds, name, start, end);
        return Autocomplete.listToJson(tags, (String)"name", (String)"name");
    }

    public AssetTag updateTag(long tagId, String name, ServiceContext serviceContext) throws PortalException {
        AssetTagPermission.check(this.getPermissionChecker(), tagId, "UPDATE");
        return this.assetTagLocalService.updateTag(this.getUserId(), tagId, name, serviceContext);
    }

    protected AssetTag sanitize(AssetTag tag) {
        if (tag == null) {
            return null;
        }
        try {
            PermissionChecker permissionChecker = this.getPermissionChecker();
            if (permissionChecker.isCompanyAdmin(tag.getCompanyId()) || tag.getUserId() == permissionChecker.getUserId()) {
                return tag;
            }
        }
        catch (PrincipalException pe) {
            _log.error((Throwable)pe);
        }
        tag.setUserId(0L);
        tag.setUserName("");
        tag.setUserUuid("");
        return tag;
    }

    protected List<AssetTag> sanitize(List<AssetTag> tags) {
        for (AssetTag tag : tags) {
            this.sanitize(tag);
        }
        return tags;
    }
}

