/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.blogs.BlogsEntryAttachmentFileEntryReference;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlogsEntryAttachmentFileEntryHelper {
    private static final String _ATTRIBUTE_LIST_REGEXP = "(\\s*?\\w+\\s*?=\\s*?\"[^\"]*\")*?\\s*?";
    private static final int _UNIQUE_FILE_NAME_TRIES = 50;
    private static final Log _log = LogFactoryUtil.getLog(BlogsEntryAttachmentFileEntryHelper.class);

    public List<BlogsEntryAttachmentFileEntryReference> addBlogsEntryAttachmentFileEntries(long groupId, long userId, long blogsEntryId, long folderId, List<FileEntry> tempFileEntries) throws PortalException {
        ArrayList<BlogsEntryAttachmentFileEntryReference> blogsEntryAttachmentFileEntryReferences = new ArrayList<BlogsEntryAttachmentFileEntryReference>();
        for (FileEntry tempFileEntry : tempFileEntries) {
            FileEntry blogsEntryAttachmentFileEntry = this.addBlogsEntryAttachmentFileEntry(groupId, userId, blogsEntryId, folderId, tempFileEntry.getTitle(), tempFileEntry.getMimeType(), tempFileEntry.getContentStream());
            blogsEntryAttachmentFileEntryReferences.add(new BlogsEntryAttachmentFileEntryReference(tempFileEntry.getFileEntryId(), blogsEntryAttachmentFileEntry));
        }
        return blogsEntryAttachmentFileEntryReferences;
    }

    public FileEntry addBlogsEntryAttachmentFileEntry(long groupId, long userId, long blogsEntryId, long folderId, String fileName, String mimeType, byte[] bytes) throws PortalException {
        String uniqueFileName = this.getUniqueFileName(groupId, fileName, folderId);
        return PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)blogsEntryId, (String)"com.liferay.blogs", (long)folderId, (byte[])bytes, (String)uniqueFileName, (String)mimeType, (boolean)true);
    }

    public FileEntry addBlogsEntryAttachmentFileEntry(long groupId, long userId, long blogsEntryId, long folderId, String fileName, String mimeType, File file) throws PortalException {
        String uniqueFileName = this.getUniqueFileName(groupId, fileName, folderId);
        return PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)blogsEntryId, (String)"com.liferay.blogs", (long)folderId, (File)file, (String)uniqueFileName, (String)mimeType, (boolean)true);
    }

    public FileEntry addBlogsEntryAttachmentFileEntry(long groupId, long userId, long blogsEntryId, long folderId, String fileName, String mimeType, InputStream is) throws PortalException {
        String uniqueFileName = this.getUniqueFileName(groupId, fileName, folderId);
        return PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)blogsEntryId, (String)"com.liferay.blogs", (long)folderId, (InputStream)is, (String)uniqueFileName, (String)mimeType, (boolean)true);
    }

    public List<FileEntry> getTempBlogsEntryAttachmentFileEntries(String content) throws PortalException {
        ArrayList<FileEntry> tempBlogsEntryAttachmentFileEntries = new ArrayList<FileEntry>();
        Pattern pattern = Pattern.compile("data-image-id=.(\\d+)");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            long fileEntryId = GetterUtil.getLong((String)matcher.group(1));
            FileEntry tempFileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
            tempBlogsEntryAttachmentFileEntries.add(tempFileEntry);
        }
        return tempBlogsEntryAttachmentFileEntries;
    }

    @Deprecated
    public String updateContent(String content, List<BlogsEntryAttachmentFileEntryReference> blogsEntryAttachmentFileEntryReferences) {
        for (BlogsEntryAttachmentFileEntryReference blogsEntryAttachmentFileEntryReference : blogsEntryAttachmentFileEntryReferences) {
            StringBundler sb = new StringBundler(8);
            sb.append("<\\s*?img");
            sb.append(_ATTRIBUTE_LIST_REGEXP);
            sb.append("data-image-id");
            sb.append("\\s*?=\\s*?\"");
            sb.append(blogsEntryAttachmentFileEntryReference.getTempBlogsEntryAttachmentFileEntryId());
            sb.append("\"");
            sb.append(_ATTRIBUTE_LIST_REGEXP);
            sb.append("/>");
            content = content.replaceAll(sb.toString(), this.getBlogsEntryAttachmentFileEntryImgTag(blogsEntryAttachmentFileEntryReference.getBlogsEntryAttachmentFileEntry()));
        }
        return content;
    }

    protected String getBlogsEntryAttachmentFileEntryImgTag(FileEntry blogsEntryAttachmentFileEntry) {
        String fileEntryURL = PortletFileRepositoryUtil.getPortletFileEntryURL(null, (FileEntry)blogsEntryAttachmentFileEntry, (String)"");
        return "<img src=\"" + fileEntryURL + "\" />";
    }

    protected String getUniqueFileName(long groupId, String fileName, long folderId) throws PortalException {
        FileEntry fileEntry = this._fetchPortletFileEntry(groupId, fileName = FileUtil.stripParentheticalSuffix((String)fileName), folderId);
        if (fileEntry == null) {
            return fileName;
        }
        int suffix = 1;
        for (int i = 0; i < 50; ++i) {
            String curFileName = FileUtil.appendParentheticalSuffix((String)fileName, (String)String.valueOf(suffix));
            fileEntry = this._fetchPortletFileEntry(groupId, curFileName, folderId);
            if (fileEntry == null) {
                return curFileName;
            }
            ++suffix;
        }
        throw new PortalException(StringBundler.concat((String[])new String[]{"Unable to get a unique file name for ", fileName, " in folder ", String.valueOf(folderId)}));
    }

    private FileEntry _fetchPortletFileEntry(long groupId, String fileName, long folderId) {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)groupId, (long)folderId, (String)fileName);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }
}

