/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.impl;

import com.liferay.blogs.kernel.exception.NoSuchStatsUserException;
import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.model.BlogsStatsUser;
import com.liferay.blogs.kernel.util.comparator.EntryDisplayDateComparator;
import com.liferay.blogs.kernel.util.comparator.StatsUserLastPostDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.blogs.service.base.BlogsStatsUserLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class BlogsStatsUserLocalServiceImpl
extends BlogsStatsUserLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(BlogsStatsUserLocalServiceImpl.class);

    public void deleteStatsUser(BlogsStatsUser statsUsers) {
        this.blogsStatsUserPersistence.remove((BaseModel)statsUsers);
    }

    public void deleteStatsUser(long statsUserId) throws PortalException {
        BlogsStatsUser statsUsers = this.blogsStatsUserPersistence.findByPrimaryKey(statsUserId);
        this.deleteStatsUser(statsUsers);
    }

    public void deleteStatsUserByGroupId(long groupId) {
        List statsUsers = this.blogsStatsUserPersistence.findByGroupId(groupId);
        for (BlogsStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public void deleteStatsUserByUserId(long userId) {
        List statsUsers = this.blogsStatsUserPersistence.findByUserId(userId);
        for (BlogsStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public List<BlogsStatsUser> getCompanyStatsUsers(long companyId, int start, int end) {
        return this.blogsStatsUserPersistence.findByC_NotE(companyId, 0, start, end, (OrderByComparator)new StatsUserLastPostDateComparator());
    }

    public List<BlogsStatsUser> getCompanyStatsUsers(long companyId, int start, int end, OrderByComparator<BlogsStatsUser> obc) {
        return this.blogsStatsUserPersistence.findByC_NotE(companyId, 0, start, end, obc);
    }

    public int getCompanyStatsUsersCount(long companyId) {
        return this.blogsStatsUserPersistence.countByC_NotE(companyId, 0);
    }

    public List<BlogsStatsUser> getGroupsStatsUsers(long companyId, long groupId, int start, int end) {
        return this.blogsStatsUserFinder.findByGroupIds(companyId, groupId, start, end);
    }

    public List<BlogsStatsUser> getGroupStatsUsers(long groupId, int start, int end) {
        return this.blogsStatsUserPersistence.findByG_NotE(groupId, 0, start, end, (OrderByComparator)new StatsUserLastPostDateComparator());
    }

    public List<BlogsStatsUser> getGroupStatsUsers(long groupId, int start, int end, OrderByComparator<BlogsStatsUser> obc) {
        return this.blogsStatsUserPersistence.findByG_NotE(groupId, 0, start, end, obc);
    }

    public int getGroupStatsUsersCount(long groupId) {
        return this.blogsStatsUserPersistence.countByG_NotE(groupId, 0);
    }

    public List<BlogsStatsUser> getOrganizationStatsUsers(long organizationId, int start, int end) {
        return this.blogsStatsUserFinder.findByOrganizationId(organizationId, start, end, (OrderByComparator)new StatsUserLastPostDateComparator());
    }

    public List<BlogsStatsUser> getOrganizationStatsUsers(long organizationId, int start, int end, OrderByComparator<BlogsStatsUser> obc) {
        return this.blogsStatsUserFinder.findByOrganizationId(organizationId, start, end, obc);
    }

    public int getOrganizationStatsUsersCount(long organizationId) {
        return this.blogsStatsUserFinder.countByOrganizationId(organizationId);
    }

    public BlogsStatsUser getStatsUser(long groupId, long userId) throws PortalException {
        BlogsStatsUser statsUser = this.blogsStatsUserPersistence.fetchByG_U(groupId, userId);
        if (statsUser == null) {
            Group group = this.groupPersistence.findByPrimaryKey(groupId);
            long statsUserId = this.counterLocalService.increment();
            statsUser = this.blogsStatsUserPersistence.create(statsUserId);
            statsUser.setCompanyId(group.getCompanyId());
            statsUser.setGroupId(groupId);
            statsUser.setUserId(userId);
            this.blogsStatsUserPersistence.update((BaseModel)statsUser);
        }
        return statsUser;
    }

    public void updateStatsUser(long groupId, long userId) throws PortalException {
        this.updateStatsUser(groupId, userId, null);
    }

    public void updateStatsUser(long groupId, long userId, Date displayDate) throws PortalException {
        Date now = new Date();
        int entryCount = this.blogsEntryPersistence.countByG_U_LtD_S(groupId, userId, now, 0);
        if (entryCount == 0) {
            block11: {
                try {
                    this.blogsStatsUserPersistence.removeByG_U(groupId, userId);
                }
                catch (NoSuchStatsUserException nssue) {
                    if (!_log.isWarnEnabled()) break block11;
                    _log.warn((Object)nssue, (Throwable)nssue);
                }
            }
            return;
        }
        BlogsStatsUser statsUser = this.getStatsUser(groupId, userId);
        statsUser.setEntryCount(entryCount);
        BlogsEntry blogsEntry = this.blogsEntryPersistence.findByG_U_LtD_S_First(groupId, userId, now, 0, (OrderByComparator)new EntryDisplayDateComparator());
        Date lastDisplayDate = blogsEntry.getDisplayDate();
        Date lastPostDate = statsUser.getLastPostDate();
        if (displayDate != null && displayDate.before(now)) {
            if (lastPostDate == null) {
                statsUser.setLastPostDate(displayDate);
            } else if (displayDate.after(lastPostDate)) {
                statsUser.setLastPostDate(displayDate);
            } else if (lastDisplayDate.before(lastPostDate)) {
                statsUser.setLastPostDate(lastDisplayDate);
            }
        } else if (lastPostDate == null || lastPostDate.before(lastDisplayDate)) {
            statsUser.setLastPostDate(lastDisplayDate);
        }
        this.blogsStatsUserPersistence.update((BaseModel)statsUser);
    }
}

