/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.messaging;

import com.liferay.mail.kernel.model.Account;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBMessageConstants;
import com.liferay.message.boards.kernel.service.MBMessageLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBMessageServiceUtil;
import com.liferay.petra.mail.MailEngine;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import com.liferay.portlet.messageboards.messaging.MailingListRequest;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.portlet.messageboards.util.MailingListThreadLocal;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;

public class MailingListMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(MailingListMessageListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceive(Message message) throws Exception {
        MailingListRequest mailingListRequest = (MailingListRequest)message.getPayload();
        Store store = null;
        Folder folder = null;
        javax.mail.Message[] messages = null;
        try {
            store = this.getStore(mailingListRequest);
            store.connect();
            folder = this.getFolder(store);
            messages = folder.getMessages();
            this.processMessages(mailingListRequest, messages);
        }
        finally {
            if (folder != null && folder.isOpen()) {
                try {
                    folder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
                }
                catch (Exception exception) {}
                try {
                    folder.close(true);
                }
                catch (Exception exception) {}
            }
            if (store != null && store.isConnected()) {
                try {
                    store.close();
                }
                catch (MessagingException messagingException) {}
            }
        }
    }

    protected Folder getFolder(Store store) throws Exception {
        Folder folder = store.getFolder("INBOX");
        if (!folder.exists()) {
            throw new MessagingException("Inbox not found");
        }
        folder.open(2);
        return folder;
    }

    protected Store getStore(MailingListRequest mailingListRequest) throws Exception {
        String protocol = mailingListRequest.getInProtocol();
        String host = mailingListRequest.getInServerName();
        int port = mailingListRequest.getInServerPort();
        String user = mailingListRequest.getInUserName();
        String password = mailingListRequest.getInPassword();
        Account account = Account.getInstance((String)protocol, (int)port);
        account.setHost(host);
        account.setPort(port);
        account.setUser(user);
        account.setPassword(password);
        Session session = MailEngine.getSession((Account)account);
        URLName urlName = new URLName(protocol, host, port, "", user, password);
        Store store = session.getStore(urlName);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessage(MailingListRequest mailingListRequest, javax.mail.Message mailMessage) throws Exception {
        if (MBUtil.hasMailIdHeader(mailMessage)) {
            return;
        }
        String from = null;
        Object[] addresses = mailMessage.getFrom();
        if (ArrayUtil.isNotEmpty((Object[])addresses)) {
            Object address = addresses[0];
            from = address instanceof InternetAddress ? ((InternetAddress)address).getAddress() : address.toString();
        }
        long companyId = mailingListRequest.getCompanyId();
        long groupId = mailingListRequest.getGroupId();
        long categoryId = mailingListRequest.getCategoryId();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Category id " + categoryId));
        }
        boolean anonymous = false;
        User user = UserLocalServiceUtil.fetchUserByEmailAddress((long)companyId, (String)from);
        if (user == null) {
            if (!mailingListRequest.isAllowAnonymous()) {
                return;
            }
            anonymous = true;
            user = UserLocalServiceUtil.getUserById((long)companyId, (long)mailingListRequest.getUserId());
        }
        long parentMessageId = MBUtil.getParentMessageId(mailMessage);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Parent message id " + parentMessageId));
        }
        MBMessage parentMessage = null;
        if (parentMessageId > 0L) {
            parentMessage = MBMessageLocalServiceUtil.fetchMBMessage((long)parentMessageId);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Parent message " + parentMessage));
        }
        MBMailMessage mbMailMessage = new MBMailMessage();
        MBUtil.collectPartContent((Part)mailMessage, mbMailMessage);
        PermissionCheckerUtil.setThreadValues(user);
        MailingListThreadLocal.setSourceMailingList(true);
        String subject = MBUtil.getSubjectWithoutMessageId(mailMessage);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        String portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL((long)groupId, (String)portletId));
        serviceContext.setScopeGroupId(groupId);
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = mbMailMessage.getInputStreamOVPs();
        try {
            if (parentMessage == null) {
                MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)anonymous, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
            } else {
                MBMessageServiceUtil.addMessage((long)parentMessage.getMessageId(), (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)anonymous, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
            }
        }
        catch (Throwable throwable) {
            for (ObjectValuePair<String, InputStream> inputStreamOVP : inputStreamOVPs) {
                InputStream inputStream = (InputStream)inputStreamOVP.getValue();
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
            throw throwable;
        }
        for (ObjectValuePair<String, InputStream> inputStreamOVP : inputStreamOVPs) {
            InputStream inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessages(MailingListRequest mailingListRequest, javax.mail.Message[] messages) throws Exception {
        for (javax.mail.Message message : messages) {
            try {
                this.processMessage(mailingListRequest, message);
            }
            finally {
                PermissionCheckerUtil.setThreadValues(null);
            }
        }
    }
}

