/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.message.boards.kernel.model.MBStatsUser;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.messageboards.service.base.MBStatsUserLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class MBStatsUserLocalServiceImpl
extends MBStatsUserLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(MBStatsUserLocalServiceImpl.class);

    public MBStatsUser addStatsUser(long groupId, long userId) {
        MBStatsUser statsUser;
        block3: {
            long statsUserId = this.counterLocalService.increment();
            statsUser = this.mbStatsUserPersistence.create(statsUserId);
            statsUser.setGroupId(groupId);
            statsUser.setUserId(userId);
            try {
                this.mbStatsUserPersistence.update((BaseModel)statsUser);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Add failed, fetch {groupId=", String.valueOf(groupId), ", userId=", String.valueOf(userId), "}"}));
                }
                if ((statsUser = this.mbStatsUserPersistence.fetchByG_U(groupId, userId, false)) != null) break block3;
                throw se;
            }
        }
        return statsUser;
    }

    public void deleteStatsUser(long statsUserId) throws PortalException {
        MBStatsUser statsUser = this.mbStatsUserPersistence.findByPrimaryKey(statsUserId);
        this.deleteStatsUser(statsUser);
    }

    public void deleteStatsUser(MBStatsUser statsUser) {
        this.mbStatsUserPersistence.remove((BaseModel)statsUser);
    }

    public void deleteStatsUsersByGroupId(long groupId) {
        List statsUsers = this.mbStatsUserPersistence.findByGroupId(groupId);
        for (MBStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public void deleteStatsUsersByUserId(long userId) {
        List statsUsers = this.mbStatsUserPersistence.findByUserId(userId);
        for (MBStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public Date getLastPostDateByUserId(long groupId, long userId) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(MBThread.class, (String)"MBStatsUser", (ClassLoader)ClassLoaderUtil.getPortalClassLoader());
        Projection projection = ProjectionFactoryUtil.max((String)"lastPostDate");
        dynamicQuery.setProjection(projection);
        Property property = PropertyFactoryUtil.forName((String)"threadId");
        Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
        QueryDefinition queryDefinition = new QueryDefinition(8);
        List threads = this.mbThreadLocalService.getGroupThreads(groupId, queryDefinition);
        for (MBThread thread : threads) {
            disjunction.add(property.ne((Object)thread.getThreadId()));
        }
        dynamicQuery.add((Criterion)disjunction);
        List results = this.mbStatsUserLocalService.dynamicQuery(dynamicQuery);
        return (Date)results.get(0);
    }

    public long getMessageCountByGroupId(long groupId) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(MBStatsUser.class, (String)"MBStatsUser", (ClassLoader)ClassLoaderUtil.getPortalClassLoader());
        Projection projection = ProjectionFactoryUtil.sum((String)"messageCount");
        dynamicQuery.setProjection(projection);
        Property property = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(property.eq((Object)groupId));
        List results = this.mbStatsUserLocalService.dynamicQuery(dynamicQuery);
        if (results.get(0) == null) {
            return 0L;
        }
        return (Long)results.get(0);
    }

    public long getMessageCountByUserId(long userId) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(MBStatsUser.class, (String)"MBStatsUser", (ClassLoader)ClassLoaderUtil.getPortalClassLoader());
        Projection projection = ProjectionFactoryUtil.sum((String)"messageCount");
        dynamicQuery.setProjection(projection);
        Property property = PropertyFactoryUtil.forName((String)"userId");
        dynamicQuery.add(property.eq((Object)userId));
        List results = this.mbStatsUserLocalService.dynamicQuery(dynamicQuery);
        if (results.get(0) == null) {
            return 0L;
        }
        return (Long)results.get(0);
    }

    public MBStatsUser getStatsUser(long groupId, long userId) {
        MBStatsUser statsUser = this.mbStatsUserPersistence.fetchByG_U(groupId, userId);
        if (statsUser == null) {
            statsUser = this.mbStatsUserLocalService.addStatsUser(groupId, userId);
        }
        return statsUser;
    }

    public List<MBStatsUser> getStatsUsersByGroupId(long groupId, int start, int end) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        return this.mbStatsUserPersistence.findByG_NotU_NotM(groupId, defaultUserId, 0, start, end);
    }

    public int getStatsUsersByGroupIdCount(long groupId) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        return this.mbStatsUserPersistence.countByG_NotU_NotM(groupId, defaultUserId, 0);
    }

    public List<MBStatsUser> getStatsUsersByUserId(long userId) {
        return this.mbStatsUserPersistence.findByUserId(userId);
    }

    public MBStatsUser updateStatsUser(long groupId, long userId) {
        return this.updateStatsUser(groupId, userId, this.getLastPostDateByUserId(groupId, userId));
    }

    public MBStatsUser updateStatsUser(long groupId, long userId, Date lastPostDate) {
        int messageCount = this.mbMessagePersistence.countByG_U_S(groupId, userId, 0);
        return this.updateStatsUser(groupId, userId, messageCount, lastPostDate);
    }

    public MBStatsUser updateStatsUser(long groupId, long userId, int messageCount, Date lastPostDate) {
        MBStatsUser statsUser = this.getStatsUser(groupId, userId);
        statsUser.setMessageCount(messageCount);
        if (lastPostDate != null) {
            statsUser.setLastPostDate(lastPostDate);
        }
        this.mbStatsUserPersistence.update((BaseModel)statsUser);
        return statsUser;
    }
}

