/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.model.BlogsStatsUser;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portlet.ratings.service.base.RatingsEntryLocalServiceBaseImpl;
import com.liferay.ratings.kernel.exception.EntryScoreException;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.model.RatingsStats;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RatingsEntryLocalServiceImpl
extends RatingsEntryLocalServiceBaseImpl {
    public void deleteEntry(long userId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
        this.ratingsEntryLocalService.deleteEntry(entry, userId, className, classPK);
    }

    @SystemEvent(type=1)
    public void deleteEntry(RatingsEntry entry, long userId, String className, long classPK) throws PortalException {
        if (entry == null) {
            return;
        }
        long classNameId = this.classNameLocalService.getClassNameId(className);
        double oldScore = entry.getScore();
        this.ratingsEntryPersistence.removeByU_C_C(userId, classNameId, classPK);
        RatingsStats stats = this.ratingsStatsLocalService.getStats(className, classPK);
        int totalEntries = stats.getTotalEntries() - 1;
        double totalScore = stats.getTotalScore() - oldScore;
        double averageScore = 0.0;
        if (totalEntries > 0) {
            averageScore = totalScore / (double)totalEntries;
        }
        stats.setTotalEntries(totalEntries);
        stats.setTotalScore(totalScore);
        stats.setAverageScore(averageScore);
        this.ratingsStatsPersistence.update((BaseModel)stats);
    }

    public RatingsEntry fetchEntry(long userId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
    }

    @Deprecated
    public List<RatingsEntry> getEntries(long userId, String className, List<Long> classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryFinder.findByU_C_C(userId, classNameId, classPKs);
    }

    public Map<Long, RatingsEntry> getEntries(long userId, String className, long[] classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        HashMap<Long, RatingsEntry> ratingsEntries = new HashMap<Long, RatingsEntry>();
        for (RatingsEntry entry : this.ratingsEntryPersistence.findByU_C_C(userId, classNameId, classPKs)) {
            ratingsEntries.put(entry.getClassPK(), entry);
        }
        return ratingsEntries;
    }

    public List<RatingsEntry> getEntries(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.findByC_C(classNameId, classPK);
    }

    public List<RatingsEntry> getEntries(String className, long classPK, double score) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.findByC_C_S(classNameId, classPK, score);
    }

    public int getEntriesCount(String className, long classPK, double score) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.countByC_C_S(classNameId, classPK, score);
    }

    public RatingsEntry getEntry(long userId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.findByU_C_C(userId, classNameId, classPK);
    }

    public RatingsEntry updateEntry(long userId, String className, long classPK, double score, ServiceContext serviceContext) throws PortalException {
        AssetEntry assetEntry;
        boolean newEntry = false;
        long classNameId = this.classNameLocalService.getClassNameId(className);
        double oldScore = 0.0;
        this.validate(score);
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
        if (entry != null) {
            oldScore = entry.getScore();
            entry.setScore(score);
            this.ratingsEntryPersistence.update((BaseModel)entry);
            RatingsStats stats = this.ratingsStatsPersistence.fetchByC_C(classNameId, classPK);
            if (stats == null) {
                stats = this.ratingsStatsLocalService.addStats(classNameId, classPK);
            }
            stats.setTotalScore(stats.getTotalScore() - oldScore + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this.ratingsStatsPersistence.update((BaseModel)stats);
        } else {
            newEntry = true;
            User user = this.userPersistence.findByPrimaryKey(userId);
            long entryId = this.counterLocalService.increment();
            entry = this.ratingsEntryPersistence.create(entryId);
            entry.setCompanyId(user.getCompanyId());
            entry.setUserId(user.getUserId());
            entry.setUserName(user.getFullName());
            entry.setClassNameId(classNameId);
            entry.setClassPK(classPK);
            entry.setScore(score);
            this.ratingsEntryPersistence.update((BaseModel)entry);
            RatingsStats stats = this.ratingsStatsPersistence.fetchByC_C(classNameId, classPK);
            if (stats == null) {
                stats = this.ratingsStatsLocalService.addStats(classNameId, classPK);
            }
            stats.setTotalEntries(stats.getTotalEntries() + 1);
            stats.setTotalScore(stats.getTotalScore() + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this.ratingsStatsPersistence.update((BaseModel)stats);
        }
        if (className.equals(BlogsEntry.class.getName())) {
            BlogsEntry blogsEntry = this.blogsEntryPersistence.findByPrimaryKey(classPK);
            BlogsStatsUser blogsStatsUser = this.blogsStatsUserLocalService.getStatsUser(blogsEntry.getGroupId(), blogsEntry.getUserId());
            int ratingsTotalEntries = blogsStatsUser.getRatingsTotalEntries();
            double ratingsTotalScore = blogsStatsUser.getRatingsTotalScore();
            double ratingsAverageScore = blogsStatsUser.getRatingsAverageScore();
            if (newEntry) {
                ++ratingsTotalEntries;
                ratingsTotalScore += score;
            } else {
                ratingsTotalScore = ratingsTotalScore - oldScore + score;
            }
            ratingsAverageScore = ratingsTotalScore / (double)ratingsTotalEntries;
            blogsStatsUser.setRatingsTotalEntries(ratingsTotalEntries);
            blogsStatsUser.setRatingsTotalScore(ratingsTotalScore);
            blogsStatsUser.setRatingsAverageScore(ratingsAverageScore);
            this.blogsStatsUserPersistence.update((BaseModel)blogsStatsUser);
        }
        if ((assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK)) != null) {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("title", assetEntry.getTitle());
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)assetEntry, (int)10004, (String)extraDataJSONObject.toString(), (long)0L);
        }
        return entry;
    }

    protected void validate(double score) throws PortalException {
        if (score > 1.0 || score < 0.0) {
            throw new EntryScoreException("Score " + score + " is not a value between 0 and 1");
        }
    }
}

