/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.util;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.trash.model.impl.TrashEntryImpl;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.model.TrashVersion;
import com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil;
import com.liferay.trash.kernel.service.TrashVersionLocalServiceUtil;
import com.liferay.trash.kernel.util.Trash;
import com.liferay.trash.kernel.util.TrashUtil;
import com.liferay.trash.kernel.util.comparator.EntryCreateDateComparator;
import com.liferay.trash.kernel.util.comparator.EntryTypeComparator;
import com.liferay.trash.kernel.util.comparator.EntryUserNameComparator;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class TrashImpl
implements Trash {
    protected final String TRASH_PREFIX = "/";
    private static final Log _log = LogFactoryUtil.getLog(TrashImpl.class);

    public void addBaseModelBreadcrumbEntries(HttpServletRequest request, LiferayPortletResponse liferayPortletResponse, String className, long classPK, PortletURL containerModelURL) throws PortalException, PortletException {
        this.addBreadcrumbEntries(request, liferayPortletResponse, className, classPK, "classPK", containerModelURL, true);
    }

    public void addContainerModelBreadcrumbEntries(HttpServletRequest request, LiferayPortletResponse liferayPortletResponse, String className, long classPK, PortletURL containerModelURL) throws PortalException, PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        String rootContainerModelTitle = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)trashHandler.getRootContainerModelName());
        if (classPK == 0L) {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)rootContainerModelTitle, null);
            return;
        }
        containerModelURL.setParameter("containerModelId", "0");
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)rootContainerModelTitle, (String)containerModelURL.toString());
        this.addBreadcrumbEntries(request, liferayPortletResponse, className, classPK, "containerModelId", containerModelURL, false);
    }

    public void addTrashSessionMessages(ActionRequest actionRequest, List<TrashedModel> trashedModels) {
        this.addTrashSessionMessages(actionRequest, trashedModels, "move_to_trash");
    }

    public void addTrashSessionMessages(ActionRequest actionRequest, List<TrashedModel> trashedModels, String cmd) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<String> classNames = new ArrayList<String>();
        ArrayList<Long> restoreTrashEntryIds = new ArrayList<Long>();
        ArrayList<String> titles = new ArrayList<String>();
        for (int i = 0; i < trashedModels.size(); ++i) {
            try {
                TrashedModel trashedModel = trashedModels.get(i);
                TrashEntry trashEntry = trashedModel.getTrashEntry();
                TrashHandler trashHandler = trashedModel.getTrashHandler();
                TrashRenderer trashRenderer = trashHandler.getTrashRenderer(trashedModel.getTrashEntryClassPK());
                classNames.add(trashRenderer.getClassName());
                restoreTrashEntryIds.add(trashEntry.getEntryId());
                titles.add(trashRenderer.getTitle(themeDisplay.getLocale()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        data.put("cmd", new String[]{cmd});
        data.put("deleteEntryClassName", ArrayUtil.toStringArray((Object[])classNames.toArray()));
        data.put("deleteEntryTitle", ArrayUtil.toStringArray((Object[])titles.toArray()));
        data.put("restoreTrashEntryIds", ArrayUtil.toStringArray((Object[])restoreTrashEntryIds.toArray()));
        SessionMessages.add((PortletRequest)actionRequest, (String)(PortalUtil.getPortletId((PortletRequest)actionRequest) + ".deleteSuccessData"), data);
    }

    public void addTrashSessionMessages(ActionRequest actionRequest, TrashedModel trashedModel) {
        this.addTrashSessionMessages(actionRequest, trashedModel, "move_to_trash");
    }

    public void addTrashSessionMessages(ActionRequest actionRequest, TrashedModel trashedModel, String cmd) {
        ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>();
        trashedModels.add(trashedModel);
        this.addTrashSessionMessages(actionRequest, trashedModels, cmd);
    }

    public void deleteEntriesAttachments(long companyId, long repositoryId, Date date, String[] attachmentFileNames) {
        for (String attachmentFileName : attachmentFileNames) {
            String trashTime = TrashUtil.getTrashTime((String)attachmentFileName, (String)"_TRASH_TIME_");
            long timestamp = GetterUtil.getLong((String)trashTime);
            if (timestamp >= date.getTime()) continue;
            DLStoreUtil.deleteDirectory((long)companyId, (long)repositoryId, (String)attachmentFileName);
        }
    }

    public Group disableTrash(Group group) {
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        typeSettingsProperties.setProperty("trashEnabled", "false");
        group.setTypeSettingsProperties(typeSettingsProperties);
        return GroupLocalServiceUtil.updateGroup((Group)group);
    }

    public List<TrashEntry> getEntries(Hits hits) {
        ArrayList<TrashEntry> entries = new ArrayList<TrashEntry>();
        for (Document document : hits.getDocs()) {
            String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
            long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                TrashEntry entry = TrashEntryLocalServiceUtil.fetchEntry((String)entryClassName, (long)classPK);
                if (entry == null) {
                    String userName = GetterUtil.getString((String)document.get("removedByUserName"));
                    Date removedDate = document.getDate("removedDate");
                    entry = new TrashEntryImpl();
                    entry.setUserName(userName);
                    entry.setCreateDate(removedDate);
                    TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entryClassName);
                    TrashRenderer trashRenderer = trashHandler.getTrashRenderer(classPK);
                    entry.setClassName(trashRenderer.getClassName());
                    entry.setClassPK(trashRenderer.getClassPK());
                    String rootEntryClassName = GetterUtil.getString((String)document.get("rootEntryClassName"));
                    long rootEntryClassPK = GetterUtil.getLong((String)document.get("rootEntryClassPK"));
                    TrashEntry rootTrashEntry = TrashEntryLocalServiceUtil.fetchEntry((String)rootEntryClassName, (long)rootEntryClassPK);
                    if (rootTrashEntry != null) {
                        entry.setRootEntry(rootTrashEntry);
                    }
                }
                entries.add(entry);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to find trash entry for ", entryClassName, " with primary key ", String.valueOf(classPK)}));
            }
        }
        return entries;
    }

    public OrderByComparator<TrashEntry> getEntryOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        EntryUserNameComparator orderByComparator = null;
        if (orderByCol.equals("removed-by")) {
            orderByComparator = new EntryUserNameComparator(orderByAsc);
        } else if (orderByCol.equals("removed-date")) {
            orderByComparator = new EntryCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("type")) {
            orderByComparator = new EntryTypeComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public int getMaxAge(Group group) {
        int trashEntriesMaxAge = PrefsPropsUtil.getInteger((long)group.getCompanyId(), (String)"trash.entries.max.age", (int)PropsValues.TRASH_ENTRIES_MAX_AGE);
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        return GetterUtil.getInteger((String)typeSettingsProperties.getProperty("trashEntriesMaxAge"), (int)trashEntriesMaxAge);
    }

    public String getNewName(String oldName, String token) {
        StringBundler sb = new StringBundler(3);
        sb.append(oldName);
        sb.append(" ");
        sb.append(token);
        return sb.toString();
    }

    public String getNewName(ThemeDisplay themeDisplay, String className, long classPK, String oldName) throws PortalException {
        TrashRenderer trashRenderer = null;
        if (Validator.isNotNull((String)className) && classPK > 0L) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
            trashRenderer = trashHandler.getTrashRenderer(classPK);
        }
        Format dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime((Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone());
        StringBundler sb = new StringBundler(3);
        sb.append("(");
        sb.append(StringUtil.replace((String)dateFormatDateTime.format(new Date()), (char[])new char[]{'/', ':'}, (char[])new char[]{'.', '.'}));
        sb.append(")");
        if (trashRenderer != null) {
            return trashRenderer.getNewName(oldName, sb.toString());
        }
        return this.getNewName(oldName, sb.toString());
    }

    public String getOriginalTitle(String title) {
        return this.getOriginalTitle(title, "title", "/");
    }

    public String getOriginalTitle(String title, String paramName) {
        return this.getOriginalTitle(title, paramName, "/");
    }

    public String getTrashTime(String title, String separator) {
        int index = title.lastIndexOf(separator);
        if (index < 0) {
            return "";
        }
        return title.substring(index + 1);
    }

    public String getTrashTitle(long trashEntryId) {
        return this.getTrashTitle(trashEntryId, "/");
    }

    public PortletURL getViewContentURL(HttpServletRequest request, long trashEntryId) throws PortalException {
        TrashEntry trashEntry = TrashEntryLocalServiceUtil.fetchEntry((long)trashEntryId);
        return this.getViewContentURL(request, trashEntry.getClassName(), trashEntry.getClassPK());
    }

    public PortletURL getViewContentURL(HttpServletRequest request, String className, long classPK) throws PortalException {
        TrashRenderer trashRenderer;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = PortletProviderUtil.getPortletId((String)TrashEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        if (!(themeDisplay.isSignedIn() && this.isTrashEnabled(themeDisplay.getScopeGroupId()) && PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (String)portletId))) {
            return null;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (trashHandler.isInTrashContainer(classPK)) {
            TrashEntry trashEntry = trashHandler.getTrashEntry(classPK);
            className = trashEntry.getClassName();
            classPK = trashEntry.getClassPK();
            trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        }
        if ((trashRenderer = trashHandler.getTrashRenderer(classPK)) == null) {
            return null;
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)request, (String)portletId, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/view_content.jsp");
        portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
        TrashEntry trashEntry = TrashEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
        if (trashEntry.getRootEntry() != null) {
            portletURL.setParameter("className", className);
            portletURL.setParameter("classPK", String.valueOf(classPK));
        } else {
            portletURL.setParameter("trashEntryId", String.valueOf(trashEntry.getEntryId()));
        }
        portletURL.setParameter("showAssetMetadata", Boolean.TRUE.toString());
        return portletURL;
    }

    public PortletURL getViewURL(HttpServletRequest request) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = PortletProviderUtil.getPortletId((String)TrashEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        if (!(themeDisplay.isSignedIn() && this.isTrashEnabled(themeDisplay.getScopeGroupId()) && PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (String)portletId))) {
            return null;
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)request, (String)portletId, (String)"RENDER_PHASE");
        portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
        return portletURL;
    }

    public boolean isInTrash(String className, long classPK) throws PortalException {
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (trashHandler == null) {
            return false;
        }
        return trashHandler.isInTrash(classPK);
    }

    public boolean isTrashEnabled(Group group) {
        boolean companyTrashEnabled = PrefsPropsUtil.getBoolean((long)group.getCompanyId(), (String)"trash.enabled");
        if (!companyTrashEnabled) {
            return false;
        }
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        return GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("trashEnabled"), (boolean)true);
    }

    public boolean isTrashEnabled(long groupId) throws PortalException {
        return this.isTrashEnabled(GroupLocalServiceUtil.getGroup((long)groupId));
    }

    public boolean isValidTrashTitle(String title) {
        return this.isValidTrashTitle(title, "/");
    }

    protected void addBreadcrumbEntries(HttpServletRequest request, LiferayPortletResponse liferayPortletResponse, String className, long classPK, String paramName, PortletURL containerModelURL, boolean checkInTrashContainers) throws PortalException, PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = PortletURLUtil.clone((PortletURL)containerModelURL, (LiferayPortletResponse)liferayPortletResponse);
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        List containerModels = trashHandler.getParentContainerModels(classPK);
        Collections.reverse(containerModels);
        for (ContainerModel containerModel : containerModels) {
            TrashHandler containerModelTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)containerModel.getModelClassName());
            if (checkInTrashContainers && !containerModelTrashHandler.isInTrash(containerModel.getContainerModelId())) continue;
            portletURL.setParameter(paramName, String.valueOf(containerModel.getContainerModelId()));
            String name = containerModel.getContainerModelName();
            if (containerModelTrashHandler.isInTrash(containerModel.getContainerModelId())) {
                name = TrashUtil.getOriginalTitle((String)name);
            }
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)name, (String)portletURL.toString());
        }
        TrashRenderer trashRenderer = trashHandler.getTrashRenderer(classPK);
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)trashRenderer.getTitle(themeDisplay.getLocale()), null);
    }

    protected String getOriginalTitle(String title, String paramName, String prefix) {
        block6: {
            if (!this.isValidTrashTitle(title, prefix)) {
                return title;
            }
            long trashEntryId = GetterUtil.getLong((String)(title = title.substring(prefix.length())));
            if (trashEntryId <= 0L) {
                return title;
            }
            try {
                TrashEntry trashEntry = TrashEntryLocalServiceUtil.fetchEntry((long)trashEntryId);
                if (trashEntry == null) {
                    TrashVersion trashVersion = TrashVersionLocalServiceUtil.getTrashVersion((long)trashEntryId);
                    title = trashVersion.getTypeSettingsProperty(paramName);
                } else {
                    title = trashEntry.getTypeSettingsProperty(paramName);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)("No trash entry or trash version exists with ID " + trashEntryId));
            }
        }
        return title;
    }

    protected String getTrashTitle(long trashEntryId, String prefix) {
        return prefix.concat(String.valueOf(trashEntryId));
    }

    protected boolean isValidTrashTitle(String title, String prefix) {
        return title.startsWith(prefix);
    }
}

