/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@OSGiBeanProperties
public class ContactIndexer
extends BaseIndexer<Contact> {
    public static final String CLASS_NAME = Contact.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(ContactIndexer.class);

    public ContactIndexer() {
        this.setStagingAware(false);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "city", false);
        this.addSearchTerm(searchQuery, searchContext, "country", false);
        this.addSearchTerm(searchQuery, searchContext, "emailAddress", false);
        this.addSearchTerm(searchQuery, searchContext, "firstName", false);
        this.addSearchTerm(searchQuery, searchContext, "fullName", false);
        this.addSearchTerm(searchQuery, searchContext, "lastName", false);
        this.addSearchTerm(searchQuery, searchContext, "middleName", false);
        this.addSearchTerm(searchQuery, searchContext, "region", false);
        this.addSearchTerm(searchQuery, searchContext, "screenName", false);
        this.addSearchTerm(searchQuery, searchContext, "street", false);
        this.addSearchTerm(searchQuery, searchContext, "zip", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(Contact contact) throws Exception {
        this.deleteDocument(contact.getCompanyId(), contact.getContactId());
    }

    protected Document doGetDocument(Contact contact) throws Exception {
        User user;
        if (contact.isUser() && ((user = UserLocalServiceUtil.fetchUserByContactId((long)contact.getContactId())) == null || user.isDefaultUser() || user.getStatus() != 0)) {
            return null;
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)contact);
        document.addKeyword("companyId", contact.getCompanyId());
        document.addDate("modified", contact.getModifiedDate());
        document.addKeyword("userId", contact.getUserId());
        document.addKeyword("userName", contact.getFullName());
        document.addText("emailAddress", contact.getEmailAddress());
        document.addText("firstName", contact.getFirstName());
        document.addText("fullName", contact.getFullName());
        document.addText("jobTitle", contact.getJobTitle());
        document.addText("lastName", contact.getLastName());
        document.addText("middleName", contact.getMiddleName());
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("email-address")) {
            return "emailAddress";
        }
        if (orderByCol.equals("first-name")) {
            return "firstName";
        }
        if (orderByCol.equals("job-title")) {
            return "jobTitle";
        }
        if (orderByCol.equals("last-name")) {
            return "lastName";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(Contact contact) throws Exception {
        Document document = this.getDocument(contact);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)contact.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        Contact contact = ContactLocalServiceUtil.getContact((long)classPK);
        this.doReindex(contact);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexContacts(companyId);
    }

    protected void reindexContacts(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = ContactLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Contact>(){

            public void performAction(Contact contact) {
                block2: {
                    try {
                        Document document = ContactIndexer.this.getDocument(contact);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index contact " + contact.getContactId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

