/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.util.HashMap;
import java.util.Map;

public class MessageValuesThreadLocal {
    private static final String _THREAD_LOCAL_KEY_PREFIX = "THREAD_LOCAL_KEY_PREFIX#";
    private static final ThreadLocal<Map<String, Object>> _messageValuesThreadLocal = new AutoResetThreadLocal<Map<String, Object>>(MessageValuesThreadLocal.class.getName());

    public static Object getValue(String key) {
        Map<String, Object> messageValues = _messageValuesThreadLocal.get();
        if (messageValues == null) {
            return null;
        }
        return messageValues.get(_THREAD_LOCAL_KEY_PREFIX.concat(key));
    }

    public static void populateMessageFromThreadLocals(Message message) {
        Map<String, Object> messageValues = _messageValuesThreadLocal.get();
        if (messageValues == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : messageValues.entrySet()) {
            message.put(entry.getKey(), entry.getValue());
        }
    }

    public static void populateThreadLocalsFromMessage(Message message) {
        Map<String, Object> values = message.getValues();
        if (values == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(_THREAD_LOCAL_KEY_PREFIX)) continue;
            MessageValuesThreadLocal.doSetValue(key, entry.getValue());
        }
    }

    public static void setValue(String key, Object value) {
        MessageValuesThreadLocal.doSetValue(_THREAD_LOCAL_KEY_PREFIX.concat(key), value);
    }

    protected static void doSetValue(String key, Object value) {
        Map<String, Object> messageValues = _messageValuesThreadLocal.get();
        if (messageValues == null) {
            messageValues = new HashMap<String, Object>();
            _messageValuesThreadLocal.set(messageValues);
        }
        messageValues.put(key, value);
    }
}

