/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.lar;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class ExportImportDateUtil {
    public static final String RANGE = "range";
    public static final String RANGE_ALL = "all";
    public static final String RANGE_DATE_RANGE = "dateRange";
    public static final String RANGE_FROM_LAST_PUBLISH_DATE = "fromLastPublishDate";
    public static final String RANGE_LAST = "last";
    private static final String _LAST_PUBLISH_DATE = "last-publish-date";
    private static final Log _log = LogFactoryUtil.getLog(ExportImportDateUtil.class);

    public static void clearLastPublishDate(long groupId, boolean privateLayout) throws PortalException {
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(groupId, privateLayout);
        UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
        settingsUnicodeProperties.remove(_LAST_PUBLISH_DATE);
        LayoutSetLocalServiceUtil.updateSettings(groupId, privateLayout, settingsUnicodeProperties.toString());
    }

    public static Calendar getCalendar(PortletRequest portletRequest, String paramPrefix, boolean timeZoneSensitive) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int dateMonth = ParamUtil.getInteger(portletRequest, paramPrefix + "Month");
        int dateDay = ParamUtil.getInteger(portletRequest, paramPrefix + "Day");
        int dateYear = ParamUtil.getInteger(portletRequest, paramPrefix + "Year");
        int dateHour = ParamUtil.getInteger(portletRequest, paramPrefix + "Hour");
        int dateMinute = ParamUtil.getInteger(portletRequest, paramPrefix + "Minute");
        int dateAmPm = ParamUtil.getInteger(portletRequest, paramPrefix + "AmPm");
        TimeZone timeZone = TimeZoneUtil.getTimeZone(ParamUtil.getString(portletRequest, "timeZoneId"));
        return ExportImportDateUtil.getCalendar(dateAmPm, dateYear, dateMonth, dateDay, dateHour, dateMinute, themeDisplay.getLocale(), timeZone, timeZoneSensitive);
    }

    public static DateRange getDateRange(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map<String, Serializable> settingsMap = exportImportConfiguration.getSettingsMap();
        String portletId = (String)((Object)settingsMap.get("portletId"));
        return ExportImportDateUtil.getDateRange(exportImportConfiguration, portletId);
    }

    public static DateRange getDateRange(ExportImportConfiguration exportImportConfiguration, String portletId) throws PortalException {
        Map<String, Serializable> settingsMap = exportImportConfiguration.getSettingsMap();
        Date startDate = (Date)settingsMap.get("startDate");
        Date endDate = (Date)settingsMap.get("endDate");
        if (startDate != null && endDate != null) {
            return new DateRange(startDate, endDate);
        }
        Map parameterMap = (Map)((Object)settingsMap.get("parameterMap"));
        String range = MapUtil.getString(parameterMap, RANGE, ExportImportDateUtil.getDefaultDateRange(exportImportConfiguration));
        int rangeLast = MapUtil.getInteger(parameterMap, RANGE_LAST);
        int startDateAmPm = MapUtil.getInteger(parameterMap, "startDateAmPm");
        int startDateYear = MapUtil.getInteger(parameterMap, "startDateYear");
        int startDateMonth = MapUtil.getInteger(parameterMap, "startDateMonth");
        int startDateDay = MapUtil.getInteger(parameterMap, "startDateDay");
        int startDateHour = MapUtil.getInteger(parameterMap, "startDateHour");
        int startDateMinute = MapUtil.getInteger(parameterMap, "startDateMinute");
        int endDateAmPm = MapUtil.getInteger(parameterMap, "endDateAmPm");
        int endDateYear = MapUtil.getInteger(parameterMap, "endDateYear");
        int endDateMonth = MapUtil.getInteger(parameterMap, "endDateMonth");
        int endDateDay = MapUtil.getInteger(parameterMap, "endDateDay");
        int endDateHour = MapUtil.getInteger(parameterMap, "endDateHour");
        int endDateMinute = MapUtil.getInteger(parameterMap, "endDateMinute");
        long groupId = MapUtil.getLong(settingsMap, "sourceGroupId");
        long plid = MapUtil.getLong(settingsMap, "sourcePlid");
        boolean privateLayout = MapUtil.getBoolean(settingsMap, "privateLayout");
        Locale locale = (Locale)settingsMap.get("locale");
        TimeZone timeZone = (TimeZone)settingsMap.get("timezone");
        return ExportImportDateUtil.getDateRange(range, rangeLast, startDateAmPm, startDateYear, startDateMonth, startDateDay, startDateHour, startDateMinute, endDateAmPm, endDateYear, endDateMonth, endDateDay, endDateHour, endDateMinute, portletId, groupId, plid, privateLayout, locale, timeZone);
    }

    public static DateRange getDateRange(long exportImportConfigurationId) throws PortalException {
        return ExportImportDateUtil.getDateRange(ExportImportConfigurationLocalServiceUtil.getExportImportConfiguration(exportImportConfigurationId));
    }

    public static DateRange getDateRange(PortletRequest portletRequest, long groupId, boolean privateLayout, long plid, String portletId, String defaultRange) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String range = ParamUtil.getString(portletRequest, RANGE, defaultRange);
        int rangeLast = ParamUtil.getInteger(portletRequest, RANGE_LAST);
        int startDateAmPm = ParamUtil.getInteger(portletRequest, "startDateAmPm");
        int startDateYear = ParamUtil.getInteger(portletRequest, "startDateYear");
        int startDateMonth = ParamUtil.getInteger(portletRequest, "startDateMonth");
        int startDateDay = ParamUtil.getInteger(portletRequest, "startDateDay");
        int startDateHour = ParamUtil.getInteger(portletRequest, "startDateHour");
        int startDateMinute = ParamUtil.getInteger(portletRequest, "startDateMinute");
        int endDateAmPm = ParamUtil.getInteger(portletRequest, "endDateAmPm");
        int endDateYear = ParamUtil.getInteger(portletRequest, "endDateYear");
        int endDateMonth = ParamUtil.getInteger(portletRequest, "endDateMonth");
        int endDateDay = ParamUtil.getInteger(portletRequest, "endDateDay");
        int endDateHour = ParamUtil.getInteger(portletRequest, "endDateHour");
        int endDateMinute = ParamUtil.getInteger(portletRequest, "endDateMinute");
        return ExportImportDateUtil.getDateRange(range, rangeLast, startDateAmPm, startDateYear, startDateMonth, startDateDay, startDateHour, startDateMinute, endDateAmPm, endDateYear, endDateMonth, endDateDay, endDateHour, endDateMinute, portletId, groupId, plid, privateLayout, themeDisplay.getLocale(), themeDisplay.getTimeZone());
    }

    public static Date getLastPublishDate(LayoutSet layoutSet) {
        long lastPublishDate = GetterUtil.getLong(layoutSet.getSettingsProperty(_LAST_PUBLISH_DATE));
        if (lastPublishDate == 0L) {
            return null;
        }
        return new Date(lastPublishDate);
    }

    public static Date getLastPublishDate(PortletDataContext portletDataContext, PortletPreferences jxPortletPreferences) throws PortalException {
        String range = MapUtil.getString(portletDataContext.getParameterMap(), RANGE);
        if (range.equals(RANGE_FROM_LAST_PUBLISH_DATE)) {
            Date portletLastPublishDate = ExportImportDateUtil.getLastPublishDate(jxPortletPreferences);
            if (portletLastPublishDate == null) {
                return null;
            }
            if (portletDataContext.getStartDate() == null) {
                return portletLastPublishDate;
            }
            if (portletLastPublishDate.before(portletDataContext.getStartDate())) {
                return portletLastPublishDate;
            }
        }
        return portletDataContext.getStartDate();
    }

    public static Date getLastPublishDate(PortletPreferences jxPortletPreferences) {
        long lastPublishDate = GetterUtil.getLong(jxPortletPreferences.getValue(_LAST_PUBLISH_DATE, ""));
        if (lastPublishDate == 0L) {
            return null;
        }
        return new Date(lastPublishDate);
    }

    public static boolean isRange(Map<String, String[]> parameterMap, String range) {
        String rangeValue = MapUtil.getString(parameterMap, RANGE);
        return rangeValue.equals(range);
    }

    public static boolean isRange(PortletDataContext portletDataContext, String range) {
        return ExportImportDateUtil.isRange(portletDataContext.getParameterMap(), range);
    }

    public static boolean isRangeAll(Map<String, String[]> parameterMap) {
        return ExportImportDateUtil.isRange(parameterMap, RANGE_ALL);
    }

    public static boolean isRangeAll(PortletDataContext portletDataContext) {
        return ExportImportDateUtil.isRange(portletDataContext, RANGE_ALL);
    }

    public static boolean isRangeDateRange(Map<String, String[]> parameterMap) {
        return ExportImportDateUtil.isRange(parameterMap, RANGE_DATE_RANGE);
    }

    public static boolean isRangeDateRange(PortletDataContext portletDataContext) {
        return ExportImportDateUtil.isRange(portletDataContext, RANGE_DATE_RANGE);
    }

    public static boolean isRangeFromLastPublishDate(Map<String, String[]> parameterMap) {
        return ExportImportDateUtil.isRange(parameterMap, RANGE_FROM_LAST_PUBLISH_DATE);
    }

    public static boolean isRangeFromLastPublishDate(PortletDataContext portletDataContext) {
        return ExportImportDateUtil.isRange(portletDataContext, RANGE_FROM_LAST_PUBLISH_DATE);
    }

    public static boolean isRangeLast(Map<String, String[]> parameterMap) {
        return ExportImportDateUtil.isRange(parameterMap, RANGE_LAST);
    }

    public static boolean isRangeLast(PortletDataContext portletDataContext) {
        return ExportImportDateUtil.isRange(portletDataContext, RANGE_LAST);
    }

    public static void updateLastPublishDate(long groupId, boolean privateLayout, DateRange dateRange, Date lastPublishDate) throws PortalException {
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(groupId, privateLayout);
        Date originalLastPublishDate = ExportImportDateUtil.getLastPublishDate(layoutSet);
        if (!ExportImportDateUtil.isValidDateRange(dateRange, originalLastPublishDate)) {
            return;
        }
        if (lastPublishDate == null) {
            lastPublishDate = new Date();
        }
        UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
        settingsUnicodeProperties.setProperty(_LAST_PUBLISH_DATE, String.valueOf(lastPublishDate.getTime()));
        LayoutSetLocalServiceUtil.updateSettings(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), settingsUnicodeProperties.toString());
    }

    public static void updateLastPublishDate(StagedGroupedModel stagedGroupedModel, DateRange dateRange, Date lastPublishDate) {
        if (lastPublishDate == null) {
            lastPublishDate = new Date();
        }
        stagedGroupedModel.setLastPublishDate(lastPublishDate);
    }

    public static void updateLastPublishDate(String portletId, PortletPreferences portletPreferences, DateRange dateRange, Date lastPublishDate) {
        Date originalLastPublishDate = ExportImportDateUtil.getLastPublishDate(portletPreferences);
        if (!ExportImportDateUtil.isValidDateRange(dateRange, originalLastPublishDate)) {
            return;
        }
        if (lastPublishDate == null) {
            lastPublishDate = new Date();
        }
        try {
            portletPreferences.setValue(_LAST_PUBLISH_DATE, String.valueOf(lastPublishDate.getTime()));
            portletPreferences.store();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (_log.isDebugEnabled()) {
                _log.debug("Not updating the portlet setup for " + portletId + " because no setup was returned for the current page");
            }
        }
        catch (Exception exception) {
            _log.error(exception, exception);
        }
    }

    protected static Calendar getCalendar(int dateAmPm, int dateYear, int dateMonth, int dateDay, int dateHour, int dateMinute, Locale locale, TimeZone timeZone, boolean timeZoneSensitive) {
        if (dateAmPm == 1) {
            dateHour += 12;
        }
        if (!timeZoneSensitive) {
            locale = LocaleUtil.getDefault();
            timeZone = TimeZoneUtil.getTimeZone("UTC");
        }
        Calendar calendar = CalendarFactoryUtil.getCalendar(timeZone, locale);
        calendar.set(2, dateMonth);
        calendar.set(5, dateDay);
        calendar.set(1, dateYear);
        calendar.set(11, dateHour);
        calendar.set(12, dateMinute);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    protected static DateRange getDateRange(String range, int rangeLast, int startDateAmPm, int startDateYear, int startDateMonth, int startDateDay, int startDateHour, int startDateMinute, int endDateAmPm, int endDateYear, int endDateMonth, int endDateDay, int endDateHour, int endDateMinute, String portletId, long groupId, long plid, boolean privateLayout, Locale locale, TimeZone timeZone) throws PortalException {
        Date startDate = null;
        Date endDate = null;
        if (range.equals(RANGE_DATE_RANGE)) {
            Calendar startCalendar = ExportImportDateUtil.getCalendar(startDateAmPm, startDateYear, startDateMonth, startDateDay, startDateHour, startDateMinute, locale, timeZone, true);
            startDate = startCalendar.getTime();
            Calendar endCalendar = ExportImportDateUtil.getCalendar(endDateAmPm, endDateYear, endDateMonth, endDateDay, endDateHour, endDateMinute, locale, timeZone, true);
            endDate = endCalendar.getTime();
        } else if (range.equals(RANGE_FROM_LAST_PUBLISH_DATE)) {
            Date lastPublishDate = null;
            if (Validator.isNotNull(portletId)) {
                Layout layout = LayoutLocalServiceUtil.fetchLayout(plid);
                PortletPreferences portletPreferences = null;
                if (layout == null) {
                    Group group = GroupLocalServiceUtil.getGroup(groupId);
                    portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup(group.getCompanyId(), groupId, portletId);
                } else {
                    portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup(layout, portletId);
                }
                lastPublishDate = ExportImportDateUtil.getLastPublishDate(portletPreferences);
            } else {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(groupId, privateLayout);
                lastPublishDate = ExportImportDateUtil.getLastPublishDate(layoutSet);
            }
            if (lastPublishDate != null) {
                endDate = new Date();
                startDate = lastPublishDate;
            }
        } else if (range.equals(RANGE_LAST)) {
            Date now = new Date();
            startDate = new Date(now.getTime() - (long)rangeLast * 3600000L);
            endDate = now;
        }
        return new DateRange(startDate, endDate);
    }

    protected static String getDefaultDateRange(ExportImportConfiguration exportImportConfiguration) {
        if (exportImportConfiguration.getType() == 0) {
            return RANGE_ALL;
        }
        if (exportImportConfiguration.getType() == 5) {
            return RANGE_ALL;
        }
        if (exportImportConfiguration.getType() == 6) {
            return RANGE_ALL;
        }
        if (exportImportConfiguration.getType() == 7) {
            return RANGE_ALL;
        }
        if (exportImportConfiguration.getType() == 1) {
            return RANGE_FROM_LAST_PUBLISH_DATE;
        }
        if (exportImportConfiguration.getType() == 2) {
            return RANGE_FROM_LAST_PUBLISH_DATE;
        }
        if (exportImportConfiguration.getType() == 8) {
            return RANGE_FROM_LAST_PUBLISH_DATE;
        }
        if (exportImportConfiguration.getType() == 9) {
            return RANGE_FROM_LAST_PUBLISH_DATE;
        }
        if (exportImportConfiguration.getType() == 3) {
            return RANGE_FROM_LAST_PUBLISH_DATE;
        }
        if (exportImportConfiguration.getType() == 4) {
            return RANGE_FROM_LAST_PUBLISH_DATE;
        }
        return RANGE_ALL;
    }

    protected static boolean isValidDateRange(DateRange dateRange, Date originalLastPublishDate) {
        if (dateRange == null) {
            return true;
        }
        Date startDate = dateRange.getStartDate();
        if (originalLastPublishDate != null) {
            if (startDate != null && startDate.after(originalLastPublishDate)) {
                return false;
            }
            Date endDate = dateRange.getEndDate();
            if (endDate != null && endDate.before(originalLastPublishDate)) {
                return false;
            }
        } else if (startDate != null) {
            return false;
        }
        return true;
    }
}

