/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassLoaderBeanHandler
implements InvocationHandler {
    private final Object _bean;
    private final ClassLoader _classLoader;

    public ClassLoaderBeanHandler(Object bean, ClassLoader classLoader) {
        this._bean = bean;
        this._classLoader = classLoader;
    }

    public Object getBean() {
        return this._bean;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            Object methodName;
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            if (method.getDeclaringClass() == Object.class && ((String)(methodName = method.getName())).equals("equals")) {
                if (proxy == arguments[0]) {
                    Boolean bl = true;
                    return bl;
                }
                Boolean bl = false;
                return bl;
            }
            methodName = method.invoke(this._bean, arguments);
            return methodName;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        finally {
            if (this._classLoader != null && contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }
}

