/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.DynamicPortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PortalCacheManagerProvider {
    private static final Map<String, DynamicPortalCacheManager<? extends Serializable, ?>> _dynamicPortalCacheManagers = new ConcurrentHashMap();
    private static final ServiceTracker<PortalCacheManager<? extends Serializable, ?>, DynamicPortalCacheManager<? extends Serializable, ?>> _serviceTracker;

    public static PortalCacheManager<? extends Serializable, ?> getPortalCacheManager(String portalCacheManagerName) {
        return _dynamicPortalCacheManagers.computeIfAbsent(portalCacheManagerName, key -> new DynamicPortalCacheManager((String)key));
    }

    public static Collection<PortalCacheManager<? extends Serializable, ?>> getPortalCacheManagers() {
        return Collections.unmodifiableCollection(_dynamicPortalCacheManagers.values());
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(PortalCacheManager.class, (ServiceTrackerCustomizer)new PortalCacheProviderServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class PortalCacheProviderServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalCacheManager<? extends Serializable, ?>, DynamicPortalCacheManager<? extends Serializable, ?>> {
        private PortalCacheProviderServiceTrackerCustomizer() {
        }

        public DynamicPortalCacheManager<? extends Serializable, ?> addingService(ServiceReference<PortalCacheManager<? extends Serializable, ?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortalCacheManager portalCacheManager = (PortalCacheManager)registry.getService(serviceReference);
            DynamicPortalCacheManager dynamicPortalCacheManager = _dynamicPortalCacheManagers.computeIfAbsent(portalCacheManager.getPortalCacheManagerName(), key -> new DynamicPortalCacheManager((String)key));
            dynamicPortalCacheManager.setPortalCacheManager(portalCacheManager);
            return dynamicPortalCacheManager;
        }

        public void modifiedService(ServiceReference<PortalCacheManager<? extends Serializable, ?>> serviceReference, DynamicPortalCacheManager<? extends Serializable, ?> dynamicPortalCacheManager) {
        }

        public void removedService(ServiceReference<PortalCacheManager<? extends Serializable, ?>> serviceReference, DynamicPortalCacheManager<? extends Serializable, ?> dynamicPortalCacheManager) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            dynamicPortalCacheManager.setPortalCacheManager(null);
        }
    }
}

