/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBInspector {
    private static final Log _log = LogFactoryUtil.getLog(DBInspector.class);
    private static final Pattern _columnSizePattern = Pattern.compile("^\\w+(?:\\((\\d+)\\))?.*", 2);
    private static final Pattern _columnTypePattern = Pattern.compile("(^\\w+)", 2);
    private final Connection _connection;

    public DBInspector(Connection connection) {
        this._connection = connection;
    }

    public String getCatalog() throws SQLException {
        return this._connection.getCatalog();
    }

    public String getSchema() {
        try {
            return this._connection.getSchema();
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug(throwable, throwable);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasColumn(String tableName, String columnName) throws Exception {
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        try (ResultSet rs = databaseMetaData.getColumns(this.getCatalog(), this.getSchema(), this.normalizeName(tableName), this.normalizeName(columnName));){
            if (!rs.next()) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            _log.error(exception, exception);
            return false;
        }
    }

    @Deprecated
    public boolean hasColumnType(Class<?> tableClass, String columnName, String columnType) throws Exception {
        Field tableNameField = tableClass.getField("TABLE_NAME");
        return this.hasColumnType((String)tableNameField.get(null), columnName, columnType);
    }

    public boolean hasColumnType(String tableName, String columnName, String columnType) throws Exception {
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        try (ResultSet rs = databaseMetaData.getColumns(this.getCatalog(), this.getSchema(), this.normalizeName(tableName, databaseMetaData), this.normalizeName(columnName, databaseMetaData));){
            if (!rs.next()) {
                boolean bl = false;
                return bl;
            }
            int expectedColumnSize = this._getColumnSize(columnType);
            int actualColumnSize = rs.getInt("COLUMN_SIZE");
            if (expectedColumnSize != -1 && expectedColumnSize != actualColumnSize) {
                boolean bl = false;
                return bl;
            }
            Integer expectedColumnDataType = this._getColumnDataType(columnType);
            int actualColumnDataType = rs.getInt("DATA_TYPE");
            if (expectedColumnDataType == null || expectedColumnDataType != actualColumnDataType) {
                boolean bl = false;
                return bl;
            }
            boolean expectedColumnNullable = this._isColumnNullable(columnType);
            int actualColumnNullable = rs.getInt("NULLABLE");
            if (expectedColumnNullable && actualColumnNullable != 1 || !expectedColumnNullable && actualColumnNullable != 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRows(String tableName) {
        try (PreparedStatement ps = this._connection.prepareStatement("select count(*) from " + tableName);
             ResultSet rs = ps.executeQuery();){
            int count;
            do {
                if (!rs.next()) return false;
            } while ((count = rs.getInt(1)) <= 0);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            _log.error(exception, exception);
        }
        return false;
    }

    public boolean hasTable(String tableName) throws Exception {
        return this.hasTable(tableName, false);
    }

    public boolean hasTable(String tableName, boolean caseSensitive) throws Exception {
        if (caseSensitive) {
            return this._hasTable(tableName);
        }
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        return this._hasTable(this.normalizeName(tableName, databaseMetaData));
    }

    public boolean isNullable(String tableName, String columnName) throws SQLException {
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        try (ResultSet rs = databaseMetaData.getColumns(this.getCatalog(), this.getSchema(), this.normalizeName(tableName, databaseMetaData), this.normalizeName(columnName, databaseMetaData));){
            if (!rs.next()) {
                throw new SQLException(StringBundler.concat((String[])new String[]{"Column ", tableName, ".", columnName, " does not exist"}));
            }
            if (rs.getInt("NULLABLE") == 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public String normalizeName(String name) throws SQLException {
        return this.normalizeName(name, this._connection.getMetaData());
    }

    public String normalizeName(String name, DatabaseMetaData databaseMetaData) throws SQLException {
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            return StringUtil.toLowerCase(name);
        }
        if (databaseMetaData.storesUpperCaseIdentifiers()) {
            return StringUtil.toUpperCase(name);
        }
        return name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasIndex(String tableName, String indexName) throws Exception {
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        try (ResultSet rs = databaseMetaData.getIndexInfo(this._connection.getCatalog(), this._connection.getSchema(), this.normalizeName(tableName, databaseMetaData), false, false);){
            do {
                if (!rs.next()) return false;
            } while (!Objects.equals(this.normalizeName(indexName, databaseMetaData), rs.getString("index_name")));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            _log.error(exception, exception);
        }
        return false;
    }

    private Integer _getColumnDataType(String columnType) {
        Matcher matcher = _columnTypePattern.matcher(columnType);
        if (!matcher.lookingAt()) {
            return null;
        }
        DB db = DBManagerUtil.getDB();
        return db.getSQLType(matcher.group(1));
    }

    private int _getColumnSize(String columnType) throws UpgradeException {
        Matcher matcher = _columnSizePattern.matcher(columnType);
        if (!matcher.matches()) {
            return -1;
        }
        String columnSize = matcher.group(1);
        if (Validator.isNotNull(columnSize)) {
            try {
                return Integer.parseInt(columnSize);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UpgradeException(StringBundler.concat((String[])new String[]{"Column type ", columnType, " has an invalid column size ", columnSize}), numberFormatException);
            }
        }
        return -1;
    }

    private boolean _hasTable(String tableName) throws Exception {
        DatabaseMetaData metadata = this._connection.getMetaData();
        try (ResultSet rs = metadata.getTables(this.getCatalog(), this.getSchema(), tableName, null);){
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean _isColumnNullable(String typeName) {
        typeName = typeName.trim();
        return !(typeName = StringUtil.toLowerCase(typeName)).endsWith("not null");
    }
}

