/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.util.StringUtil;

public class IndexMetadataFactoryUtil {
    private static final String _INDEX_NAME_PREFIX = "IX_";

    public static IndexMetadata createIndexMetadata(boolean unique, String tableName, String ... columnNames) {
        if (columnNames == null) {
            throw new NullPointerException("Column names are missing");
        }
        StringBundler sb = new StringBundler(4 + columnNames.length * 2);
        sb.append(tableName);
        sb.append(" ");
        sb.append("(");
        for (String columnName : columnNames) {
            sb.append(columnName);
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        sb.append(";");
        String specification = sb.toString();
        String specificationHash = StringUtil.toHexString(specification.hashCode());
        specificationHash = StringUtil.toUpperCase(specificationHash);
        return new IndexMetadata(_INDEX_NAME_PREFIX.concat(specificationHash), tableName, unique, columnNames);
    }

    public static IndexMetadata createIndexMetadata(String createSQL) {
        boolean unique = createSQL.contains("unique");
        int start = createSQL.indexOf(_INDEX_NAME_PREFIX);
        if (start < 0) {
            throw new IllegalArgumentException("Unable to find index name start " + createSQL);
        }
        int end = createSQL.indexOf(32, start + 3);
        String indexName = createSQL.substring(start, end);
        start = createSQL.indexOf("on ", end + 1);
        if (start < 0) {
            throw new IllegalArgumentException("Unable to find table name start " + createSQL);
        }
        end = createSQL.indexOf(32, (start += 3) + 1);
        if (end < 0) {
            throw new IllegalArgumentException("Unable to find table name end " + createSQL);
        }
        String tableName = createSQL.substring(start, end);
        start = createSQL.indexOf(40, end + 1);
        if (start < 0) {
            throw new IllegalArgumentException("Unable to find column names start " + createSQL);
        }
        if ((end = createSQL.indexOf(41, ++start + 1)) < 0) {
            throw new IllegalArgumentException("Unable to find column names end " + createSQL);
        }
        String[] columnNames = StringUtil.split(createSQL.substring(start, end), ", ");
        return new IndexMetadata(indexName, tableName, unique, columnNames);
    }
}

