/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.jdbc;

import com.liferay.portal.kernel.internal.dao.jdbc.LimitedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class OutputBlob
implements Blob {
    private InputStream _inputStream;
    private final long _length;

    public OutputBlob(InputStream inputStream, long length) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream is null");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Length is less than 0");
        }
        this._inputStream = inputStream;
        this._length = length;
    }

    @Override
    public void free() throws SQLException {
        try {
            this._inputStream.close();
        }
        catch (IOException ioException) {
            throw new SQLException(ioException.getMessage());
        }
        this._inputStream = null;
    }

    @Override
    public InputStream getBinaryStream() {
        return this._inputStream;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Position is less than 1");
        }
        long offset = pos - 1L;
        if (offset >= this._length || offset + length >= this._length) {
            throw new SQLException("Invalid range");
        }
        try {
            return new LimitedInputStream(this._inputStream, offset, length);
        }
        catch (IOException ioException) {
            throw new SQLException(ioException.getMessage());
        }
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Position is less than 1");
        }
        if (length < 0) {
            throw new SQLException("Length is less than 0");
        }
        byte[] bytes = new byte[length];
        try {
            int newLength;
            int read = -1;
            for (newLength = 0; newLength < length && (read = this._inputStream.read(bytes, newLength, length - newLength)) != -1; newLength += read) {
            }
            if (newLength < length) {
                byte[] newBytes = new byte[newLength];
                System.arraycopy(bytes, 0, newBytes, 0, newLength);
                bytes = newBytes;
            }
        }
        catch (IOException ioException) {
            throw new SQLException(ioException.getMessage());
        }
        return bytes;
    }

    @Override
    public long length() {
        return this._length;
    }

    @Override
    public long position(Blob pattern, long start) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position(byte[] pattern, long start) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void truncate(long length) {
        throw new UnsupportedOperationException();
    }
}

