/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.ScrollableResults;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.RandomUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class QueryUtil {
    public static final int ALL_POS = -1;
    private static final Log _log = LogFactoryUtil.getLog(QueryUtil.class);

    public static Iterator<?> iterate(Query query, Dialect dialect, int start, int end) {
        return QueryUtil.iterate(query, dialect, start, end, true);
    }

    public static Iterator<?> iterate(Query query, Dialect dialect, int start, int end, boolean unmodifiable) {
        List<?> list = QueryUtil.list(query, dialect, start, end);
        return list.iterator();
    }

    public static List<?> list(Query query, Dialect dialect, int start, int end) {
        return QueryUtil.list(query, dialect, start, end, true);
    }

    public static List<?> list(Query query, Dialect dialect, int start, int end, boolean unmodifiable) {
        if (start == -1 && end == -1) {
            return query.list(unmodifiable);
        }
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        if (start == end) {
            if (unmodifiable) {
                return Collections.emptyList();
            }
            return new ArrayList();
        }
        if (dialect.supportsLimit()) {
            query.setMaxResults(end - start);
            query.setFirstResult(start);
            return query.list(unmodifiable);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        DB db = DBManagerUtil.getDB();
        if (!db.isSupportsScrollableResults()) {
            if (_log.isWarnEnabled()) {
                _log.warn("Database does not support scrollable results");
            }
            return list;
        }
        ScrollableResults sr = query.scroll();
        if (sr.first() && sr.scroll(start)) {
            for (int i = start; i < end; ++i) {
                Object[] array = sr.get();
                if (array.length == 1) {
                    list.add(array[0]);
                } else {
                    list.add(array);
                }
                if (!sr.next()) break;
            }
        }
        if (unmodifiable) {
            return Collections.unmodifiableList(list);
        }
        return list;
    }

    public static List<?> randomList(Query query, Dialect dialect, int total, int num) {
        return QueryUtil.randomList(query, dialect, total, num, true);
    }

    public static List<?> randomList(Query query, Dialect dialect, int total, int num, boolean unmodifiable) {
        int[] scrollIds;
        if (total == 0 || num == 0) {
            return new ArrayList();
        }
        if (num >= total) {
            return QueryUtil.list(query, dialect, -1, -1, true);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        DB db = DBManagerUtil.getDB();
        if (!db.isSupportsScrollableResults()) {
            if (_log.isWarnEnabled()) {
                _log.warn("Database does not support scrollable results");
            }
            return list;
        }
        ScrollableResults sr = query.scroll();
        for (int scrollId : scrollIds = RandomUtil.nextInts(total, num)) {
            if (!sr.scroll(scrollId)) continue;
            Object[] array = sr.get();
            if (array.length == 1) {
                list.add(array[0]);
            } else {
                list.add(array);
            }
            sr.first();
        }
        if (unmodifiable) {
            return Collections.unmodifiableList(list);
        }
        return list;
    }
}

