/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployScanner;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutoDeployDir {
    public static final String DEFAULT_NAME = "defaultAutoDeployDir";
    private static final Log _log = LogFactoryUtil.getLog(AutoDeployDir.class);
    private static AutoDeployScanner _autoDeployScanner;
    private static final ServiceTrackerList<AutoDeployListener> _serviceTrackerList;
    private static final Pattern _versionPattern;
    private final List<AutoDeployListener> _autoDeployListeners;
    private final Map<String, Long> _blacklistFileTimestamps;
    private final File _deployDir;
    private final File _destDir;
    private final long _interval;
    private final String _name;

    public static void deploy(AutoDeploymentContext autoDeploymentContext, List<AutoDeployListener> autoDeployListeners) throws AutoDeployException {
        Object[] dirNames;
        if (_serviceTrackerList != null) {
            for (AutoDeployListener autoDeployListener : _serviceTrackerList) {
                if (!autoDeployListener.isDeployable(autoDeploymentContext)) continue;
                autoDeployListener.deploy(autoDeploymentContext);
                File file = autoDeploymentContext.getFile();
                file.delete();
                return;
            }
        }
        if (ArrayUtil.isEmpty(dirNames = PropsUtil.getArray("module.framework.auto.deploy.dirs"))) {
            throw new AutoDeployException("The portal property \"module.framework.auto.deploy.dirs\" is not set");
        }
        Object dirName = dirNames[0];
        File file = autoDeploymentContext.getFile();
        String fileName = file.getName();
        if (StringUtil.endsWith(fileName, ".cfg")) {
            for (Object curDirName : dirNames) {
                if (!((String)curDirName).endsWith("/configs")) continue;
                dirName = curDirName;
                break;
            }
        } else {
            if (StringUtil.endsWith(fileName, ".jar") && !AutoDeployDir._isModule(file)) {
                throw new AutoDeployException(fileName + " is an invalid module");
            }
            if (StringUtil.endsWith(fileName, ".lpkg")) {
                for (Object curDirName : dirNames) {
                    if (!((String)curDirName).endsWith("/marketplace")) continue;
                    dirName = curDirName;
                    break;
                }
            } else if (StringUtil.endsWith(fileName, ".war")) {
                Matcher matcher;
                for (Object curDirName : dirNames) {
                    if (!((String)curDirName).endsWith("/war")) continue;
                    dirName = curDirName;
                    break;
                }
                if ((matcher = _versionPattern.matcher(fileName)).find()) {
                    fileName = matcher.replaceFirst(".war");
                }
            } else {
                for (Object curDirName : dirNames) {
                    if (!((String)curDirName).endsWith("/modules")) continue;
                    dirName = curDirName;
                    break;
                }
            }
        }
        FileUtil.move(file, new File((String)dirName, fileName));
    }

    public AutoDeployDir(String name, File deployDir, File destDir, long interval, List<AutoDeployListener> autoDeployListeners) {
        this._name = name;
        this._deployDir = deployDir;
        this._destDir = destDir;
        this._interval = interval;
        this._autoDeployListeners = new CopyOnWriteArrayList<AutoDeployListener>(autoDeployListeners);
        this._blacklistFileTimestamps = new HashMap<String, Long>();
    }

    public File getDeployDir() {
        return this._deployDir;
    }

    public File getDestDir() {
        return this._destDir;
    }

    public long getInterval() {
        return this._interval;
    }

    public List<AutoDeployListener> getListeners() {
        return this._autoDeployListeners;
    }

    public String getName() {
        return this._name;
    }

    public void registerListener(AutoDeployListener listener) {
        this._autoDeployListeners.add(listener);
    }

    public void start() {
        if (!this._deployDir.exists()) {
            boolean created;
            if (_log.isInfoEnabled()) {
                _log.info("Creating missing directory " + this._deployDir);
            }
            if (!(created = this._deployDir.mkdirs())) {
                _log.error("Directory " + this._deployDir + " could not be created");
            }
        }
        if (!(this._interval <= 0L || _autoDeployScanner != null && _autoDeployScanner.isAlive())) {
            try {
                Thread currentThread = Thread.currentThread();
                _autoDeployScanner = new AutoDeployScanner(currentThread.getThreadGroup(), AutoDeployScanner.class.getName(), this);
                _autoDeployScanner.start();
                if (_log.isInfoEnabled()) {
                    _log.info("Auto deploy scanner started for " + this._deployDir);
                }
            }
            catch (Exception exception) {
                _log.error(exception, exception);
                this.stop();
            }
        } else if (_log.isInfoEnabled()) {
            _log.info("Auto deploy scanning is disabled for " + this._deployDir);
        }
    }

    public void stop() {
        if (_autoDeployScanner != null) {
            _autoDeployScanner.pause();
        }
        _serviceTrackerList.close();
    }

    public void unregisterListener(AutoDeployListener autoDeployListener) {
        this._autoDeployListeners.remove(autoDeployListener);
    }

    protected AutoDeploymentContext buildAutoDeploymentContext(File file) {
        AutoDeploymentContext autoDeploymentContext = new AutoDeploymentContext();
        autoDeploymentContext.setFile(file);
        return autoDeploymentContext;
    }

    protected void processFile(File file) {
        String fileName = file.getName();
        if (!file.canRead()) {
            _log.error("Unable to read " + fileName);
            return;
        }
        if (!file.canWrite()) {
            _log.error("Unable to write " + fileName);
            return;
        }
        if (this._blacklistFileTimestamps.containsKey(fileName) && this._blacklistFileTimestamps.get(fileName).longValue() == file.lastModified()) {
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat((String[])new String[]{"Skip processing of ", fileName, " because it is ", "blacklisted"}));
            }
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("Processing " + fileName);
        }
        try {
            AutoDeploymentContext autoDeploymentContext = this.buildAutoDeploymentContext(file);
            AutoDeployDir.deploy(autoDeploymentContext, this._autoDeployListeners);
            return;
        }
        catch (Exception exception) {
            _log.error(exception, exception);
            if (_log.isInfoEnabled()) {
                _log.info("Add " + fileName + " to the blacklist");
            }
            this._blacklistFileTimestamps.put(fileName, file.lastModified());
            return;
        }
    }

    protected void scanDirectory() {
        File[] files = this._deployDir.listFiles();
        if (files == null) {
            return;
        }
        Set<String> blacklistedFileNames = this._blacklistFileTimestamps.keySet();
        Iterator<String> iterator = blacklistedFileNames.iterator();
        while (iterator.hasNext()) {
            String blacklistedFileName = iterator.next();
            boolean blacklistedFileExists = false;
            for (File file : files) {
                if (!StringUtil.equalsIgnoreCase(blacklistedFileName, file.getName())) continue;
                blacklistedFileExists = true;
            }
            if (blacklistedFileExists) continue;
            if (_log.isDebugEnabled()) {
                _log.debug("Remove blacklisted file " + blacklistedFileName + " because it was deleted");
            }
            iterator.remove();
        }
        for (File file : files) {
            String fileName = file.getName();
            fileName = StringUtil.toLowerCase(fileName);
            if (!file.isFile() || !fileName.endsWith(".jar") && !fileName.endsWith(".lpkg") && !fileName.endsWith(".war") && !fileName.endsWith(".xml") && !fileName.endsWith(".zip")) continue;
            this.processFile(file);
        }
    }

    private static boolean _isModule(File file) throws AutoDeployException {
        Manifest manifest = null;
        try (JarFile jarFile = new JarFile(file);){
            manifest = jarFile.getManifest();
        }
        catch (IOException ioException) {
            throw new AutoDeployException(ioException);
        }
        if (manifest == null) {
            return false;
        }
        Attributes attributes = manifest.getMainAttributes();
        String bundleSymbolicName = attributes.getValue("Bundle-SymbolicName");
        if (bundleSymbolicName == null) {
            return false;
        }
        int index = bundleSymbolicName.indexOf(59);
        if (index != -1) {
            bundleSymbolicName = bundleSymbolicName.substring(0, index);
        }
        return !bundleSymbolicName.isEmpty();
    }

    static {
        _serviceTrackerList = ServiceTrackerCollections.openList(AutoDeployListener.class);
        _versionPattern = Pattern.compile("-[\\d]+((\\.[\\d]+)+(-.+)*)\\.war$");
    }
}

