/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.portal.kernel.exception.PortalException;

public class GroupParentException
extends PortalException {
    private GroupParentException(String message) {
        super(message);
    }

    public static class MustNotHaveStagingParent
    extends GroupParentException {
        public long groupId;
        public long parentGroupId;

        public MustNotHaveStagingParent(long groupId, long parentGroupId) {
            super(String.format("Site %s cannot have a staging site %s as its parent site", groupId, parentGroupId));
            this.groupId = groupId;
            this.parentGroupId = parentGroupId;
        }
    }

    public static class MustNotHaveChildParent
    extends GroupParentException {
        public long groupId;
        public long parentGroupId;

        public MustNotHaveChildParent(long groupId, long parentGroupId) {
            super(String.format("Site %s cannot have a child site %s as its parent site", groupId, parentGroupId));
            this.groupId = groupId;
            this.parentGroupId = parentGroupId;
        }
    }

    public static class MustNotBeOwnParent
    extends GroupParentException {
        public long groupId;

        public MustNotBeOwnParent(long groupId) {
            super(String.format("Site %s cannot be its own parent site", groupId));
            this.groupId = groupId;
        }
    }
}

