/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.internal.security.permission.resource.PermissionCacheKey;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.definition.ModelResourcePermissionDefinition;
import java.util.List;
import java.util.Map;

public class DefaultModelResourcePermission<T extends GroupedModel>
implements ModelResourcePermission<T> {
    private final String _modelName;
    private final ModelResourcePermissionDefinition<T> _modelResourcePermissionDefinition;
    private final List<ModelResourcePermissionLogic<T>> _modelResourcePermissionLogics;

    public DefaultModelResourcePermission(ModelResourcePermissionDefinition<T> modelResourcePermissionDefinition, List<ModelResourcePermissionLogic<T>> modelResourcePermissionLogics) {
        this._modelResourcePermissionDefinition = modelResourcePermissionDefinition;
        this._modelResourcePermissionLogics = modelResourcePermissionLogics;
        Class<T> modelClass = modelResourcePermissionDefinition.getModelClass();
        this._modelName = modelClass.getName();
    }

    @Override
    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, primaryKey, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this._modelName, primaryKey, actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, T model, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, model, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this._modelName, this._modelResourcePermissionDefinition.getPrimaryKey(model), actionId);
        }
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        PermissionCacheKey permissionCacheKey;
        Map<Object, Object> permissionChecksMap = permissionChecker.getPermissionChecksMap();
        Boolean contains = (Boolean)permissionChecksMap.get(permissionCacheKey = new PermissionCacheKey(this._modelName, primaryKey, actionId));
        if (contains == null) {
            contains = this._contains(permissionChecker, this._modelResourcePermissionDefinition.getModel(primaryKey), actionId);
            permissionChecksMap.put(permissionCacheKey, contains);
        }
        return contains;
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, T model, String actionId) throws PortalException {
        PermissionCacheKey permissionCacheKey;
        Map<Object, Object> permissionChecksMap = permissionChecker.getPermissionChecksMap();
        Boolean contains = (Boolean)permissionChecksMap.get(permissionCacheKey = new PermissionCacheKey(this._modelName, this._modelResourcePermissionDefinition.getPrimaryKey(model), actionId));
        if (contains == null) {
            contains = this._contains(permissionChecker, model, actionId);
            permissionChecksMap.put(permissionCacheKey, contains);
        }
        return contains;
    }

    @Override
    public String getModelName() {
        return this._modelName;
    }

    @Override
    public PortletResourcePermission getPortletResourcePermission() {
        return this._modelResourcePermissionDefinition.getPortletResourcePermission();
    }

    private boolean _contains(PermissionChecker permissionChecker, T model, String actionId) throws PortalException {
        actionId = this._modelResourcePermissionDefinition.mapActionId(actionId);
        for (ModelResourcePermissionLogic<T> modelResourcePermissionLogic : this._modelResourcePermissionLogics) {
            Boolean contains = modelResourcePermissionLogic.contains(permissionChecker, this._modelName, model, actionId);
            if (contains == null) continue;
            return contains;
        }
        String primKey = String.valueOf(this._modelResourcePermissionDefinition.getPrimaryKey(model));
        if (permissionChecker.hasOwnerPermission(model.getCompanyId(), this._modelName, primKey, model.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(model.getGroupId(), this._modelName, primKey, actionId);
    }
}

