/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.json;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;

public class JSONUtil {
    public static void addToStringCollection(Collection<String> collection, JSONArray jsonArray) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            collection.add(jsonArray.getString(i));
        }
    }

    public static void addToStringCollection(Collection<String> collection, JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object value = jsonObject.opt(jsonObjectKey);
            if (value == null) continue;
            collection.add((String)value);
        }
    }

    public static JSONArray concat(JSONArray ... jsonArrays) {
        JSONArray newJSONArray = JSONUtil._createJSONArray();
        for (JSONArray jsonArray : jsonArrays) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                newJSONArray.put(jsonArray.get(i));
            }
        }
        return newJSONArray;
    }

    public static Collector<Object, JSONArray, JSONArray> createCollector() {
        return Collector.of(JSONUtil::_createJSONArray, JSONArray::put, (xva$0, xva$1) -> JSONUtil.concat(xva$0, xva$1), new Collector.Characteristics[0]);
    }

    public static boolean equals(JSONArray jsonArray1, JSONArray jsonArray2) {
        return Objects.equals(jsonArray1.toString(), jsonArray2.toString());
    }

    public static boolean equals(JSONObject jsonObject1, JSONObject jsonObject2) {
        return Objects.equals(jsonObject1.toString(), jsonObject2.toString());
    }

    public static Object getValue(Object object, String ... paths) {
        Object value = null;
        String[] parts = paths[0].split("/");
        String type = parts[0];
        String key = parts[1];
        if (type.equals("JSONArray")) {
            JSONObject jsonObject = (JSONObject)object;
            value = jsonObject.getJSONArray(key);
        } else if (type.equals("JSONObject")) {
            JSONObject jsonObject = (JSONObject)object;
            value = jsonObject.getJSONObject(key);
        } else if (type.equals("Object")) {
            if (object instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)object;
                value = jsonArray.get(GetterUtil.getInteger(key));
            } else if (object instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)object;
                value = jsonObject.get(key);
            }
        }
        if (paths.length == 1) {
            return value;
        }
        return JSONUtil.getValue(value, Arrays.copyOfRange(paths, 1, paths.length));
    }

    public static boolean getValueAsBoolean(Object object, String ... paths) {
        return GetterUtil.getBoolean(JSONUtil.getValue(object, paths));
    }

    public static double getValueAsDouble(Object object, String ... paths) {
        return GetterUtil.getDouble(JSONUtil.getValue(object, paths));
    }

    public static int getValueAsInt(Object object, String ... paths) {
        return GetterUtil.getInteger(JSONUtil.getValue(object, paths));
    }

    public static JSONArray getValueAsJSONArray(Object object, String ... paths) {
        return (JSONArray)JSONUtil.getValue(object, paths);
    }

    public static JSONObject getValueAsJSONObject(Object object, String ... paths) {
        return (JSONObject)JSONUtil.getValue(object, paths);
    }

    public static long getValueAsLong(Object object, String ... paths) {
        return GetterUtil.getLong(JSONUtil.getValue(object, paths));
    }

    public static String getValueAsString(Object object, String ... paths) {
        return String.valueOf(JSONUtil.getValue(object, paths));
    }

    public static boolean hasValue(JSONArray jsonArray, Object value) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (!Objects.equals(value, jsonArray.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isValid(String json) {
        try {
            JSONUtil._createJSONObject(json);
            return true;
        }
        catch (JSONException jsonException) {
            return false;
        }
    }

    public static JSONObject merge(JSONObject jsonObject1, JSONObject jsonObject2) throws JSONException {
        if (jsonObject1 == null) {
            return JSONUtil._createJSONObject(jsonObject2.toString());
        }
        if (jsonObject2 == null) {
            return JSONUtil._createJSONObject(jsonObject1.toString());
        }
        JSONObject jsonObject3 = JSONUtil._createJSONObject(jsonObject1.toString());
        Iterator<String> iterator = jsonObject2.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            jsonObject3.put(key, jsonObject2.get(key));
        }
        return jsonObject3;
    }

    public static JSONArray put(Object value) {
        JSONArray jsonArray = JSONUtil._createJSONArray();
        jsonArray.put(value);
        return jsonArray;
    }

    @Deprecated
    public static JSONArray put(Object ... values) {
        return JSONUtil.putAll(values);
    }

    public static JSONObject put(String key, Object value) {
        JSONObject jsonObject = JSONUtil._createJSONObject();
        return jsonObject.put(key, value);
    }

    public static JSONArray putAll(Object ... values) {
        JSONArray jsonArray = JSONUtil._createJSONArray();
        for (Object value : values) {
            jsonArray.put(value);
        }
        return jsonArray;
    }

    public static JSONArray replace(JSONArray jsonArray, String jsonObjectKey, JSONObject newJSONObject) {
        if (jsonArray == null) {
            return null;
        }
        JSONArray newJSONArray = JSONUtil._createJSONArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (Objects.equals(jsonObject.getString(jsonObjectKey), newJSONObject.getString(jsonObjectKey))) {
                newJSONArray.put(newJSONObject);
                continue;
            }
            newJSONArray.put(jsonObject);
        }
        return newJSONArray;
    }

    public static <T> T[] toArray(JSONArray jsonArray, UnsafeFunction<JSONObject, T, Exception> unsafeFunction, Class<?> clazz) throws Exception {
        List<Object> list = JSONUtil.toList(jsonArray, unsafeFunction);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <T> JSONArray toJSONArray(List<T> list, UnsafeFunction<T, Object, Exception> unsafeFunction) throws Exception {
        JSONArray jsonArray = JSONUtil._createJSONArray();
        if (list == null) {
            return jsonArray;
        }
        for (T t : list) {
            jsonArray.put(unsafeFunction.apply(t));
        }
        return jsonArray;
    }

    public static <T> JSONArray toJSONArray(Set<T> set, UnsafeFunction<T, Object, Exception> unsafeFunction) throws Exception {
        JSONArray jsonArray = JSONUtil._createJSONArray();
        if (set == null) {
            return jsonArray;
        }
        for (T t : set) {
            jsonArray.put(unsafeFunction.apply(t));
        }
        return jsonArray;
    }

    public static <T> JSONArray toJSONArray(T[] array, UnsafeFunction<T, Object, Exception> unsafeFunction) throws Exception {
        JSONArray jsonArray = JSONUtil._createJSONArray();
        if (array == null) {
            return jsonArray;
        }
        for (T t : array) {
            jsonArray.put(unsafeFunction.apply(t));
        }
        return jsonArray;
    }

    public static Map<String, JSONObject> toJSONObjectMap(JSONArray jsonArray, String jsonObjectKey) {
        HashMap<String, JSONObject> values = new HashMap<String, JSONObject>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            values.put(jsonObject.getString(jsonObjectKey), jsonObject);
        }
        return values;
    }

    public static <T> List<T> toList(JSONArray jsonArray, UnsafeFunction<JSONObject, T, Exception> unsafeFunction) throws Exception {
        if (jsonArray == null) {
            return new ArrayList();
        }
        ArrayList<Object> values = new ArrayList<Object>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            values.add(unsafeFunction.apply((Object)jsonArray.getJSONObject(i)));
        }
        return values;
    }

    public static long[] toLongArray(JSONArray jsonArray) {
        if (jsonArray == null) {
            return new long[0];
        }
        long[] values = new long[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            values[i] = jsonArray.getLong(i);
        }
        return values;
    }

    public static long[] toLongArray(JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return new long[0];
        }
        List<Long> values = JSONUtil.toLongList(jsonArray, jsonObjectKey);
        return ArrayUtil.toArray(values.toArray(new Long[0]));
    }

    public static List<Long> toLongList(JSONArray jsonArray) {
        if (jsonArray == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> values = new ArrayList<Long>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            values.add(jsonArray.getLong(i));
        }
        return values;
    }

    public static List<Long> toLongList(JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> values = new ArrayList<Long>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object value = jsonObject.opt(jsonObjectKey);
            if (value == null) continue;
            values.add(jsonObject.getLong(jsonObjectKey));
        }
        return values;
    }

    public static Set<Long> toLongSet(JSONArray jsonArray) {
        if (jsonArray == null) {
            return new HashSet<Long>();
        }
        HashSet<Long> values = new HashSet<Long>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            values.add(jsonArray.getLong(i));
        }
        return values;
    }

    public static Set<Long> toLongSet(JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return new HashSet<Long>();
        }
        HashSet<Long> values = new HashSet<Long>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object value = jsonObject.opt(jsonObjectKey);
            if (value == null) continue;
            values.add(jsonObject.getLong(jsonObjectKey));
        }
        return values;
    }

    public static Object[] toObjectArray(JSONArray jsonArray) {
        if (jsonArray == null) {
            return new Object[0];
        }
        Object[] values = new Object[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            values[i] = jsonArray.get(i);
        }
        return values;
    }

    public static Object[] toObjectArray(JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return new Object[0];
        }
        List<Object> values = JSONUtil.toObjectList(jsonArray, jsonObjectKey);
        return values.toArray(new Object[0]);
    }

    public static List<Object> toObjectList(JSONArray jsonArray) {
        if (jsonArray == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> values = new ArrayList<Object>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            values.add(jsonArray.get(i));
        }
        return values;
    }

    public static List<Object> toObjectList(JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> values = new ArrayList<Object>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object value = jsonObject.opt(jsonObjectKey);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static Set<Object> toObjectSet(JSONArray jsonArray) {
        if (jsonArray == null) {
            return new HashSet<Object>();
        }
        HashSet<Object> values = new HashSet<Object>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            values.add(jsonArray.get(i));
        }
        return values;
    }

    public static Set<Object> toObjectSet(JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return new HashSet<Object>();
        }
        HashSet<Object> values = new HashSet<Object>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object value = jsonObject.opt(jsonObjectKey);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static String toString(JSONArray jsonArray) {
        return JSONUtil._toString(jsonArray, "\t", 0);
    }

    public static String toString(JSONObject jsonObject) {
        return JSONUtil._toString(jsonObject, "\t", 0);
    }

    public static String[] toStringArray(JSONArray jsonArray) {
        if (jsonArray == null) {
            return new String[0];
        }
        String[] values = new String[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            values[i] = jsonArray.getString(i);
        }
        return values;
    }

    public static String[] toStringArray(JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return new String[0];
        }
        List<String> values = JSONUtil.toStringList(jsonArray, jsonObjectKey);
        return values.toArray(new String[0]);
    }

    public static List<String> toStringList(JSONArray jsonArray) {
        if (jsonArray == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> values = new ArrayList<String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            values.add(jsonArray.getString(i));
        }
        return values;
    }

    public static List<String> toStringList(JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> values = new ArrayList<String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object value = jsonObject.opt(jsonObjectKey);
            if (value == null) continue;
            values.add((String)value);
        }
        return values;
    }

    public static Set<String> toStringSet(JSONArray jsonArray) {
        if (jsonArray == null) {
            return new HashSet<String>();
        }
        HashSet<String> values = new HashSet<String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            values.add(jsonArray.getString(i));
        }
        return values;
    }

    public static Set<String> toStringSet(JSONArray jsonArray, String jsonObjectKey) {
        if (jsonArray == null) {
            return new HashSet<String>();
        }
        HashSet<String> values = new HashSet<String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object value = jsonObject.opt(jsonObjectKey);
            if (value == null) continue;
            values.add((String)value);
        }
        return values;
    }

    private static JSONArray _createJSONArray() {
        return JSONFactoryUtil.createJSONArray();
    }

    private static JSONObject _createJSONObject() {
        return JSONFactoryUtil.createJSONObject();
    }

    private static JSONObject _createJSONObject(String json) throws JSONException {
        return JSONFactoryUtil.createJSONObject(json);
    }

    private static String _getIndent(String indent, int level) {
        StringBundler sb = new StringBundler(level);
        for (int i = 0; i < level; ++i) {
            sb.append(indent);
        }
        return sb.toString();
    }

    private static String _getString(Object value, String indent, int level) {
        if (value instanceof JSONArray) {
            return JSONUtil._toString((JSONArray)value, indent, level);
        }
        if (value instanceof JSONObject) {
            return JSONUtil._toString((JSONObject)value, indent, level);
        }
        if (value instanceof String) {
            return StringBundler.concat((String[])new String[]{"\"", StringUtil.replace((String)value, new String[]{"\\", "\"", "\n", "\r", "\t"}, new String[]{"\\\\", "\\\"", "\\n", "\\r", "\\t"}), "\""});
        }
        return value.toString();
    }

    private static String _toString(JSONArray jsonArray, String indent, int level) {
        if (jsonArray.length() == 0) {
            return StringBundler.concat((String[])new String[]{"[\n", JSONUtil._getIndent(indent, level), "]"});
        }
        StringBundler sb = new StringBundler();
        sb.append("[");
        sb.append("\n");
        for (Object value : JSONUtil.toObjectList(jsonArray)) {
            sb.append(JSONUtil._getIndent(indent, level + 1));
            sb.append(JSONUtil._getString(value, indent, level + 1));
            sb.append(",");
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 2);
        sb.append("\n");
        sb.append(JSONUtil._getIndent(indent, level));
        sb.append("]");
        return sb.toString();
    }

    private static String _toString(JSONObject jsonObject, String indent, int level) {
        if (jsonObject.length() == 0) {
            return StringBundler.concat((String[])new String[]{"{\n", JSONUtil._getIndent(indent, level), "}"});
        }
        StringBundler sb = new StringBundler();
        sb.append("{");
        sb.append("\n");
        ArrayList<String> keys = new ArrayList<String>(jsonObject.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(JSONUtil._getIndent(indent, level + 1));
            sb.append(JSONUtil._getString(key, indent, level + 1));
            sb.append(": ");
            sb.append(JSONUtil._getString(jsonObject.get(key), indent, level + 1));
            sb.append(",");
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 2);
        sb.append("\n");
        sb.append(JSONUtil._getIndent(indent, level));
        sb.append("}");
        return sb.toString();
    }
}

