/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.mobile.device;

import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.DeviceRecognitionProvider;
import com.liferay.portal.kernel.mobile.device.KnownDevices;
import com.liferay.portal.kernel.mobile.device.NoKnownDevices;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.mobile.device.VersionableName;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DeviceDetectionUtil {
    private static volatile DeviceRecognitionProvider _deviceRecognitionProvider = ServiceProxyFactory.newServiceTrackedInstance(DeviceRecognitionProvider.class, DeviceDetectionUtil.class, "_deviceRecognitionProvider", false, true);

    public static Device detectDevice(HttpServletRequest httpServletRequest) {
        DeviceRecognitionProvider deviceRecognitionProvider = _deviceRecognitionProvider;
        if (deviceRecognitionProvider == null) {
            return UnknownDevice.getInstance();
        }
        return deviceRecognitionProvider.detectDevice(httpServletRequest);
    }

    public static DeviceRecognitionProvider getDeviceRecognitionProvider() {
        return _deviceRecognitionProvider;
    }

    public static Set<VersionableName> getKnownBrands() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getBrands();
    }

    public static Set<VersionableName> getKnownBrowsers() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getBrowsers();
    }

    public static Set<VersionableName> getKnownOperatingSystems() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getOperatingSystems();
    }

    public static Set<String> getKnownPointingMethods() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getPointingMethods();
    }

    protected static KnownDevices getKnownDevices() {
        DeviceRecognitionProvider deviceRecognitionProvider = _deviceRecognitionProvider;
        if (deviceRecognitionProvider == null) {
            return NoKnownDevices.getInstance();
        }
        return deviceRecognitionProvider.getKnownDevices();
    }
}

