/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationWrapper;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.messaging.MessageRoutingBag;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import java.rmi.RemoteException;
import java.util.Set;

public class IntrabandBridgeDestination
extends DestinationWrapper {
    public IntrabandBridgeDestination(Destination destination) {
        super(destination);
    }

    @Override
    public void send(Message message) {
        if (message.getBoolean("LOCAL_MESSAGE")) {
            this.destination.send(message);
            return;
        }
        message.setDestinationName(this.getName());
        MessageRoutingBag messageRoutingBag = (MessageRoutingBag)message.get("MESSAGE_ROUTING_BAG");
        if (messageRoutingBag == null) {
            messageRoutingBag = new MessageRoutingBag(message, true);
            message.put("MESSAGE_ROUTING_BAG", messageRoutingBag);
        }
        this.sendMessageRoutingBag(messageRoutingBag);
        try {
            Message responseMessage = messageRoutingBag.getMessage();
            responseMessage.copyTo(message);
            messageRoutingBag.setMessage(message);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        Set<MessageListener> messageListeners = this.destination.getMessageListeners();
        for (MessageListener messageListener : messageListeners) {
            try {
                messageListener.receive(message);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public void sendMessageRoutingBag(MessageRoutingBag messageRoutingBag) {
        MessageBusUtil.addDestination(this.destination);
    }

    protected void sendMessageRoutingBag(RegistrationReference registrationReference, MessageRoutingBag messageRoutingBag) {
    }

    protected String toRoutingId(SPI spi) throws RemoteException {
        return null;
    }
}

