/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.UserNotificationDefinition;
import com.liferay.portal.kernel.notifications.UserNotificationFeedEntry;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UserNotificationManagerUtil {
    private static final Log _log = LogFactoryUtil.getLog(UserNotificationManagerUtil.class);
    private static final UserNotificationManagerUtil _userNotificationManagerUtil = new UserNotificationManagerUtil();
    private final ServiceTrackerMap<String, List<UserNotificationDefinition>> _userNotificationDefinitions = ServiceTrackerCollections.openMultiValueMap(UserNotificationDefinition.class, (String)"javax.portlet.name");
    private final ConcurrentHashMap<String, List<ServiceRegistration<UserNotificationDefinition>>> _userNotificationDefinitionServiceRegistrations = new ConcurrentHashMap();
    private final Map<String, Map<String, UserNotificationHandler>> _userNotificationHandlers = new ConcurrentHashMap<String, Map<String, UserNotificationHandler>>();
    private final ServiceRegistrationMap<UserNotificationHandler> _userNotificationHandlerServiceRegistrations = new ServiceRegistrationMapImpl();
    private final ServiceTracker<UserNotificationHandler, UserNotificationHandler> _userNotificationHandlerServiceTracker;

    public static void addUserNotificationDefinition(String portletId, UserNotificationDefinition userNotificationDefinition) {
        _userNotificationManagerUtil._addUserNotificationDefinition(portletId, userNotificationDefinition);
    }

    public static void addUserNotificationHandler(UserNotificationHandler userNotificationHandler) {
        _userNotificationManagerUtil._addUserNotificationHandler(userNotificationHandler);
    }

    public static void deleteUserNotificationDefinitions(String portletId) {
        _userNotificationManagerUtil._deleteUserNotificationDefinitions(portletId);
    }

    public static void deleteUserNotificationHandler(UserNotificationHandler userNotificationHandler) {
        _userNotificationManagerUtil._deleteUserNotificationHandler(userNotificationHandler);
    }

    public static UserNotificationDefinition fetchUserNotificationDefinition(String portletId, long classNameId, int notificationType) {
        return _userNotificationManagerUtil._fetchUserNotificationDefinition(portletId, classNameId, notificationType);
    }

    public static Map<String, List<UserNotificationDefinition>> getActiveUserNotificationDefinitions() {
        return _userNotificationManagerUtil._getUserNotificationDefinitions(true);
    }

    public static Map<String, List<UserNotificationDefinition>> getUserNotificationDefinitions() {
        return _userNotificationManagerUtil._getUserNotificationDefinitions(false);
    }

    public static Map<String, Map<String, UserNotificationHandler>> getUserNotificationHandlers() {
        return Collections.unmodifiableMap(UserNotificationManagerUtil._userNotificationManagerUtil._userNotificationHandlers);
    }

    public static UserNotificationFeedEntry interpret(String selector, UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws PortalException {
        return _userNotificationManagerUtil._interpret(selector, userNotificationEvent, serviceContext);
    }

    public static boolean isDeliver(long userId, String portletId, long classNameId, int notificationType, int deliveryType) throws PortalException {
        return _userNotificationManagerUtil._isDeliver(userId, "", portletId, classNameId, notificationType, deliveryType, null);
    }

    public static boolean isDeliver(long userId, String selector, String portletId, long classNameId, int notificationType, int deliveryType, ServiceContext serviceContext) throws PortalException {
        return _userNotificationManagerUtil._isDeliver(userId, selector, portletId, classNameId, notificationType, deliveryType, serviceContext);
    }

    private UserNotificationManagerUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._userNotificationHandlerServiceTracker = registry.trackServices(UserNotificationHandler.class, (ServiceTrackerCustomizer)new UserNotificationHandlerServiceTrackerCustomizer());
        this._userNotificationHandlerServiceTracker.open();
    }

    private void _addUserNotificationDefinition(String portletId, UserNotificationDefinition userNotificationDefinition) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(UserNotificationDefinition.class, (Object)userNotificationDefinition, HashMapBuilder.put("javax.portlet.name", portletId).build());
        ArrayList<Object> serviceRegistrations = new ArrayList<Object>();
        List<ServiceRegistration<UserNotificationDefinition>> userNotificationServiceRegistrations = this._userNotificationDefinitionServiceRegistrations.get(portletId);
        if (userNotificationServiceRegistrations != null && !userNotificationServiceRegistrations.isEmpty()) {
            serviceRegistrations.addAll(userNotificationServiceRegistrations);
        }
        serviceRegistrations.add(serviceRegistration);
        this._userNotificationDefinitionServiceRegistrations.put(portletId, serviceRegistrations);
    }

    private void _addUserNotificationHandler(UserNotificationHandler userNotificationHandler) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(UserNotificationHandler.class, (Object)userNotificationHandler);
        this._userNotificationHandlerServiceRegistrations.put((Object)userNotificationHandler, (Object)serviceRegistration);
    }

    private void _deleteUserNotificationDefinitions(String portletId) {
        List<ServiceRegistration<UserNotificationDefinition>> serviceRegistrations = this._userNotificationDefinitionServiceRegistrations.get(portletId);
        for (ServiceRegistration<UserNotificationDefinition> serviceRegistration : serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private void _deleteUserNotificationHandler(UserNotificationHandler userNotificationHandler) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._userNotificationHandlerServiceRegistrations.get((Object)userNotificationHandler);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private UserNotificationDefinition _fetchUserNotificationDefinition(String portletId, long classNameId, int notificationType) {
        List userNotificationDefinitions = (List)this._userNotificationDefinitions.getService((Object)portletId);
        if (userNotificationDefinitions == null) {
            return null;
        }
        for (UserNotificationDefinition userNotificationDefinition : userNotificationDefinitions) {
            if (userNotificationDefinition.getClassNameId() != classNameId || userNotificationDefinition.getNotificationType() != notificationType) continue;
            return userNotificationDefinition;
        }
        return null;
    }

    private Map<String, List<UserNotificationDefinition>> _getUserNotificationDefinitions(boolean active) {
        ConcurrentHashMap<String, Object> userNotificationDefinitionsMap = new ConcurrentHashMap<String, Object>();
        ServiceTrackerMap<String, List<UserNotificationDefinition>> userNotificationDefinitionsServiceTrackerMap = UserNotificationManagerUtil._userNotificationManagerUtil._userNotificationDefinitions;
        for (String portletId : userNotificationDefinitionsServiceTrackerMap.keySet()) {
            Portlet portlet;
            if (active && (portlet = PortletLocalServiceUtil.getPortletById(portletId)) == null) continue;
            userNotificationDefinitionsMap.put(portletId, userNotificationDefinitionsServiceTrackerMap.getService((Object)portletId));
        }
        return Collections.unmodifiableMap(userNotificationDefinitionsMap);
    }

    private UserNotificationFeedEntry _interpret(String selector, UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws PortalException {
        Map<String, UserNotificationHandler> userNotificationHandlers = this._userNotificationHandlers.get(selector);
        if (userNotificationHandlers == null) {
            return null;
        }
        UserNotificationHandler userNotificationHandler = userNotificationHandlers.get(userNotificationEvent.getType());
        if (userNotificationHandler == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("No interpreter found for " + userNotificationEvent);
            }
            return null;
        }
        return userNotificationHandler.interpret(userNotificationEvent, serviceContext);
    }

    private boolean _isDeliver(long userId, String selector, String portletId, long classNameId, int notificationType, int deliveryType, ServiceContext serviceContext) throws PortalException {
        Map<String, UserNotificationHandler> userNotificationHandlers = this._userNotificationHandlers.get(selector);
        if (userNotificationHandlers == null) {
            return false;
        }
        UserNotificationHandler userNotificationHandler = userNotificationHandlers.get(portletId);
        if (userNotificationHandler == null) {
            return deliveryType == 10000;
        }
        return userNotificationHandler.isDeliver(userId, classNameId, notificationType, deliveryType, serviceContext);
    }

    private class UserNotificationHandlerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<UserNotificationHandler, UserNotificationHandler> {
        private UserNotificationHandlerServiceTrackerCustomizer() {
        }

        public UserNotificationHandler addingService(ServiceReference<UserNotificationHandler> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            UserNotificationHandler userNotificationHandler = (UserNotificationHandler)registry.getService(serviceReference);
            String selector = userNotificationHandler.getSelector();
            HashMap<String, UserNotificationHandler> userNotificationHandlers = (HashMap<String, UserNotificationHandler>)UserNotificationManagerUtil.this._userNotificationHandlers.get(selector);
            if (userNotificationHandlers == null) {
                userNotificationHandlers = new HashMap<String, UserNotificationHandler>();
                UserNotificationManagerUtil.this._userNotificationHandlers.put(selector, userNotificationHandlers);
            }
            userNotificationHandlers.put(userNotificationHandler.getPortletId(), userNotificationHandler);
            return userNotificationHandler;
        }

        public void modifiedService(ServiceReference<UserNotificationHandler> serviceReference, UserNotificationHandler userNotificationHandler) {
        }

        public void removedService(ServiceReference<UserNotificationHandler> serviceReference, UserNotificationHandler userNotificationHandler) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            Map userNotificationHandlers = (Map)UserNotificationManagerUtil.this._userNotificationHandlers.get(userNotificationHandler.getSelector());
            if (userNotificationHandlers == null) {
                return;
            }
            userNotificationHandlers.remove(userNotificationHandler.getPortletId());
        }
    }
}

