/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeClosable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;

public class CompanyThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(CompanyThreadLocal.class);
    private static final CentralizedThreadLocal<Long> _companyId = new CentralizedThreadLocal(CompanyThreadLocal.class + "._companyId", () -> 0L);
    private static final ThreadLocal<Boolean> _deleteInProcess = new CentralizedThreadLocal(CompanyThreadLocal.class + "._deleteInProcess", () -> Boolean.FALSE);

    public static Long getCompanyId() {
        Long companyId = (Long)_companyId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("getCompanyId " + companyId);
        }
        return companyId;
    }

    public static boolean isDeleteInProcess() {
        return _deleteInProcess.get();
    }

    public static void setCompanyId(Long companyId) {
        block8: {
            if (companyId.equals(_companyId.get())) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("setCompanyId " + companyId);
            }
            if (companyId > 0L) {
                _companyId.set((Object)companyId);
                try {
                    User defaultUser = UserLocalServiceUtil.fetchDefaultUser(companyId);
                    if (defaultUser == null) {
                        if (_log.isWarnEnabled()) {
                            _log.warn("No default user was found for company " + companyId);
                        }
                        break block8;
                    }
                    LocaleThreadLocal.setDefaultLocale(defaultUser.getLocale());
                    TimeZoneThreadLocal.setDefaultTimeZone(defaultUser.getTimeZone());
                }
                catch (Exception exception) {
                    _log.error(exception, exception);
                }
            } else {
                _companyId.set((Object)0L);
                LocaleThreadLocal.setDefaultLocale(null);
                TimeZoneThreadLocal.setDefaultTimeZone(null);
            }
        }
        CTCollectionThreadLocal.removeCTCollectionId();
    }

    public static void setDeleteInProcess(boolean deleteInProcess) {
        _deleteInProcess.set(deleteInProcess);
    }

    public static SafeClosable setInitializingCompanyId(long companyId) {
        if (companyId > 0L) {
            return _companyId.setWithSafeClosable((Object)companyId);
        }
        return _companyId.setWithSafeClosable((Object)0L);
    }
}

