/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission.resource;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Objects;

public class DynamicInheritancePermissionLogic<C extends GroupedModel, P extends GroupedModel>
implements ModelResourcePermissionLogic<C> {
    private final boolean _checkParentAccess;
    private final UnsafeFunction<C, P, ? extends PortalException> _fetchParentUnsafeFunction;
    private final ModelResourcePermission<P> _parentModelResourcePermission;
    private final PortletResourcePermission _portletResourcePermission;

    public DynamicInheritancePermissionLogic(ModelResourcePermission<P> parentModelResourcePermission, UnsafeFunction<C, P, ? extends PortalException> fetchParentUnsafeFunction, boolean checkParentAccess) {
        this._parentModelResourcePermission = Objects.requireNonNull(parentModelResourcePermission);
        this._fetchParentUnsafeFunction = Objects.requireNonNull(fetchParentUnsafeFunction);
        this._checkParentAccess = checkParentAccess;
        this._portletResourcePermission = Objects.requireNonNull(parentModelResourcePermission.getPortletResourcePermission());
    }

    @Override
    public Boolean contains(PermissionChecker permissionChecker, String name, C child, String actionId) throws PortalException {
        if (!actionId.equals("VIEW")) {
            return null;
        }
        GroupedModel parent = (GroupedModel)this._fetchParentUnsafeFunction.apply(child);
        if (parent == null) {
            if (this._portletResourcePermission.contains(permissionChecker, child.getGroupId(), "VIEW")) {
                return null;
            }
            return false;
        }
        if (this._checkParentAccess && this._parentModelResourcePermission.contains(permissionChecker, parent, "ACCESS")) {
            return null;
        }
        if (this._parentModelResourcePermission.contains(permissionChecker, parent, "VIEW")) {
            return null;
        }
        return false;
    }
}

