/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.internal.service.permission.ModelPermissionsImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ServiceContextFactory {
    private static final Log _log = LogFactoryUtil.getLog(ServiceContextFactory.class);

    public static ServiceContext getInstance(HttpServletRequest httpServletRequest) throws PortalException {
        ServiceContext serviceContext = ServiceContextFactory._getInstance(httpServletRequest);
        ServiceContextFactory._ensureValidModelPermissions(serviceContext);
        return serviceContext;
    }

    public static ServiceContext getInstance(PortletRequest portletRequest) throws PortalException {
        ServiceContext serviceContext = ServiceContextFactory._getInstance(portletRequest);
        ServiceContextFactory._ensureValidModelPermissions(serviceContext);
        return serviceContext;
    }

    public static ServiceContext getInstance(String className, HttpServletRequest httpServletRequest) throws PortalException {
        ServiceContext serviceContext = ServiceContextFactory._getInstance(httpServletRequest);
        if (className == null) {
            return serviceContext;
        }
        if (serviceContext.getModelPermissions() == null) {
            serviceContext.setModelPermissions(ModelPermissionsFactory.create(httpServletRequest, className));
        } else {
            ModelPermissions modelPermissions = serviceContext.getModelPermissions();
            modelPermissions.setResourceName(className);
        }
        Map<String, Serializable> expandoBridgeAttributes = PortalUtil.getExpandoBridgeAttributes(ExpandoBridgeFactoryUtil.getExpandoBridge(serviceContext.getCompanyId(), className), httpServletRequest);
        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        return serviceContext;
    }

    public static ServiceContext getInstance(String className, PortletRequest portletRequest) throws PortalException {
        ServiceContext serviceContext = ServiceContextFactory._getInstance(portletRequest);
        if (className == null) {
            return serviceContext;
        }
        if (serviceContext.getModelPermissions() == null) {
            serviceContext.setModelPermissions(ModelPermissionsFactory.create(portletRequest, className));
        } else {
            ModelPermissions modelPermissions = serviceContext.getModelPermissions();
            modelPermissions.setResourceName(className);
        }
        Map<String, Serializable> expandoBridgeAttributes = PortalUtil.getExpandoBridgeAttributes(ExpandoBridgeFactoryUtil.getExpandoBridge(serviceContext.getCompanyId(), className), portletRequest);
        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        return serviceContext;
    }

    public static ServiceContext getInstance(String className, UploadPortletRequest uploadPortletRequest) throws PortalException {
        return ServiceContextFactory.getInstance(className, (HttpServletRequest)uploadPortletRequest);
    }

    private static void _ensureValidModelPermissions(ServiceContext serviceContext) {
        if (serviceContext.getModelPermissions() == null) {
            serviceContext.setModelPermissions(ModelPermissionsFactory.create(ModelPermissionsImpl.RESOURCE_NAME_UNINITIALIZED));
        }
    }

    private static ServiceContext _getInstance(HttpServletRequest httpServletRequest) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            String canonicalURL;
            serviceContext.setCompanyId(themeDisplay.getCompanyId());
            serviceContext.setLanguageId(themeDisplay.getLanguageId());
            String layoutURL = PortalUtil.getLayoutURL(themeDisplay);
            String fullCanonicalURL = canonicalURL = PortalUtil.getCanonicalURL(layoutURL, themeDisplay, themeDisplay.getLayout(), true);
            if (!HttpUtil.hasProtocol(layoutURL)) {
                fullCanonicalURL = PortalUtil.getCanonicalURL(PortalUtil.getPortalURL(themeDisplay) + layoutURL, themeDisplay, themeDisplay.getLayout(), true);
            }
            serviceContext.setLayoutFullURL(fullCanonicalURL);
            serviceContext.setLayoutURL(canonicalURL);
            serviceContext.setPlid(themeDisplay.getPlid());
            serviceContext.setScopeGroupId(themeDisplay.getScopeGroupId());
            serviceContext.setSignedIn(themeDisplay.isSignedIn());
            serviceContext.setTimeZone(themeDisplay.getTimeZone());
            serviceContext.setUserId(themeDisplay.getUserId());
        } else {
            User user;
            block15: {
                serviceContext.setCompanyId(PortalUtil.getCompanyId(httpServletRequest));
                Group guestGroup = GroupLocalServiceUtil.getGroup(serviceContext.getCompanyId(), "Guest");
                serviceContext.setScopeGroupId(guestGroup.getGroupId());
                user = null;
                try {
                    user = PortalUtil.getUser(httpServletRequest);
                }
                catch (NoSuchUserException noSuchUserException) {
                    if (!_log.isDebugEnabled()) break block15;
                    _log.debug(noSuchUserException, noSuchUserException);
                }
            }
            if (user != null) {
                serviceContext.setSignedIn(!user.isDefaultUser());
                serviceContext.setUserId(user.getUserId());
            } else {
                serviceContext.setSignedIn(false);
            }
        }
        serviceContext.setPortalURL(PortalUtil.getPortalURL(httpServletRequest));
        serviceContext.setPathMain(PortalUtil.getPathMain());
        serviceContext.setPathFriendlyURLPrivateGroup(PortalUtil.getPathFriendlyURLPrivateGroup());
        serviceContext.setPathFriendlyURLPrivateUser(PortalUtil.getPathFriendlyURLPrivateUser());
        serviceContext.setPathFriendlyURLPublic(PortalUtil.getPathFriendlyURLPublic());
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Map parameters = httpServletRequest.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            Object[] values = (String[])entry.getValue();
            if (!ArrayUtil.isNotEmpty(values)) continue;
            String name = (String)entry.getKey();
            if (values.length == 1) {
                attributes.put(name, (Serializable)values[0]);
                continue;
            }
            attributes.put(name, (Serializable)values);
        }
        serviceContext.setAttributes(attributes);
        serviceContext.setCommand(ParamUtil.getString(httpServletRequest, "cmd"));
        serviceContext.setCurrentURL(PortalUtil.getCurrentURL(httpServletRequest));
        long formDateLong = ParamUtil.getLong(httpServletRequest, "formDate");
        if (formDateLong > 0L) {
            serviceContext.setFormDate(new Date(formDateLong));
        }
        serviceContext.setModelPermissions(ModelPermissionsFactory.create(httpServletRequest));
        String portletId = PortalUtil.getPortletId(httpServletRequest);
        if (Validator.isNotNull(portletId)) {
            serviceContext.setPortletId(portletId);
        }
        serviceContext.setRemoteAddr(httpServletRequest.getRemoteAddr());
        serviceContext.setRemoteHost(httpServletRequest.getRemoteHost());
        serviceContext.setRequest(httpServletRequest);
        long[] assetCategoryIds = new long[]{};
        Map parameterMap = httpServletRequest.getParameterMap();
        ArrayList<Long> assetCategoryIdsList = new ArrayList<Long>();
        boolean updateAssetCategoryIds = false;
        for (Map.Entry entry : parameterMap.entrySet()) {
            long[] assetVocabularyAssetCategoryIds;
            String name = (String)entry.getKey();
            if (!name.startsWith("assetCategoryIds")) continue;
            updateAssetCategoryIds = true;
            for (long assetCategoryId : assetVocabularyAssetCategoryIds = ParamUtil.getLongValues(httpServletRequest, name)) {
                assetCategoryIdsList.add(assetCategoryId);
            }
        }
        if (updateAssetCategoryIds) {
            assetCategoryIds = ArrayUtil.toArray(assetCategoryIdsList.toArray(new Long[0]));
        }
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetEntryVisible(ParamUtil.getBoolean(httpServletRequest, "assetEntryVisible", true));
        String assetLinkEntryIdsString = httpServletRequest.getParameter("assetLinksSearchContainerPrimaryKeys");
        if (assetLinkEntryIdsString != null) {
            serviceContext.setAssetLinkEntryIds(StringUtil.split(assetLinkEntryIdsString, 0L));
        }
        serviceContext.setAssetPriority(ParamUtil.getDouble(httpServletRequest, "assetPriority"));
        String[] assetTagNames = ParamUtil.getStringValues(httpServletRequest, "assetTagNames");
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setWorkflowAction(ParamUtil.getInteger(httpServletRequest, "workflowAction", 1));
        return serviceContext;
    }

    private static ServiceContext _getInstance(PortletRequest portletRequest) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (serviceContext != null) {
            serviceContext = (ServiceContext)serviceContext.clone();
        } else {
            serviceContext = new ServiceContext();
            serviceContext.setPathFriendlyURLPrivateGroup(PortalUtil.getPathFriendlyURLPrivateGroup());
            serviceContext.setPathFriendlyURLPrivateUser(PortalUtil.getPathFriendlyURLPrivateUser());
            serviceContext.setPathFriendlyURLPublic(PortalUtil.getPathFriendlyURLPublic());
            serviceContext.setPathMain(PortalUtil.getPathMain());
        }
        serviceContext.setCompanyId(themeDisplay.getCompanyId());
        serviceContext.setLanguageId(themeDisplay.getLanguageId());
        serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL(themeDisplay));
        serviceContext.setLayoutURL(PortalUtil.getLayoutURL(themeDisplay));
        serviceContext.setPlid(themeDisplay.getPlid());
        serviceContext.setPortalURL(PortalUtil.getPortalURL(portletRequest));
        serviceContext.setScopeGroupId(themeDisplay.getScopeGroupId());
        serviceContext.setSignedIn(themeDisplay.isSignedIn());
        serviceContext.setTimeZone(themeDisplay.getTimeZone());
        serviceContext.setUserId(themeDisplay.getUserId());
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Map parameters = portletRequest.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            Object[] values = (String[])entry.getValue();
            if (!ArrayUtil.isNotEmpty(values)) continue;
            String name = (String)entry.getKey();
            if (values.length == 1) {
                attributes.put(name, (Serializable)values[0]);
                continue;
            }
            attributes.put(name, (Serializable)values);
        }
        serviceContext.setAttributes(attributes);
        serviceContext.setCommand(ParamUtil.getString(portletRequest, "cmd"));
        serviceContext.setCurrentURL(PortalUtil.getCurrentURL(portletRequest));
        long formDateLong = ParamUtil.getLong(portletRequest, "formDate");
        if (formDateLong > 0L) {
            serviceContext.setFormDate(new Date(formDateLong));
        }
        serviceContext.setModelPermissions(ModelPermissionsFactory.create(portletRequest));
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest(portletRequest);
        String portletId = PortalUtil.getPortletId(portletRequest);
        if (Validator.isNotNull(portletId)) {
            serviceContext.setPortletId(portletId);
        }
        serviceContext.setRemoteAddr(httpServletRequest.getRemoteAddr());
        serviceContext.setRemoteHost(httpServletRequest.getRemoteHost());
        serviceContext.setRequest(httpServletRequest);
        long[] assetCategoryIds = new long[]{};
        Map parameterMap = portletRequest.getParameterMap();
        ArrayList<Long> assetCategoryIdsList = new ArrayList<Long>();
        boolean updateAssetCategoryIds = false;
        for (Map.Entry entry : parameterMap.entrySet()) {
            long[] assetVocabularyAssetCategoryIds;
            String name = (String)entry.getKey();
            if (!name.startsWith("assetCategoryIds")) continue;
            updateAssetCategoryIds = true;
            for (long assetCategoryId : assetVocabularyAssetCategoryIds = ParamUtil.getLongValues(portletRequest, name)) {
                assetCategoryIdsList.add(assetCategoryId);
            }
        }
        if (updateAssetCategoryIds) {
            assetCategoryIds = ArrayUtil.toArray(assetCategoryIdsList.toArray(new Long[0]));
        }
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetEntryVisible(ParamUtil.getBoolean(portletRequest, "assetEntryVisible", true));
        String assetLinkEntryIdsString = httpServletRequest.getParameter("assetLinksSearchContainerPrimaryKeys");
        if (assetLinkEntryIdsString != null) {
            serviceContext.setAssetLinkEntryIds(StringUtil.split(assetLinkEntryIdsString, 0L));
        }
        serviceContext.setAssetPriority(ParamUtil.getDouble(httpServletRequest, "assetPriority"));
        String[] assetTagNames = ParamUtil.getStringValues(httpServletRequest, "assetTagNames");
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setWorkflowAction(ParamUtil.getInteger(portletRequest, "workflowAction", 1));
        return serviceContext;
    }
}

