/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import java.util.function.Function;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ServiceContextFunction
implements Function<String, ServiceContext> {
    private final HttpServletRequest _httpServletRequest;
    private final PortletRequest _portletRequest;

    public ServiceContextFunction(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
        this._portletRequest = null;
    }

    public ServiceContextFunction(PortletRequest portletRequest) {
        this._portletRequest = portletRequest;
        this._httpServletRequest = null;
    }

    @Override
    public ServiceContext apply(String className) {
        try {
            if (this._portletRequest != null) {
                return ServiceContextFactory.getInstance(className, this._portletRequest);
            }
            return ServiceContextFactory.getInstance(className, this._httpServletRequest);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }
}

