/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.util.Collection;
import java.util.Locale;

public class TypedSettings {
    private static final Log _log = LogFactoryUtil.getLog(TypedSettings.class);
    private final Collection<Locale> _availableLocales;
    private final Settings _settings;

    public TypedSettings(Settings settings) {
        this(settings, LanguageUtil.getAvailableLocales());
    }

    public TypedSettings(Settings settings, Collection<Locale> availableLocales) {
        this._settings = settings;
        this._availableLocales = availableLocales;
    }

    public boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, false);
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        return GetterUtil.getBoolean(this.getValue(key, null), defaultValue);
    }

    public double getDoubleValue(String key) {
        return this.getDoubleValue(key, 0.0);
    }

    public double getDoubleValue(String key, double defaultValue) {
        return GetterUtil.getDouble(this.getValue(key, null), defaultValue);
    }

    public float getFloatValue(String key) {
        return this.getFloatValue(key, 0.0f);
    }

    public float getFloatValue(String key, float defaultValue) {
        return GetterUtil.getFloat(this.getValue(key, null), defaultValue);
    }

    public int getIntegerValue(String key) {
        return this.getIntegerValue(key, 0);
    }

    public int getIntegerValue(String key, int defaultValue) {
        return GetterUtil.getInteger(this.getValue(key, null), defaultValue);
    }

    public LocalizedValuesMap getLocalizedValuesMap(String key) {
        String value = this.getValue(key, null);
        if (JSONUtil.isValid(value)) {
            try {
                return this._toLocalizedValuesMap(JSONFactoryUtil.createJSONObject(value));
            }
            catch (JSONException jsonException) {
                _log.error(jsonException, jsonException);
            }
        }
        return this._toLocalizedValuesMap(key, value);
    }

    public long getLongValue(String key) {
        return this.getLongValue(key, 0L);
    }

    public long getLongValue(String key, long defaultValue) {
        return GetterUtil.getLong(this.getValue(key, null), defaultValue);
    }

    public String getValue(String key) {
        return this.getValue(key, "");
    }

    public String getValue(String key, String defaultValue) {
        return this._settings.getValue(key, defaultValue);
    }

    public String[] getValues(String key) {
        return this.getValues(key, StringPool.EMPTY_ARRAY);
    }

    public String[] getValues(String key, String[] defaultValue) {
        return this._settings.getValues(key, defaultValue);
    }

    public Settings getWrappedSettings() {
        return this._settings;
    }

    public void reset(String key) {
        ModifiableSettings modifiableSettings = this._settings.getModifiableSettings();
        modifiableSettings.reset(key);
    }

    public void setBooleanValue(String key, boolean value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setIntegerValue(String key, int value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setLongValue(String key, long value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, String value) {
        ModifiableSettings modifiableSettings = this._settings.getModifiableSettings();
        modifiableSettings.setValue(key, value);
    }

    public void setValues(String key, String[] values) {
        ModifiableSettings modifiableSettings = this._settings.getModifiableSettings();
        modifiableSettings.setValues(key, values);
    }

    private LocalizedValuesMap _toLocalizedValuesMap(JSONObject jsonObject) {
        String defaultValue = jsonObject.getString(LocaleUtil.toLanguageId(LocaleThreadLocal.getDefaultLocale()));
        LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap(defaultValue);
        for (Locale locale : this._availableLocales) {
            localizedValuesMap.put(locale, jsonObject.getString(LocaleUtil.toLanguageId(locale), null));
        }
        return localizedValuesMap;
    }

    private LocalizedValuesMap _toLocalizedValuesMap(String key, String defaultValue) {
        LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap(defaultValue);
        for (Locale locale : this._availableLocales) {
            String localizedPreference = LocalizationUtil.getLocalizedName(key, LocaleUtil.toLanguageId(locale));
            localizedValuesMap.put(locale, this.getValue(localizedPreference, null));
        }
        return localizedValuesMap;
    }
}

