/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.templateparser;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class TemplateNode
extends LinkedHashMap<String, Object> {
    private static final String _LAYOUT_TYPE_PRIVATE_GROUP = "private-group";
    private static final String _LAYOUT_TYPE_PRIVATE_USER = "private-user";
    private static final String _LAYOUT_TYPE_PUBLIC = "public";
    private static final Log _log = LogFactoryUtil.getLog(TemplateNode.class);
    private final Map<String, TemplateNode> _childTemplateNodes = new LinkedHashMap<String, TemplateNode>();
    private final List<TemplateNode> _siblingTemplateNodes = new ArrayList<TemplateNode>();
    private ThemeDisplay _themeDisplay;

    public TemplateNode(ThemeDisplay themeDisplay, String name, String data, String type, Map<String, String> attributes) {
        this._themeDisplay = themeDisplay;
        this.put("attributes", attributes);
        this.put("name", name);
        this.put("data", data);
        this.put("type", type);
        this.put("options", new ArrayList());
        this.put("optionsMap", new LinkedHashMap());
    }

    public void appendChild(TemplateNode templateNode) {
        this._childTemplateNodes.put(templateNode.getName(), templateNode);
        this.put(templateNode.getName(), templateNode);
    }

    public void appendChildren(List<TemplateNode> templateNodes) {
        for (TemplateNode templateNode : templateNodes) {
            this.appendChild(templateNode);
        }
    }

    public void appendOption(String option) {
        List<String> options = this.getOptions();
        options.add(option);
    }

    public void appendOptionMap(String value, String label) {
        Map<String, String> optionsMap = this.getOptionsMap();
        optionsMap.put(value, label);
    }

    public void appendOptions(List<String> options) {
        List<String> curOptions = this.getOptions();
        curOptions.addAll(options);
    }

    public void appendOptionsMap(Map<String, String> optionMap) {
        Map<String, String> optionsMap = this.getOptionsMap();
        optionsMap.putAll(optionMap);
    }

    public void appendSibling(TemplateNode templateNode) {
        this._siblingTemplateNodes.add(templateNode);
    }

    public String getAttribute(String name) {
        Map<String, String> attributes = this.getAttributes();
        if (attributes == null) {
            return "";
        }
        return attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return (Map)this.get("attributes");
    }

    public TemplateNode getChild(String name) {
        return this._childTemplateNodes.get(name);
    }

    public List<TemplateNode> getChildren() {
        return new ArrayList<TemplateNode>(this._childTemplateNodes.values());
    }

    public String getData() {
        String type = this.getType();
        if (type.equals("ddm-journal-article")) {
            return this._getLatestArticleData();
        }
        if (type.equals("document_library") || type.equals("image")) {
            return this._getFileEntryData();
        }
        if (type.equals("link_to_layout")) {
            return this._getLinkToLayoutData();
        }
        return (String)this.get("data");
    }

    public String getFriendlyUrl() {
        String type = this.getType();
        if (type.equals("ddm-journal-article") || type.equals("journal_article")) {
            return this._getDDMJournalArticleFriendlyURL();
        }
        if (type.equals("link_to_layout")) {
            return this._getLinkToLayoutFriendlyURL();
        }
        return "";
    }

    public String getName() {
        Object name = this.get("name");
        if (name == null || name instanceof String) {
            return (String)name;
        }
        return "name";
    }

    public List<String> getOptions() {
        return (List)this.get("options");
    }

    public Map<String, String> getOptionsMap() {
        return (Map)this.get("optionsMap");
    }

    public List<TemplateNode> getSiblings() {
        return this._siblingTemplateNodes;
    }

    public String getType() {
        return (String)this.get("type");
    }

    public String getUrl() {
        String type = this.getType();
        if (!type.equals("link_to_layout")) {
            return "";
        }
        long layoutGroupId = 0L;
        long layoutId = 0L;
        String layoutType = "";
        String data = (String)this.get("data");
        if (JSONUtil.isValid(data)) {
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject(data);
                layoutGroupId = jsonObject.getLong("groupId");
                layoutId = jsonObject.getLong("layoutId");
                if (jsonObject.getBoolean("privateLayout")) {
                    layoutType = _LAYOUT_TYPE_PRIVATE_GROUP;
                }
                layoutType = _LAYOUT_TYPE_PUBLIC;
            }
            catch (JSONException jsonException) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to parse JSON from data: " + data);
                }
                return "";
            }
        } else {
            layoutGroupId = this.getLayoutGroupId();
            layoutId = this.getLayoutId();
            layoutType = this.getLayoutType();
        }
        if (Validator.isNull(layoutType)) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        if (layoutType.equals(_LAYOUT_TYPE_PRIVATE_GROUP)) {
            sb.append(PortalUtil.getPathFriendlyURLPrivateGroup());
        } else if (layoutType.equals(_LAYOUT_TYPE_PRIVATE_USER)) {
            sb.append(PortalUtil.getPathFriendlyURLPrivateUser());
        } else if (layoutType.equals(_LAYOUT_TYPE_PUBLIC)) {
            sb.append(PortalUtil.getPathFriendlyURLPublic());
        } else {
            sb.append("@friendly_url_current@");
        }
        sb.append("/");
        try {
            Group group = GroupLocalServiceUtil.getGroup(layoutGroupId);
            String name = group.getFriendlyURL();
            name = name.substring(1);
            sb.append(name);
        }
        catch (Exception exception) {
            sb.append("@group_id@");
        }
        sb.append("/");
        sb.append(layoutId);
        return sb.toString();
    }

    protected long getLayoutGroupId() {
        String data = (String)this.get("data");
        int pos = data.lastIndexOf(64);
        if (pos != -1) {
            data = data.substring(pos + 1);
        }
        return GetterUtil.getLong(data);
    }

    protected long getLayoutId() {
        String data = (String)this.get("data");
        int pos = data.indexOf(64);
        if (pos != -1) {
            data = data.substring(0, pos);
        }
        return GetterUtil.getLong(data);
    }

    protected String getLayoutType() {
        String data = (String)this.get("data");
        int x = data.indexOf(64);
        int y = data.lastIndexOf(64);
        if (x != -1 && y != -1) {
            data = x == y ? data.substring(x + 1) : data.substring(x + 1, y);
        }
        return data;
    }

    private String _getDDMJournalArticleFriendlyURL() {
        if (this._themeDisplay == null) {
            return "";
        }
        String data = (String)this.get("data");
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(data);
            AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(jsonObject.getString("className"));
            if (assetRendererFactory == null) {
                return "";
            }
            long classPK = GetterUtil.getLong(jsonObject.getLong("classPK"));
            AssetRenderer<?> assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
            if (assetRenderer == null) {
                return "";
            }
            HttpServletRequest httpServletRequest = this._themeDisplay.getRequest();
            PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
            PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
            return assetRenderer.getURLViewInContext(PortalUtil.getLiferayPortletRequest(portletRequest), PortalUtil.getLiferayPortletResponse(portletResponse), "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String _getFileEntryData() {
        String data = (String)this.get("data");
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject(data);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            if (Validator.isNull(uuid) && groupId == 0L) {
                return "";
            }
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId(uuid, groupId);
            return DLUtil.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, true);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String _getLatestArticleData() {
        block8: {
            String data = (String)this.get("data");
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject(data);
                AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(jsonObject.getString("className"));
                if (assetRendererFactory == null) {
                    return "";
                }
                long classPK = GetterUtil.getLong(jsonObject.getLong("classPK"));
                AssetRenderer<?> assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
                if (assetRenderer == null) {
                    return "";
                }
                if (Objects.equals(jsonObject.getString("uuid"), assetRenderer.getUuid())) {
                    return data;
                }
                String updatedTitle = assetRenderer.getTitle(LocaleUtil.fromLanguageId(assetRenderer.getDefaultLanguageId()));
                jsonObject.put("title", updatedTitle);
                HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
                for (String languageId : assetRenderer.getAvailableLanguageIds()) {
                    Locale locale = LocaleUtil.fromLanguageId(languageId);
                    if (locale == null) continue;
                    titleMap.put(locale, assetRenderer.getTitle(locale));
                }
                jsonObject.put("titleMap", titleMap).put("uuid", assetRenderer.getUuid());
                return jsonObject.toJSONString();
            }
            catch (JSONException jsonException) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to parse JSON from data: " + data);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug(exception.getMessage());
            }
        }
        return (String)this.get("data");
    }

    private String _getLinkToLayoutData() {
        String data = (String)this.get("data");
        int pos = data.indexOf(64);
        if (pos != -1) {
            data = data.substring(0, pos);
        }
        return data;
    }

    private String _getLinkToLayoutFriendlyURL() {
        if (this._themeDisplay == null) {
            return this.getUrl();
        }
        String data = (String)this.get("data");
        if (JSONUtil.isValid(data)) {
            return this.getUrl();
        }
        String layoutType = this.getLayoutType();
        if (Validator.isNull(layoutType)) {
            return "";
        }
        long groupId = this.getLayoutGroupId();
        if (groupId == 0L) {
            groupId = this._themeDisplay.getScopeGroupId();
        }
        boolean privateLayout = layoutType.startsWith("private");
        try {
            Layout layout = LayoutLocalServiceUtil.getLayout(groupId, privateLayout, this.getLayoutId());
            String layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL(layout, this._themeDisplay);
            return HttpUtil.removeDomain(layoutFriendlyURL);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unable to get friendly URL for URL " + this._themeDisplay.getURLCurrent(), exception);
            }
            return this.getUrl();
        }
    }
}

