/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.transaction;

import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface TransactionAttribute {
    public Isolation getIsolation();

    public Propagation getPropagation();

    public boolean isReadOnly();

    public boolean isStrictReadOnly();

    public static class DefaultTransactionAttribute
    implements TransactionAttribute {
        private final Isolation _isolation;
        private final Propagation _propagation;
        private final boolean _readOnly;
        private final boolean _strictReadOnly;

        @Override
        public Isolation getIsolation() {
            return this._isolation;
        }

        @Override
        public Propagation getPropagation() {
            return this._propagation;
        }

        @Override
        public boolean isReadOnly() {
            return this._readOnly;
        }

        @Override
        public boolean isStrictReadOnly() {
            return this._strictReadOnly;
        }

        private DefaultTransactionAttribute(Builder builder) {
            this._isolation = builder._isolation;
            this._propagation = builder._propagation;
            this._readOnly = builder._readOnly;
            this._strictReadOnly = builder._strictReadOnly;
        }
    }

    public static class Builder {
        private Isolation _isolation = Isolation.DEFAULT;
        private Propagation _propagation = Propagation.REQUIRED;
        private boolean _readOnly;
        private boolean _strictReadOnly;

        public TransactionAttribute build() {
            return new DefaultTransactionAttribute(this);
        }

        public Builder setIsolation(Isolation isolation) {
            this._isolation = isolation;
            return this;
        }

        public Builder setPropagation(Propagation propagation) {
            this._propagation = propagation;
            return this;
        }

        public Builder setReadOnly(boolean readOnly) {
            this._readOnly = readOnly;
            return this;
        }

        public Builder setStrictReadOnly(boolean strictReadOnly) {
            if (strictReadOnly) {
                this._readOnly = true;
            }
            this._strictReadOnly = strictReadOnly;
            return this;
        }
    }
}

