/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.transaction;

import com.liferay.portal.kernel.transaction.NewTransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class TransactionLifecycleNotifier {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new NewTransactionLifecycleListener(){

        @Override
        protected void doCommitted(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            TransactionLifecycleNotifier.fireTransactionCommittedEvent(transactionAttribute, transactionStatus);
        }

        @Override
        protected void doCreated(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            TransactionLifecycleNotifier.fireTransactionCreatedEvent(transactionAttribute, transactionStatus);
        }

        @Override
        protected void doRollbacked(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
            TransactionLifecycleNotifier.fireTransactionRollbackedEvent(transactionAttribute, transactionStatus, throwable);
        }
    };
    private static final TransactionLifecycleNotifier _transactionLifecycleNotifier = new TransactionLifecycleNotifier();
    private final ServiceTracker<TransactionLifecycleListener, TransactionLifecycleListener> _serviceTracker;
    private final Set<TransactionLifecycleListener> _transactionLifecycleListeners = new CopyOnWriteArraySet<TransactionLifecycleListener>();

    protected static void fireTransactionCommittedEvent(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
        for (TransactionLifecycleListener transactionLifecycleListener : TransactionLifecycleNotifier._transactionLifecycleNotifier._transactionLifecycleListeners) {
            transactionLifecycleListener.committed(transactionAttribute, transactionStatus);
        }
    }

    protected static void fireTransactionCreatedEvent(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
        for (TransactionLifecycleListener transactionLifecycleListener : TransactionLifecycleNotifier._transactionLifecycleNotifier._transactionLifecycleListeners) {
            transactionLifecycleListener.created(transactionAttribute, transactionStatus);
        }
    }

    protected static void fireTransactionRollbackedEvent(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
        for (TransactionLifecycleListener transactionLifecycleListener : TransactionLifecycleNotifier._transactionLifecycleNotifier._transactionLifecycleListeners) {
            transactionLifecycleListener.rollbacked(transactionAttribute, transactionStatus, throwable);
        }
    }

    private TransactionLifecycleNotifier() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(TransactionLifecycleListener.class, (ServiceTrackerCustomizer)new TransactionLifecycleListenerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private class TransactionLifecycleListenerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<TransactionLifecycleListener, TransactionLifecycleListener> {
        private TransactionLifecycleListenerServiceTrackerCustomizer() {
        }

        public TransactionLifecycleListener addingService(ServiceReference<TransactionLifecycleListener> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            TransactionLifecycleListener transactionLifecycleListener = (TransactionLifecycleListener)registry.getService(serviceReference);
            TransactionLifecycleNotifier.this._transactionLifecycleListeners.add(transactionLifecycleListener);
            return transactionLifecycleListener;
        }

        public void modifiedService(ServiceReference<TransactionLifecycleListener> serviceReference, TransactionLifecycleListener transactionLifecycleListener) {
        }

        public void removedService(ServiceReference<TransactionLifecycleListener> serviceReference, TransactionLifecycleListener transactionLifecycleListener) {
            TransactionLifecycleNotifier.this._transactionLifecycleListeners.remove(transactionLifecycleListener);
        }
    }
}

