/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;

public abstract class BaseUpgradePortletPreferences
extends UpgradeProcess {
    @Override
    protected void doUpgrade() throws Exception {
        this.updatePortletPreferences();
    }

    protected long getCompanyId(String sql, long primaryKey) throws Exception {
        long companyId = 0L;
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setLong(1, primaryKey);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    companyId = rs.getLong("companyId");
                }
            }
        }
        return companyId;
    }

    protected Object[] getGroup(long groupId) throws Exception {
        Object[] group = null;
        try (PreparedStatement ps = this.connection.prepareStatement("select companyId from Group_ where groupId = ?");){
            ps.setLong(1, groupId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long companyId = rs.getLong("companyId");
                    group = new Object[]{groupId, companyId};
                }
            }
        }
        return group;
    }

    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        try (PreparedStatement ps = this.connection.prepareStatement("select groupId, companyId, privateLayout, layoutId from Layout where plid = ?");){
            ps.setLong(1, plid);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    long companyId = rs.getLong("companyId");
                    boolean privateLayout = rs.getBoolean("privateLayout");
                    long layoutId = rs.getLong("layoutId");
                    layout = new Object[]{groupId, companyId, privateLayout, layoutId};
                }
            }
        }
        if (layout == null) {
            layout = this.getLayoutRevision(plid);
        }
        return layout;
    }

    protected Object[] getLayoutRevision(long layoutRevisionId) throws Exception {
        Object[] layoutRevision = null;
        try (PreparedStatement ps = this.connection.prepareStatement("select groupId, companyId, privateLayout, layoutRevisionId from LayoutRevision where layoutRevisionId = ?");){
            ps.setLong(1, layoutRevisionId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    long companyId = rs.getLong("companyId");
                    boolean privateLayout = rs.getBoolean("privateLayout");
                    long layoutId = rs.getLong("layoutRevisionId");
                    layoutRevision = new Object[]{groupId, companyId, privateLayout, layoutId};
                }
            }
        }
        return layoutRevision;
    }

    protected String getLayoutUuid(long plid, long layoutId) throws Exception {
        Object[] layout = this.getLayout(plid);
        if (layout == null) {
            return null;
        }
        String uuid = null;
        try (PreparedStatement ps = this.connection.prepareStatement("select uuid_ from Layout where groupId = ? and privateLayout = ? and layoutId = ?");){
            long groupId = (Long)layout[0];
            boolean privateLayout = (Boolean)layout[2];
            ps.setLong(1, groupId);
            ps.setBoolean(2, privateLayout);
            ps.setLong(3, layoutId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    uuid = rs.getString("uuid_");
                }
            }
        }
        return uuid;
    }

    protected String[] getPortletIds() {
        return new String[0];
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        String[] portletIds = this.getPortletIds();
        if (portletIds.length == 0) {
            throw new IllegalArgumentException("Subclasses must override getPortletIds or getUpdatePortletPreferencesWhereClause");
        }
        StringBundler sb = new StringBundler(portletIds.length * 5 - 1);
        for (int i = 0; i < portletIds.length; ++i) {
            String portletId = portletIds[i];
            sb.append("PortletPreferences.portletId ");
            if (portletId.contains("%")) {
                sb.append(" like '");
                sb.append(portletId);
                sb.append("'");
            } else {
                sb.append(" = '");
                sb.append(portletId);
                sb.append("'");
            }
            if (i + 1 >= portletIds.length) continue;
            sb.append(" or ");
        }
        return sb.toString();
    }

    protected void updatePortletPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(5);
            sb.append("select portletPreferencesId, companyId, ownerId, ");
            sb.append("ownerType, plid, portletId, preferences from ");
            sb.append("PortletPreferences");
            String whereClause = this.getUpdatePortletPreferencesWhereClause();
            if (Validator.isNotNull(whereClause)) {
                sb.append(" where ");
                sb.append(whereClause);
            }
            try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "update PortletPreferences set preferences = ? where portletPreferencesId = ?");
                 PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "delete from PortletPreferences where portletPreferencesId = ?");
                 ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long portletPreferencesId = rs.getLong("portletPreferencesId");
                    long companyId = rs.getLong("companyId");
                    if (companyId > 0L) {
                        String newPreferences;
                        int ownerType = rs.getInt("ownerType");
                        long plid = rs.getLong("plid");
                        long ownerId = rs.getLong("ownerId");
                        String portletId = rs.getString("portletId");
                        String preferences = GetterUtil.getString(rs.getString("preferences"));
                        if (preferences.equals(newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences))) continue;
                        ps2.setString(1, newPreferences);
                        ps2.setLong(2, portletPreferencesId);
                        ps2.addBatch();
                        continue;
                    }
                    ps3.setLong(1, portletPreferencesId);
                    ps3.addBatch();
                }
                ps2.executeBatch();
                ps3.executeBatch();
            }
        }
    }

    protected void upgradeMultiValuePreference(PortletPreferences portletPreferences, String key) throws ReadOnlyException {
        String value = portletPreferences.getValue(key, "");
        if (Validator.isNotNull(value)) {
            portletPreferences.setValues(key, StringUtil.split(value));
        }
    }

    protected abstract String upgradePreferences(long var1, long var3, int var5, long var6, String var8, String var9) throws Exception;
}

