/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.lang.CentralizedThreadLocal;
import java.util.HashMap;
import java.util.Map;

public class DeterminateKeyGenerator {
    private static final char[] _CHARACTERS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final int _DEFAULT_LENGTH = 4;
    private static final ThreadLocal<Map<String, Integer>> _seedMap = new CentralizedThreadLocal(DeterminateKeyGenerator.class + "._seedMap", HashMap::new);

    public static String generate(String input) {
        return DeterminateKeyGenerator.generate(input, 4);
    }

    public static String generate(String input, int length) {
        if (input == null) {
            throw new IllegalArgumentException("Input is null");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Length is less than or equal to 0");
        }
        Map<String, Integer> seedMap = _seedMap.get();
        Integer previousSeed = seedMap.get(input);
        int seed = 0;
        seed = previousSeed == null ? input.hashCode() : previousSeed.intValue();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = 0;
            index = seed > 0 ? seed % 26 : -seed % 26;
            sb.append(_CHARACTERS[index]);
            seed = DeterminateKeyGenerator._nextRandom(seed);
        }
        seedMap.put(input, seed);
        return sb.toString();
    }

    public static void reset() {
        Map<String, Integer> seedMap = _seedMap.get();
        seedMap.clear();
    }

    public static void reset(String key) {
        Map<String, Integer> seedMap = _seedMap.get();
        seedMap.remove(key);
    }

    private static int _nextRandom(int seed) {
        return seed % 127773 * 16807 - seed / 127773 * 2836;
    }
}

