/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import java.util.HashMap;
import java.util.Map;

public class InheritableMap<K, V>
extends HashMap<K, V> {
    private Map<K, V> _parentMap;

    public InheritableMap() {
    }

    public InheritableMap(Map<? extends K, ? extends V> map) {
        super(map);
    }

    @Override
    public void clear() {
        super.clear();
        this._parentMap = null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this._parentMap != null && this._parentMap.containsKey(key)) {
            return true;
        }
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this._parentMap != null && this._parentMap.containsValue(value)) {
            return true;
        }
        return super.containsValue(value);
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (value != null) {
            return value;
        }
        if (this._parentMap != null) {
            return this._parentMap.get(key);
        }
        return null;
    }

    public Map<K, V> getParentMap() {
        return this._parentMap;
    }

    @Override
    public V remove(Object key) {
        Object value = super.remove(key);
        if (value != null) {
            return value;
        }
        if (this._parentMap != null) {
            return this._parentMap.remove(key);
        }
        return null;
    }

    public void setParentMap(Map<? extends K, ? extends V> parentMap) {
        this._parentMap = parentMap;
    }

    @Override
    public String toString() {
        String string = super.toString();
        String parentString = "{}";
        if (this._parentMap != null) {
            parentString = this._parentMap.toString();
        }
        if (string.length() <= 2) {
            return parentString;
        }
        StringBundler sb = new StringBundler(3);
        sb.append(string.substring(0, string.length() - 1));
        sb.append(", ");
        sb.append(parentString.substring(1));
        return sb.toString();
    }
}

