/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.kernel.util;

import java.util.Objects;

public class SocialInteractionsConfiguration {
    private final boolean _socialInteractionsFriendsEnabled;
    private final boolean _socialInteractionsSitesEnabled;
    private final SocialInteractionsType _socialInteractionsType;

    public SocialInteractionsConfiguration(boolean socialInteractionsFriendsEnabled, boolean socialInteractionsSitesEnabled, SocialInteractionsType socialInteractionsType) {
        this._socialInteractionsFriendsEnabled = socialInteractionsFriendsEnabled;
        this._socialInteractionsSitesEnabled = socialInteractionsSitesEnabled;
        this._socialInteractionsType = socialInteractionsType;
    }

    public boolean isSocialInteractionsAnyUserEnabled() {
        return this._socialInteractionsType.equals((Object)SocialInteractionsType.ALL_USERS);
    }

    public boolean isSocialInteractionsFriendsEnabled() {
        return this._socialInteractionsFriendsEnabled;
    }

    public boolean isSocialInteractionsSelectUsersEnabled() {
        return this._socialInteractionsType.equals((Object)SocialInteractionsType.SELECT_USERS);
    }

    public boolean isSocialInteractionsSitesEnabled() {
        return this._socialInteractionsSitesEnabled;
    }

    public static enum SocialInteractionsType {
        ALL_USERS("all_users"),
        SELECT_USERS("select_users");

        private final String _value;

        public static SocialInteractionsType parse(String value) {
            if (Objects.equals(ALL_USERS.getValue(), value)) {
                return ALL_USERS;
            }
            if (Objects.equals(SELECT_USERS.getValue(), value)) {
                return SELECT_USERS;
            }
            throw new IllegalArgumentException("Invalid value " + value);
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private SocialInteractionsType(String value) {
            this._value = value;
        }
    }
}

