/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationLocator {
    public static <T extends Annotation> T locate(Class<?> targetClass, Class<T> annotationClass) {
        LinkedList queue = new LinkedList();
        queue.offer(targetClass);
        return AnnotationLocator._deepSearchTypes(queue, annotationClass);
    }

    public static <T extends Annotation> T locate(Method method, Class<?> targetClass, Class<T> annotationClass) {
        LinkedList queue = new LinkedList();
        if (targetClass == null) {
            queue.offer(method.getDeclaringClass());
        } else {
            queue.offer(targetClass);
        }
        return AnnotationLocator._deepSearchMethods(queue, method, annotationClass);
    }

    private static <T extends Annotation> T _deepSearchMethods(Queue<Class<?>> queue, Method method, Class<T> annotationClass) {
        if (queue.isEmpty()) {
            return null;
        }
        T annotation = null;
        Class<?> clazz = queue.poll();
        try {
            Method specificMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            annotation = specificMethod.getAnnotation(annotationClass);
            if (annotation != null) {
                return annotation;
            }
        }
        catch (Exception exception) {}
        annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null) {
            AnnotationLocator._queueSuperTypes(queue, clazz);
            return AnnotationLocator._deepSearchMethods(queue, method, annotationClass);
        }
        return annotation;
    }

    private static <T extends Annotation> T _deepSearchTypes(Queue<Class<?>> queue, Class<T> annotationClass) {
        if (queue.isEmpty()) {
            return null;
        }
        Class<?> clazz = queue.poll();
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null) {
            AnnotationLocator._queueSuperTypes(queue, clazz);
            return AnnotationLocator._deepSearchTypes(queue, annotationClass);
        }
        return annotation;
    }

    private static void _queueSuperTypes(Queue<Class<?>> queue, Class<?> clazz) {
        Class<?>[] interfaceClasses;
        Class<?> supperClass = clazz.getSuperclass();
        if (supperClass != null && supperClass != Object.class) {
            queue.offer(supperClass);
        }
        Class<?>[] classArray = interfaceClasses = clazz.getInterfaces();
        int n = interfaceClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            queue.offer(interfaceClass);
            ++n2;
        }
    }
}

