/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterNodeResponses
implements Serializable {
    public static final ClusterNodeResponses EMPTY_CLUSTER_NODE_RESPONSES = new ClusterNodeResponses();
    private Map<Address, ClusterNodeResponse> _clusterResponsesByAddress = new HashMap<Address, ClusterNodeResponse>();
    private Map<String, ClusterNodeResponse> _clusterResponsesByClusterNode = new HashMap<String, ClusterNodeResponse>();
    private BlockingQueue<ClusterNodeResponse> _clusterResponsesQueue = new LinkedBlockingQueue<ClusterNodeResponse>();

    public void addClusterResponse(ClusterNodeResponse clusterNodeResponse) {
        this._clusterResponsesByAddress.put(clusterNodeResponse.getAddress(), clusterNodeResponse);
        ClusterNode clusterNode = clusterNodeResponse.getClusterNode();
        this._clusterResponsesByClusterNode.put(clusterNode.getClusterNodeId(), clusterNodeResponse);
        this._clusterResponsesQueue.offer(clusterNodeResponse);
    }

    public ClusterNodeResponse getClusterResponse(Address address) {
        return this._clusterResponsesByAddress.get(address);
    }

    public ClusterNodeResponse getClusterResponse(ClusterNode clusterNode) {
        return this.getClusterResponse(clusterNode.getClusterNodeId());
    }

    public ClusterNodeResponse getClusterResponse(String clusterNodeId) {
        return this._clusterResponsesByClusterNode.get(clusterNodeId);
    }

    public BlockingQueue<ClusterNodeResponse> getClusterResponses() {
        return this._clusterResponsesQueue;
    }

    public int size() {
        return this._clusterResponsesByClusterNode.size();
    }
}

